/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.TransformationFunction;
import com.logicalclocks.hsfs.util.Constants;

public class TrainingDatasetFeature {
    private String name;
    private String type;
    private FeatureGroupBase featureGroup;
    private Integer index;
    private Boolean label = false;
    private TransformationFunction transformationFunction;

    public TrainingDatasetFeature(String name, String type) {
        this.setName(name);
        this.type = type;
    }

    public TrainingDatasetFeature(String name, String type, Integer index) {
        this.setName(name);
        this.type = type;
        this.index = index;
    }

    public TrainingDatasetFeature(String name, String type, Integer index, Boolean label) {
        this.setName(name);
        this.type = type;
        this.index = index;
        this.label = label;
    }

    public TrainingDatasetFeature(FeatureGroupBase featuregroup, String name, Boolean label) {
        this.setName(name);
        this.featureGroup = featuregroup;
        this.label = label;
    }

    public void setName(String name) {
        this.name = name.toLowerCase();
    }

    public boolean isComplex() {
        return this.label == false && Constants.COMPLEX_FEATURE_TYPES.stream().anyMatch(c -> this.type.toUpperCase().startsWith((String)c));
    }

    public static TrainingDatasetFeatureBuilder builder() {
        return new TrainingDatasetFeatureBuilder();
    }

    public TrainingDatasetFeature() {
    }

    public TrainingDatasetFeature(String name, String type, FeatureGroupBase featureGroup, Integer index, Boolean label, TransformationFunction transformationFunction) {
        this.name = name;
        this.type = type;
        this.featureGroup = featureGroup;
        this.index = index;
        this.label = label;
        this.transformationFunction = transformationFunction;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public FeatureGroupBase getFeatureGroup() {
        return this.featureGroup;
    }

    public void setFeatureGroup(FeatureGroupBase featureGroup) {
        this.featureGroup = featureGroup;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Boolean getLabel() {
        return this.label;
    }

    public void setLabel(Boolean label) {
        this.label = label;
    }

    public TransformationFunction getTransformationFunction() {
        return this.transformationFunction;
    }

    public void setTransformationFunction(TransformationFunction transformationFunction) {
        this.transformationFunction = transformationFunction;
    }

    public static class TrainingDatasetFeatureBuilder {
        private String name;
        private String type;

        TrainingDatasetFeatureBuilder() {
        }

        public TrainingDatasetFeatureBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TrainingDatasetFeatureBuilder type(String type) {
            this.type = type;
            return this;
        }

        public TrainingDatasetFeature build() {
            return new TrainingDatasetFeature(this.name, this.type);
        }

        public String toString() {
            return "TrainingDatasetFeature.TrainingDatasetFeatureBuilder(name=" + this.name + ", type=" + this.type + ")";
        }
    }
}

