/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.FeatureViewBase;
import com.logicalclocks.hsfs.TrainingDatasetBase;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.Tags;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagsApi {
    public static final String ENTITY_ROOT_PATH = "{/entityType}";
    public static final String ENTITY_ID_PATH = "{/entityType}{/entityId}";
    public static final String TAGS_PATH = "{/entityType}{/entityId}/tags{/name}{?value}";
    public static final String FV_TAGS_PATH = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featureview{/fvName}/version{/fvVersion}/tags{/name}";
    public static final String FV_TD_TAGS_PATH = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featureview{/fvName}/version{/fvVersion}/trainingdatasets/version{/tdVersion}/tags{/name}";
    private static final Logger LOGGER = LoggerFactory.getLogger(TagsApi.class);
    private EntityEndpointType entityType;

    public TagsApi(@NonNull EntityEndpointType entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        this.entityType = entityType;
    }

    private void add(Integer featurestoreId, Integer entityId, String name, Object value) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/tags{/name}{?value}";
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)featurestoreId).set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId).set("name", (Object)name);
        this.add(uriTemplate, value);
    }

    private void add(UriTemplate uriTemplate, Object value) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        LOGGER.info("Sending metadata request: " + uriTemplate.expand());
        HttpPut putRequest = new HttpPut(uriTemplate.expand());
        putRequest.setEntity((HttpEntity)hopsworksClient.buildStringEntity(value));
        hopsworksClient.handleRequest((HttpRequest)putRequest);
    }

    public void add(FeatureGroupBase featureGroupBase, String name, Object value) throws FeatureStoreException, IOException {
        this.add(featureGroupBase.getFeatureStore().getId(), featureGroupBase.getId(), name, value);
    }

    public void add(TrainingDatasetBase trainingDatasetBase, String name, Object value) throws FeatureStoreException, IOException {
        this.add(trainingDatasetBase.getFeatureStore().getId(), trainingDatasetBase.getId(), name, value);
    }

    public void add(FeatureViewBase featureViewBase, String name, Object value) throws FeatureStoreException, IOException {
        this.add(this.getFvUriTemplate(featureViewBase, name), value);
    }

    public void add(FeatureViewBase featureViewBase, Integer trainingDatasetVersion, String name, Object value) throws FeatureStoreException, IOException {
        this.add(this.getFvTdUriTemplate(featureViewBase, trainingDatasetVersion, name), value);
    }

    private UriTemplate getFvUriTemplate(FeatureViewBase featureViewBase) throws FeatureStoreException {
        return UriTemplate.fromTemplate((String)FV_TAGS_PATH).set("projectId", (Object)HopsworksClient.getInstance().getProject().getProjectId()).set("fsId", (Object)((FeatureStoreBase)featureViewBase.getFeatureStore()).getId()).set("fvName", (Object)featureViewBase.getName()).set("fvVersion", (Object)featureViewBase.getVersion());
    }

    private UriTemplate getFvUriTemplate(FeatureViewBase featureViewBase, String tagName) throws FeatureStoreException {
        return UriTemplate.fromTemplate((String)FV_TAGS_PATH).set("projectId", (Object)HopsworksClient.getInstance().getProject().getProjectId()).set("fsId", (Object)((FeatureStoreBase)featureViewBase.getFeatureStore()).getId()).set("fvName", (Object)featureViewBase.getName()).set("fvVersion", (Object)featureViewBase.getVersion()).set("name", (Object)tagName);
    }

    private UriTemplate getFvTdUriTemplate(FeatureViewBase featureViewBase, Integer trainingDatasetVersion) throws FeatureStoreException {
        return UriTemplate.fromTemplate((String)FV_TD_TAGS_PATH).set("projectId", (Object)HopsworksClient.getInstance().getProject().getProjectId()).set("fsId", (Object)((FeatureStoreBase)featureViewBase.getFeatureStore()).getId()).set("fvName", (Object)featureViewBase.getName()).set("fvVersion", (Object)featureViewBase.getVersion()).set("tdVersion", (Object)trainingDatasetVersion);
    }

    private UriTemplate getFvTdUriTemplate(FeatureViewBase featureViewBase, Integer trainingDatasetVersion, String tagName) throws FeatureStoreException {
        return UriTemplate.fromTemplate((String)FV_TD_TAGS_PATH).set("projectId", (Object)HopsworksClient.getInstance().getProject().getProjectId()).set("fsId", (Object)((FeatureStoreBase)featureViewBase.getFeatureStore()).getId()).set("fvName", (Object)featureViewBase.getName()).set("fvVersion", (Object)featureViewBase.getVersion()).set("tdVersion", (Object)trainingDatasetVersion).set("name", (Object)tagName);
    }

    private Map<String, Object> get(Integer featurestoreId, Integer entityId, Optional<String> name) throws FeatureStoreException, IOException {
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/tags{/name}{?value}";
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)HopsworksClient.getInstance().getProject().getProjectId()).set("fsId", (Object)featurestoreId).set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId);
        return this.get(uriTemplate, name);
    }

    private Map<String, Object> get(UriTemplate uriTemplate, Optional<String> name) throws FeatureStoreException, IOException {
        if (name.isPresent()) {
            uriTemplate.set("name", (Object)name.get());
        }
        String uri = uriTemplate.expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpGet getRequest = new HttpGet(uri);
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        HashMap<String, Object> tags = new HashMap<String, Object>();
        for (Tags tag : hopsworksClient.handleRequest((HttpRequest)getRequest, Tags.class).getItems()) {
            tags.put(tag.getName(), this.parseTagValue(hopsworksClient.getObjectMapper(), tag.getValue()));
        }
        return tags;
    }

    public Map<String, Object> get(FeatureViewBase featureViewBase) throws FeatureStoreException, IOException {
        return this.get(this.getFvUriTemplate(featureViewBase), Optional.empty());
    }

    public Map<String, Object> get(FeatureViewBase featureViewBase, Integer trainingDatasetVersion) throws FeatureStoreException, IOException {
        return this.get(this.getFvTdUriTemplate(featureViewBase, trainingDatasetVersion), Optional.empty());
    }

    public Object get(FeatureViewBase featureViewBase, String name) throws FeatureStoreException, IOException {
        return this.get(this.getFvUriTemplate(featureViewBase), Optional.of(name)).get(name);
    }

    public Object get(FeatureViewBase featureViewBase, Integer trainingDatasetVersion, String name) throws FeatureStoreException, IOException {
        return this.get(this.getFvTdUriTemplate(featureViewBase, trainingDatasetVersion), Optional.of(name)).get(name);
    }

    public Object get(FeatureGroupBase featureGroupBase, String name) throws FeatureStoreException, IOException {
        return this.get(featureGroupBase.getFeatureStore().getId(), featureGroupBase.getId(), Optional.of(name)).get(name);
    }

    public Object get(TrainingDatasetBase trainingDatasetBase, String name) throws FeatureStoreException, IOException {
        return this.get(trainingDatasetBase.getFeatureStore().getId(), trainingDatasetBase.getId(), Optional.of(name)).get(name);
    }

    public Map<String, Object> get(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        return this.get(featureGroupBase.getFeatureStore().getId(), featureGroupBase.getId(), Optional.empty());
    }

    public Map<String, Object> get(TrainingDatasetBase trainingDatasetBase) throws FeatureStoreException, IOException {
        return this.get(trainingDatasetBase.getFeatureStore().getId(), trainingDatasetBase.getId(), Optional.empty());
    }

    public Object parseTagValue(ObjectMapper objectMapper, Object value) throws IOException {
        if (value instanceof Double || value instanceof Integer) {
            return value;
        }
        String val = (String)value;
        try {
            return objectMapper.readValue(val, Map.class);
        }
        catch (JsonParseException | JsonMappingException e1) {
            try {
                return objectMapper.readValue(val, Object[].class);
            }
            catch (JsonParseException | JsonMappingException e2) {
                return val;
            }
        }
    }

    private void deleteTag(Integer featurestoreId, Integer entityId, String name) throws FeatureStoreException, IOException {
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/tags{/name}{?value}";
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)HopsworksClient.getInstance().getProject().getProjectId()).set("fsId", (Object)featurestoreId).set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId).set("name", (Object)name);
        this.deleteTag(uriTemplate);
    }

    private void deleteTag(UriTemplate uriTemplate) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        LOGGER.info("Sending metadata request: " + uriTemplate.expand());
        HttpDelete httpDelete = new HttpDelete(uriTemplate.expand());
        hopsworksClient.handleRequest((HttpRequest)httpDelete);
    }

    public void deleteTag(FeatureViewBase featureViewBase, String name) throws FeatureStoreException, IOException {
        this.deleteTag(this.getFvUriTemplate(featureViewBase, name));
    }

    public void deleteTag(FeatureViewBase featureViewBase, Integer trainingDatasetVersion, String name) throws FeatureStoreException, IOException {
        this.deleteTag(this.getFvTdUriTemplate(featureViewBase, trainingDatasetVersion, name));
    }

    public void deleteTag(FeatureGroupBase featureGroup, String name) throws FeatureStoreException, IOException {
        this.deleteTag(featureGroup.getFeatureStore().getId(), featureGroup.getId(), name);
    }

    public void deleteTag(TrainingDatasetBase trainingDatasetBase, String name) throws FeatureStoreException, IOException {
        this.deleteTag(trainingDatasetBase.getFeatureStore().getId(), trainingDatasetBase.getId(), name);
    }
}

