/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.JobConfiguration;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.StreamFeatureGroup;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.engine.Engine;
import com.logicalclocks.hsfs.engine.FeatureGroupEngineBase;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class FeatureGroupEngine<T>
extends FeatureGroupEngineBase {
    public StreamFeatureGroup getStreamFeatureGroup(FeatureStore featureStore, String fgName, Integer fgVersion) throws IOException, FeatureStoreException {
        StreamFeatureGroup[] streamFeatureGroups = (StreamFeatureGroup[])this.featureGroupApi.getInternal(featureStore, fgName, fgVersion, StreamFeatureGroup[].class);
        StreamFeatureGroup resultFg = streamFeatureGroups[0];
        resultFg.setFeatureStore(featureStore);
        return resultFg;
    }

    public List<StreamFeatureGroup> getStreamFeatureGroups(FeatureStore featureStore, String fgName) throws FeatureStoreException, IOException {
        StreamFeatureGroup[] streamFeatureGroups = (StreamFeatureGroup[])this.featureGroupApi.getInternal(featureStore, fgName, null, StreamFeatureGroup[].class);
        return Arrays.asList(streamFeatureGroups);
    }

    public void save(StreamFeatureGroup featureGroup, List<String> partitionKeys, String precombineKeyName, Map<String, String> writeOptions, JobConfiguration materializationJobConfiguration) throws FeatureStoreException, IOException {
        if (featureGroup.getId() != null) {
            return;
        }
        this.utils.verifyAttributeKeyNames(featureGroup, partitionKeys, precombineKeyName);
        StreamFeatureGroup apiFG = (StreamFeatureGroup)this.featureGroupApi.saveFeatureGroupMetaData(featureGroup, partitionKeys, precombineKeyName, writeOptions, materializationJobConfiguration, StreamFeatureGroup.class);
        featureGroup.setOnlineTopicName(apiFG.getOnlineTopicName());
    }

    public List<Object> insertStream(StreamFeatureGroup streamFeatureGroup, List<T> featureData, Map<String, String> writeOptions) {
        return Engine.getInstance().writeStream(streamFeatureGroup, featureData, writeOptions);
    }

    public StreamFeatureGroup getOrCreateFeatureGroup(FeatureStore featureStore, @NonNull String name, Integer version, String description, Boolean onlineEnabled, TimeTravelFormat timeTravelFormat, List<String> primaryKeys, List<String> partitionKeys, String eventTime, String hudiPrecombineKey, List<Feature> features, StatisticsConfig statisticsConfig, StorageConnector storageConnector, String path) throws IOException, FeatureStoreException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        try {
            return this.getStreamFeatureGroup(featureStore, name, version);
        }
        catch (FeatureStoreException | IOException e) {
            if (e.getMessage().contains("Error: 404") && e.getMessage().contains("\"errorCode\":270009")) {
                return StreamFeatureGroup.builder().featureStore(featureStore).name(name).version(version).description(description).onlineEnabled(onlineEnabled).timeTravelFormat(timeTravelFormat).primaryKeys(primaryKeys).partitionKeys(partitionKeys).eventTime(eventTime).hudiPrecombineKey(hudiPrecombineKey).features(features).statisticsConfig(statisticsConfig).storageConnector(storageConnector).path(path).build();
            }
            throw e;
        }
    }
}

