/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.Variable;
import java.io.IOException;
import java.util.Optional;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariablesApi {
    public static final String LOADBALANCER_EXTERNAL_DOMAIN = "loadbalancer_external_domain";
    private static final String VARIABLE_PATH = "/variables/{variableName}";
    private static final Logger LOGGER = LoggerFactory.getLogger(Variable.class);

    public Optional<Variable> get(String variableName) throws IOException, FeatureStoreException {
        String pathTemplate = "/hopsworks-api/api/variables/{variableName}";
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)pathTemplate).set("variableName", (Object)variableName);
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        LOGGER.info("Sending metadata request: " + uriTemplate.expand());
        HttpGet getRequest = new HttpGet(uriTemplate.expand());
        try {
            return Optional.of(hopsworksClient.handleRequest((HttpRequest)getRequest, Variable.class));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

