/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import java.util.ArrayList;
import java.util.List;

public class StatisticsConfig {
    private Boolean enabled = true;
    private Boolean histograms = false;
    private Boolean correlations = false;
    private Boolean exactUniqueness = false;
    private List<String> columns = new ArrayList<String>();

    public StatisticsConfig(Boolean enabled, Boolean histograms, Boolean correlations, Boolean exactUniqueness) {
        this.enabled = enabled;
        this.histograms = histograms;
        this.correlations = correlations;
        this.exactUniqueness = exactUniqueness;
    }

    public static StatisticsConfigBuilder builder() {
        return new StatisticsConfigBuilder();
    }

    public StatisticsConfig(Boolean enabled, Boolean histograms, Boolean correlations, Boolean exactUniqueness, List<String> columns) {
        this.enabled = enabled;
        this.histograms = histograms;
        this.correlations = correlations;
        this.exactUniqueness = exactUniqueness;
        this.columns = columns;
    }

    public StatisticsConfig() {
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getHistograms() {
        return this.histograms;
    }

    public void setHistograms(Boolean histograms) {
        this.histograms = histograms;
    }

    public Boolean getCorrelations() {
        return this.correlations;
    }

    public void setCorrelations(Boolean correlations) {
        this.correlations = correlations;
    }

    public Boolean getExactUniqueness() {
        return this.exactUniqueness;
    }

    public void setExactUniqueness(Boolean exactUniqueness) {
        this.exactUniqueness = exactUniqueness;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public static class StatisticsConfigBuilder {
        private Boolean enabled;
        private Boolean histograms;
        private Boolean correlations;
        private Boolean exactUniqueness;
        private List<String> columns;

        StatisticsConfigBuilder() {
        }

        public StatisticsConfigBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public StatisticsConfigBuilder histograms(Boolean histograms) {
            this.histograms = histograms;
            return this;
        }

        public StatisticsConfigBuilder correlations(Boolean correlations) {
            this.correlations = correlations;
            return this;
        }

        public StatisticsConfigBuilder exactUniqueness(Boolean exactUniqueness) {
            this.exactUniqueness = exactUniqueness;
            return this;
        }

        public StatisticsConfigBuilder columns(List<String> columns) {
            this.columns = columns;
            return this;
        }

        public StatisticsConfig build() {
            return new StatisticsConfig(this.enabled, this.histograms, this.correlations, this.exactUniqueness, this.columns);
        }

        public String toString() {
            return "StatisticsConfig.StatisticsConfigBuilder(enabled=" + this.enabled + ", histograms=" + this.histograms + ", correlations=" + this.correlations + ", exactUniqueness=" + this.exactUniqueness + ", columns=" + this.columns + ")";
        }
    }
}

