/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.FeatureViewBase;
import com.logicalclocks.hsfs.TrainingDatasetBase;
import com.logicalclocks.hsfs.constructor.QueryBase;
import com.logicalclocks.hsfs.constructor.ServingPreparedStatement;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.TransformationFunctionAttached;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureViewApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureViewApi.class);
    private static final String FEATURE_VIEWS_ROOT_PATH = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featureview";
    private static final String FEATURE_VIEWS_PATH = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featureview{/fvName}";
    private static final String FEATURE_VIEW_PATH = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featureview{/fvName}/version{/fvVersion}";
    private static final String FEATURE_VIEW_BATCH_QUERY_PATH = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featureview{/fvName}/version{/fvVersion}/query/batch{?with_label,start_time,end_time,td_version}";
    private static final String ALL_TRAINING_DATA_PATH = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featureview{/fvName}/version{/fvVersion}/trainingdatasets";
    private static final String TRAINING_DATA_PATH = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featureview{/fvName}/version{/fvVersion}/trainingdatasets/version{/tdVersion}";
    private static final String ALL_TRAINING_DATASET_PATH = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featureview{/fvName}/version{/fvVersion}/trainingdatasets/data";
    private static final String TRAINING_DATASET_PATH = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featureview{/fvName}/version{/fvVersion}/trainingdatasets/version{/tdVersion}/data";
    private static final String TRANSFORMATION_PATH = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featureview{/fvName}/version{/fvVersion}/transformation";
    private static final String PREPARED_STATEMENT_PATH = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featureview{/fvName}/version{/fvVersion}/preparedstatement{?batch}";

    public <T extends FeatureViewBase> T save(FeatureViewBase featureViewBase, Class<T> fvType) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)FEATURE_VIEWS_ROOT_PATH).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)((FeatureStoreBase)featureViewBase.getFeatureStore()).getId()).expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setEntity((HttpEntity)hopsworksClient.buildStringEntity(featureViewBase));
        return (T)((FeatureViewBase)hopsworksClient.handleRequest((HttpRequest)postRequest, fvType));
    }

    public <T extends FeatureViewBase> FeatureViewBase get(FeatureStoreBase featureStoreBase, String name, Integer version, Class<T> fvType) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)FEATURE_VIEW_PATH).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)featureStoreBase.getId()).set("fvName", (Object)name).set("fvVersion", (Object)version).expand();
        HashMap params = Maps.newHashMap();
        params.put("expand", Lists.newArrayList((Object[])new String[]{"query", "features"}));
        uri = this.addQueryParam(uri, params);
        HttpGet request = new HttpGet(uri);
        LOGGER.info("Sending metadata request: " + uri);
        try {
            return (FeatureViewBase)hopsworksClient.handleRequest((HttpRequest)request, fvType);
        }
        catch (IOException e) {
            if (e.getMessage().contains("\"errorCode\":270009")) {
                throw new FeatureStoreException("Cannot get back the feature view because the query defined is no longer valid. Some feature groups used in the query may have been deleted. You can clean up this feature view on the UI or `FeatureView.clean`.");
            }
            throw e;
        }
    }

    public List<FeatureViewBase> get(FeatureStoreBase featureStoreBase, String name) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)FEATURE_VIEWS_PATH).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)featureStoreBase.getId()).set("fvName", (Object)name).expand();
        HashMap params = Maps.newHashMap();
        params.put("expand", Lists.newArrayList((Object[])new String[]{"query", "features"}));
        uri = this.addQueryParam(uri, params);
        HttpGet request = new HttpGet(uri);
        LOGGER.info("Sending metadata request: " + uri);
        try {
            return Arrays.stream((Object[])hopsworksClient.handleRequest((HttpRequest)request, FeatureViewBase[].class)).collect(Collectors.toList());
        }
        catch (IOException e) {
            if (e.getMessage().contains("\"errorCode\":270009")) {
                throw new FeatureStoreException("Cannot get back the feature view because the query defined is no longer valid. Some feature groups used in the query may have been deleted. You can clean up this feature view on the UI or `FeatureView.clean`.");
            }
            throw e;
        }
    }

    private String addQueryParam(String baseUrl, Map<String, Object> params) {
        String url = baseUrl + "?";
        List paramUrl = params.entrySet().stream().flatMap(entry -> {
            if (entry.getValue() instanceof String) {
                return Stream.of((String)entry.getKey() + "=" + entry.getValue());
            }
            if (entry.getValue() instanceof List) {
                return ((List)entry.getValue()).stream().map(v -> (String)entry.getKey() + "=" + v);
            }
            return Stream.empty();
        }).collect(Collectors.toList());
        return url + Joiner.on((String)"&").join(paramUrl);
    }

    public <T> T update(FeatureViewBase featureViewBase, Class<T> fvType) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)FEATURE_VIEW_PATH).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)((FeatureStoreBase)featureViewBase.getFeatureStore()).getId()).set("fvName", (Object)featureViewBase.getName()).set("fvVersion", (Object)featureViewBase.getVersion()).expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpPut request = new HttpPut(uri);
        request.setEntity((HttpEntity)hopsworksClient.buildStringEntity(featureViewBase));
        return hopsworksClient.handleRequest((HttpRequest)request, fvType);
    }

    public void delete(FeatureStoreBase featureStoreBase, String name, Integer version) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)FEATURE_VIEW_PATH).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)featureStoreBase.getId()).set("fvName", (Object)name).set("fvVersion", (Object)version).expand();
        HttpDelete request = new HttpDelete(uri);
        LOGGER.info("Sending metadata request: " + uri);
        hopsworksClient.handleRequest((HttpRequest)request);
    }

    public void delete(FeatureStoreBase featureStoreBase, String name) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)FEATURE_VIEWS_PATH).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)featureStoreBase.getId()).set("fvName", (Object)name).expand();
        HttpDelete request = new HttpDelete(uri);
        LOGGER.info("Sending metadata request: " + uri);
        hopsworksClient.handleRequest((HttpRequest)request);
    }

    public List<TransformationFunctionAttached> getTransformationFunctions(FeatureViewBase featureViewBase) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)TRANSFORMATION_PATH).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)((FeatureStoreBase)featureViewBase.getFeatureStore()).getId()).set("fvName", (Object)featureViewBase.getName()).set("fvVersion", (Object)featureViewBase.getVersion()).expand();
        LOGGER.info("Sending metadata request: " + uri);
        TransformationFunctionAttached transformationFunctionAttached = hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), TransformationFunctionAttached.class);
        return transformationFunctionAttached.getItems();
    }

    public List<ServingPreparedStatement> getServingPreparedStatement(FeatureViewBase featureViewBase, boolean batch) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)PREPARED_STATEMENT_PATH).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)((FeatureStoreBase)featureViewBase.getFeatureStore()).getId()).set("fvName", (Object)featureViewBase.getName()).set("fvVersion", (Object)featureViewBase.getVersion()).set("batch", (Object)batch).expand();
        LOGGER.info("Sending metadata request: " + uri);
        ServingPreparedStatement servingPreparedStatement = hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), ServingPreparedStatement.class);
        return servingPreparedStatement.getItems();
    }

    public <T extends TrainingDatasetBase> TrainingDatasetBase createTrainingData(String featureViewName, Integer featureViewVersion, TrainingDatasetBase trainingData, Class<T> tdType) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)ALL_TRAINING_DATA_PATH).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)trainingData.getFeatureStore().getId()).set("fvName", (Object)featureViewName).set("fvVersion", (Object)featureViewVersion).expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpPost request = new HttpPost(uri);
        request.setEntity((HttpEntity)hopsworksClient.buildStringEntity(trainingData));
        return (TrainingDatasetBase)hopsworksClient.handleRequest((HttpRequest)request, tdType);
    }

    public <T extends TrainingDatasetBase> TrainingDatasetBase getTrainingData(FeatureStoreBase featureStoreBase, String featureViewName, Integer featureViewVersion, Integer trainingDataVersion, Class<T> tdType) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)TRAINING_DATA_PATH).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)featureStoreBase.getId()).set("fvName", (Object)featureViewName).set("fvVersion", (Object)featureViewVersion).set("tdVersion", (Object)trainingDataVersion).expand();
        HttpGet request = new HttpGet(uri);
        LOGGER.info("Sending metadata request: " + uri);
        return (TrainingDatasetBase)hopsworksClient.handleRequest((HttpRequest)request, tdType);
    }

    public void deleteTrainingData(FeatureStoreBase featureStoreBase, String featureViewName, Integer featureViewVersion, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)TRAINING_DATA_PATH).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)featureStoreBase.getId()).set("fvName", (Object)featureViewName).set("fvVersion", (Object)featureViewVersion).set("tdVersion", (Object)trainingDataVersion).expand();
        HttpDelete request = new HttpDelete(uri);
        LOGGER.info("Sending metadata request: " + uri);
        hopsworksClient.handleRequest((HttpRequest)request);
    }

    public void deleteTrainingData(FeatureStoreBase featureStoreBase, String name, Integer version) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)ALL_TRAINING_DATA_PATH).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)featureStoreBase.getId()).set("fvName", (Object)name).set("fvVersion", (Object)version).expand();
        HttpDelete request = new HttpDelete(uri);
        LOGGER.info("Sending metadata request: " + uri);
        hopsworksClient.handleRequest((HttpRequest)request);
    }

    public void deleteTrainingDatasetOnly(FeatureStoreBase featureStoreBase, String name, Integer version, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)TRAINING_DATASET_PATH).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)featureStoreBase.getId()).set("fvName", (Object)name).set("fvVersion", (Object)version).set("tdVersion", (Object)trainingDataVersion).expand();
        HttpDelete request = new HttpDelete(uri);
        LOGGER.info("Sending metadata request: " + uri);
        hopsworksClient.handleRequest((HttpRequest)request);
    }

    public void deleteTrainingDatasetOnly(FeatureStoreBase featureStoreBase, String name, Integer version) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)ALL_TRAINING_DATASET_PATH).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)featureStoreBase.getId()).set("fvName", (Object)name).set("fvVersion", (Object)version).expand();
        HttpDelete request = new HttpDelete(uri);
        LOGGER.info("Sending metadata request: " + uri);
        hopsworksClient.handleRequest((HttpRequest)request);
    }

    public <T extends QueryBase> T getBatchQuery(FeatureStoreBase featureStoreBase, String name, Integer version, Long startTime, Long endTime, Boolean withLabels, Integer trainingDataVersion, Class<T> queryType) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String uri = UriTemplate.fromTemplate((String)FEATURE_VIEW_BATCH_QUERY_PATH).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)featureStoreBase.getId()).set("fvName", (Object)name).set("fvVersion", (Object)version).set("start_time", (Object)startTime).set("end_time", (Object)endTime).set("with_label", (Object)withLabels).set("td_version", (Object)trainingDataVersion).expand();
        HttpGet request = new HttpGet(uri);
        LOGGER.info("Sending metadata request: " + uri);
        return (T)((QueryBase)hopsworksClient.handleRequest((HttpRequest)request, queryType));
    }
}

