/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.constructor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.constructor.Filter;
import com.logicalclocks.hsfs.constructor.FilterLogic;
import com.logicalclocks.hsfs.constructor.Join;
import com.logicalclocks.hsfs.constructor.JoinType;
import com.logicalclocks.hsfs.engine.FeatureGroupUtils;
import com.logicalclocks.hsfs.metadata.QueryConstructorApi;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryBase<T extends QueryBase<T, T2, T3>, T2 extends FeatureGroupBase, T3> {
    protected FeatureGroupBase leftFeatureGroup;
    protected List<Feature> leftFeatures;
    protected Long leftFeatureGroupStartTime;
    protected Long leftFeatureGroupEndTime;
    protected List<Join<T>> joins = new ArrayList<Join<T>>();
    protected FilterLogic filter;
    protected Boolean hiveEngine = false;
    protected static final Logger LOGGER = LoggerFactory.getLogger(QueryBase.class);
    protected QueryConstructorApi queryConstructorApi = new QueryConstructorApi();
    protected StorageConnectorApi storageConnectorApi = new StorageConnectorApi();
    private FeatureGroupUtils utils = new FeatureGroupUtils();

    protected void setLeftFeatureGroup(T2 leftFeatureGroup) {
        this.setLeftBaseFeatureGroup((FeatureGroupBase)leftFeatureGroup);
    }

    private void setLeftBaseFeatureGroup(FeatureGroupBase leftFeatureGroup) {
        this.leftFeatureGroup = leftFeatureGroup;
    }

    protected QueryBase(FeatureGroupBase leftFeatureGroup, List<Feature> leftFeatures) {
        this.setLeftBaseFeatureGroup(leftFeatureGroup);
        this.leftFeatures = this.addFeatureGroupToFeatures(leftFeatureGroup, leftFeatures);
    }

    public abstract String sql();

    public abstract String sql(Storage var1);

    public <T2> String sql(Storage storage, Class<T2> fsQueryType) {
        try {
            return this.queryConstructorApi.constructQuery(this.getLeftFeatureGroup().getFeatureStore(), this, fsQueryType).getStorageQuery(storage);
        }
        catch (FeatureStoreException | IOException e) {
            return e.getMessage();
        }
    }

    public T join(T subquery) {
        return this.join(subquery, JoinType.INNER);
    }

    public T join(T subquery, String prefix) {
        return this.join(subquery, JoinType.INNER, prefix);
    }

    public T join(T subquery, List<String> on) {
        return this.joinFeatures(subquery, on.stream().map(Feature::new).collect(Collectors.toList()), JoinType.INNER);
    }

    public T join(T subquery, List<String> leftOn, List<String> rightOn) {
        return this.joinFeatures(subquery, leftOn.stream().map(Feature::new).collect(Collectors.toList()), rightOn.stream().map(Feature::new).collect(Collectors.toList()), JoinType.INNER);
    }

    public T join(T subquery, List<String> leftOn, List<String> rightOn, String prefix) {
        return this.joinFeatures(subquery, leftOn.stream().map(Feature::new).collect(Collectors.toList()), rightOn.stream().map(Feature::new).collect(Collectors.toList()), JoinType.INNER, prefix);
    }

    public T join(T subquery, JoinType joinType) {
        this.joins.add(new Join<T>(subquery, joinType, null));
        return (T)this;
    }

    public T join(T subquery, JoinType joinType, String prefix) {
        this.joins.add(new Join<T>(subquery, joinType, prefix));
        return (T)this;
    }

    public T join(T subquery, List<String> on, JoinType joinType) {
        this.joins.add(new Join<T>(subquery, on.stream().map(Feature::new).collect(Collectors.toList()), joinType, null));
        return (T)this;
    }

    public T join(T subquery, List<String> on, JoinType joinType, String prefix) {
        this.joins.add(new Join<T>(subquery, on.stream().map(Feature::new).collect(Collectors.toList()), joinType, prefix));
        return (T)this;
    }

    public T join(T subquery, List<String> leftOn, List<String> rightOn, JoinType joinType) {
        this.joins.add(new Join<T>(subquery, leftOn.stream().map(Feature::new).collect(Collectors.toList()), rightOn.stream().map(Feature::new).collect(Collectors.toList()), joinType, null));
        return (T)this;
    }

    public T join(T subquery, List<String> leftOn, List<String> rightOn, JoinType joinType, String prefix) {
        this.joins.add(new Join<T>(subquery, leftOn.stream().map(Feature::new).collect(Collectors.toList()), rightOn.stream().map(Feature::new).collect(Collectors.toList()), joinType, prefix));
        return (T)this;
    }

    public T joinFeatures(T subquery, List<Feature> on) {
        return this.joinFeatures(subquery, on, JoinType.INNER);
    }

    public T joinFeatures(T subquery, List<Feature> on, String prefix) {
        return this.joinFeatures(subquery, on, JoinType.INNER, prefix);
    }

    public T joinFeatures(T subquery, List<Feature> leftOn, List<Feature> rightOn) {
        return this.joinFeatures(subquery, leftOn, rightOn, JoinType.INNER);
    }

    public T joinFeatures(T subquery, List<Feature> leftOn, List<Feature> rightOn, String prefix) {
        return this.joinFeatures(subquery, leftOn, rightOn, JoinType.INNER, prefix);
    }

    public T joinFeatures(T subquery, List<Feature> on, JoinType joinType) {
        this.joins.add(new Join<T>(subquery, on, joinType, null));
        return (T)this;
    }

    public T joinFeatures(T subquery, List<Feature> on, JoinType joinType, String prefix) {
        this.joins.add(new Join<T>(subquery, on, joinType, prefix));
        return (T)this;
    }

    public T joinFeatures(T subquery, List<Feature> leftOn, List<Feature> rightOn, JoinType joinType) {
        this.joins.add(new Join<T>(subquery, leftOn, rightOn, joinType, null));
        return (T)this;
    }

    public T joinFeatures(T subquery, List<Feature> leftOn, List<Feature> rightOn, JoinType joinType, String prefix) {
        this.joins.add(new Join<T>(subquery, leftOn, rightOn, joinType, prefix));
        return (T)this;
    }

    public T asOf(String wallclockTime) throws FeatureStoreException, ParseException {
        return this.asOf(wallclockTime, null);
    }

    public T asOf(String wallclockTime, String excludeUntil) throws FeatureStoreException, ParseException {
        Long wallclockTimestamp = FeatureGroupUtils.getTimeStampFromDateString(wallclockTime);
        Long excludeUntilTimestamp = null;
        if (excludeUntil != null) {
            excludeUntilTimestamp = FeatureGroupUtils.getTimeStampFromDateString(excludeUntil);
        }
        for (Join<T> join : this.joins) {
            T queryBaseWithTimeStamp = join.getQuery();
            ((QueryBase)queryBaseWithTimeStamp).setLeftFeatureGroupEndTime(wallclockTimestamp);
            if (excludeUntilTimestamp != null) {
                ((QueryBase)queryBaseWithTimeStamp).setLeftFeatureGroupStartTime(excludeUntilTimestamp);
            }
            join.setQuery(queryBaseWithTimeStamp);
        }
        this.setLeftFeatureGroupEndTime(wallclockTimestamp);
        if (excludeUntilTimestamp != null) {
            this.setLeftFeatureGroupStartTime(excludeUntilTimestamp);
        }
        return (T)this;
    }

    public T pullChanges(String wallclockStartTime, String wallclockEndTime) throws FeatureStoreException, ParseException {
        this.setLeftFeatureGroupStartTime(FeatureGroupUtils.getTimeStampFromDateString(wallclockStartTime));
        this.setLeftFeatureGroupEndTime(FeatureGroupUtils.getTimeStampFromDateString(wallclockEndTime));
        return (T)this;
    }

    public T filter(Filter filter) {
        this.filter = this.filter == null ? new FilterLogic(filter) : this.filter.and(filter);
        return (T)this;
    }

    public T filter(FilterLogic filter) {
        this.filter = this.filter == null ? filter : this.filter.and(filter);
        return (T)this;
    }

    public T appendFeature(Feature feature) {
        this.leftFeatures.add(feature);
        return (T)this;
    }

    @JsonIgnore
    public boolean isTimeTravel() {
        if (this.leftFeatureGroupStartTime != null || this.leftFeatureGroupEndTime != null) {
            return true;
        }
        for (Join<T> join : this.joins) {
            if (!((QueryBase)join.getQuery()).isTimeTravel()) continue;
            return true;
        }
        return false;
    }

    private List<Feature> addFeatureGroupToFeatures(FeatureGroupBase featureGroupBase, List<Feature> leftFeatures) {
        ArrayList<Feature> updatedFeatures = new ArrayList<Feature>();
        for (Feature feature : leftFeatures) {
            feature.setFeatureGroupId(featureGroupBase.getId());
            updatedFeatures.add(feature);
        }
        return updatedFeatures;
    }

    public abstract Object read() throws FeatureStoreException, IOException;

    public abstract Object read(boolean var1) throws FeatureStoreException, IOException;

    public abstract Object read(boolean var1, Map<String, String> var2) throws FeatureStoreException, IOException;

    public abstract void show(int var1) throws FeatureStoreException, IOException;

    public abstract void show(boolean var1, int var2) throws FeatureStoreException, IOException;

    public QueryBase() {
    }

    public FeatureGroupBase getLeftFeatureGroup() {
        return this.leftFeatureGroup;
    }

    public List<Feature> getLeftFeatures() {
        return this.leftFeatures;
    }

    public void setLeftFeatures(List<Feature> leftFeatures) {
        this.leftFeatures = leftFeatures;
    }

    public Long getLeftFeatureGroupStartTime() {
        return this.leftFeatureGroupStartTime;
    }

    public void setLeftFeatureGroupStartTime(Long leftFeatureGroupStartTime) {
        this.leftFeatureGroupStartTime = leftFeatureGroupStartTime;
    }

    public Long getLeftFeatureGroupEndTime() {
        return this.leftFeatureGroupEndTime;
    }

    public void setLeftFeatureGroupEndTime(Long leftFeatureGroupEndTime) {
        this.leftFeatureGroupEndTime = leftFeatureGroupEndTime;
    }

    public List<Join<T>> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join<T>> joins) {
        this.joins = joins;
    }

    public FilterLogic getFilter() {
        return this.filter;
    }

    public void setFilter(FilterLogic filter) {
        this.filter = filter;
    }

    public Boolean getHiveEngine() {
        return this.hiveEngine;
    }

    public void setHiveEngine(Boolean hiveEngine) {
        this.hiveEngine = hiveEngine;
    }
}

