/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.OnlineConfig;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.TrainingDatasetBase;
import com.logicalclocks.hsfs.constructor.QueryBase;
import com.logicalclocks.hsfs.metadata.FeatureGroupApi;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import com.logicalclocks.hsfs.metadata.TrainingDatasetApi;
import java.io.IOException;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FeatureStoreBase<T2 extends QueryBase> {
    @JsonProperty(value="featurestoreId")
    private Integer id;
    @JsonProperty(value="featurestoreName")
    private String name;
    private Integer projectId;
    protected FeatureGroupApi featureGroupApi;
    protected TrainingDatasetApi trainingDatasetApi;
    protected StorageConnectorApi storageConnectorApi;
    protected static final Logger LOGGER = LoggerFactory.getLogger(FeatureStoreBase.class);
    protected static final Integer DEFAULT_VERSION = 1;

    public abstract Object createFeatureGroup();

    public abstract Object getFeatureGroups(@NonNull String var1) throws FeatureStoreException, IOException;

    public abstract Object getOrCreateFeatureGroup(String var1, Integer var2) throws IOException, FeatureStoreException;

    public abstract Object getOrCreateFeatureGroup(String var1, Integer var2, List<String> var3, List<String> var4, boolean var5, String var6) throws IOException, FeatureStoreException;

    public abstract Object getOrCreateFeatureGroup(String var1, Integer var2, List<String> var3, boolean var4, String var5) throws IOException, FeatureStoreException;

    public abstract Object getOrCreateFeatureGroup(String var1, Integer var2, String var3, List<String> var4, List<String> var5, String var6, boolean var7, TimeTravelFormat var8, StatisticsConfig var9, String var10, String var11, String var12, OnlineConfig var13) throws IOException, FeatureStoreException;

    public abstract Object getStreamFeatureGroup(@NonNull String var1, @NonNull Integer var2) throws FeatureStoreException, IOException;

    public abstract Object getStreamFeatureGroup(String var1) throws FeatureStoreException, IOException;

    public abstract Object createStreamFeatureGroup();

    public abstract Object getOrCreateStreamFeatureGroup(String var1, Integer var2) throws IOException, FeatureStoreException;

    public abstract Object getOrCreateStreamFeatureGroup(String var1, Integer var2, List<String> var3, boolean var4, String var5) throws IOException, FeatureStoreException;

    public abstract Object getOrCreateStreamFeatureGroup(String var1, Integer var2, List<String> var3, List<String> var4, boolean var5, String var6) throws IOException, FeatureStoreException;

    public abstract Object getOrCreateStreamFeatureGroup(String var1, Integer var2, String var3, List<String> var4, List<String> var5, String var6, boolean var7, TimeTravelFormat var8, StatisticsConfig var9, String var10, OnlineConfig var11) throws IOException, FeatureStoreException;

    public abstract Object createExternalFeatureGroup();

    public abstract Object createFeatureView();

    public abstract Object getFeatureView(String var1) throws FeatureStoreException, IOException;

    public abstract Object getFeatureView(@NonNull String var1, @NonNull Integer var2) throws FeatureStoreException, IOException;

    public abstract Object getOrCreateFeatureView(String var1, T2 var2, Integer var3) throws FeatureStoreException, IOException;

    public abstract Object getOrCreateFeatureView(String var1, T2 var2, Integer var3, String var4, List<String> var5) throws FeatureStoreException, IOException;

    public abstract Object getExternalFeatureGroup(@NonNull String var1, @NonNull Integer var2) throws FeatureStoreException, IOException;

    public abstract Object getExternalFeatureGroup(String var1) throws FeatureStoreException, IOException;

    public abstract StorageConnector getStorageConnector(String var1) throws FeatureStoreException, IOException;

    public abstract Object getHopsFsConnector(String var1) throws FeatureStoreException, IOException;

    public abstract Object getExternalFeatureGroups(@NonNull String var1) throws FeatureStoreException, IOException;

    public abstract Object sql(String var1);

    public abstract Object getJdbcConnector(String var1) throws FeatureStoreException, IOException;

    public abstract Object getS3Connector(String var1) throws FeatureStoreException, IOException;

    public abstract Object getRedshiftConnector(String var1) throws FeatureStoreException, IOException;

    public abstract Object getSnowflakeConnector(String var1) throws FeatureStoreException, IOException;

    public abstract Object getAdlsConnector(String var1) throws FeatureStoreException, IOException;

    public abstract Object getKafkaConnector(String var1) throws FeatureStoreException, IOException;

    public abstract Object getBigqueryConnector(String var1) throws FeatureStoreException, IOException;

    public abstract Object getOnlineStorageConnector() throws FeatureStoreException, IOException;

    public abstract Object getGcsConnector(String var1) throws FeatureStoreException, IOException;

    public abstract TrainingDatasetBase getTrainingDataset(@NonNull String var1, @NonNull Integer var2) throws FeatureStoreException, IOException;

    public abstract TrainingDatasetBase getTrainingDataset(String var1) throws FeatureStoreException, IOException;

    public abstract Object getTrainingDatasets(@NonNull String var1) throws FeatureStoreException, IOException;

    public String toString() {
        return "FeatureStore{id=" + this.id + ", name='" + this.name + '\'' + ", projectId=" + this.projectId + ", featureGroupApi=" + this.featureGroupApi + '}';
    }

    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="featurestoreId")
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty(value="featurestoreName")
    public void setName(String name) {
        this.name = name;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }
}

