/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.logicalclocks.hsfs.DataFormat;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Split;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.StorageConnectorType;
import com.logicalclocks.hsfs.TrainingDatasetFeature;
import com.logicalclocks.hsfs.TrainingDatasetType;
import com.logicalclocks.hsfs.constructor.FilterLogic;
import com.logicalclocks.hsfs.engine.FeatureGroupUtils;
import com.logicalclocks.hsfs.engine.VectorServer;
import com.logicalclocks.hsfs.metadata.Statistics;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrainingDatasetBase {
    protected Integer id;
    protected String name;
    protected Integer version;
    protected String description;
    protected Boolean coalesce;
    protected TrainingDatasetType trainingDatasetType = TrainingDatasetType.HOPSFS_TRAINING_DATASET;
    protected List<TrainingDatasetFeature> features;
    @JsonIgnore
    protected FeatureStoreBase featureStore;
    protected String location;
    protected Long seed;
    protected List<Split> splits;
    protected String trainSplit;
    @JsonIgnore
    protected List<String> label;
    protected Date eventStartTime;
    protected Date eventEndTime;
    protected FilterLogic extraFilter;
    protected DataFormat dataFormat;
    protected StorageConnector storageConnector;
    protected StatisticsConfig statisticsConfig = new StatisticsConfig();
    protected String type = "trainingDatasetDTO";
    protected static final Logger LOGGER = LoggerFactory.getLogger(TrainingDatasetBase.class);
    protected VectorServer vectorServer = new VectorServer();

    public void setTimeSeriesSplits(Integer timeSplitSize, String trainStart, String trainEnd, String valStart, String valEnd, String testStart, String testEnd) throws FeatureStoreException, ParseException {
        ArrayList splits = Lists.newArrayList();
        this.appendTimeSeriesSplit(splits, "train", trainStart, trainEnd != null ? trainEnd : (valStart != null ? valStart : testStart));
        if (timeSplitSize != null && timeSplitSize == 3) {
            this.appendTimeSeriesSplit(splits, "validataion", valStart != null ? valStart : trainEnd, valEnd != null ? valEnd : testStart);
        }
        this.appendTimeSeriesSplit(splits, "test", testStart != null ? testStart : (valEnd != null ? valEnd : trainEnd), testEnd);
        if (!splits.isEmpty()) {
            this.splits = splits;
        }
    }

    private void appendTimeSeriesSplit(List<Split> splits, String splitName, String startTime, String endTime) throws FeatureStoreException, ParseException {
        if (startTime != null || endTime != null) {
            splits.add(new Split(splitName, FeatureGroupUtils.getDateFromDateString(startTime), FeatureGroupUtils.getDateFromDateString(endTime)));
        }
    }

    public void setValTestSplit(Float valSize, Float testSize) {
        if (valSize != null && testSize != null) {
            this.splits = Lists.newArrayList();
            this.splits.add(new Split("train", Float.valueOf(1.0f - valSize.floatValue() - testSize.floatValue())));
            this.splits.add(new Split("validataion", valSize));
            this.splits.add(new Split("test", testSize));
        } else if (testSize != null) {
            this.splits = Lists.newArrayList();
            this.splits.add(new Split("train", Float.valueOf(1.0f - testSize.floatValue())));
            this.splits.add(new Split("test", testSize));
        }
    }

    @JsonIgnore
    public String getQuery() throws FeatureStoreException, IOException {
        return this.getQuery(Storage.ONLINE, false);
    }

    @JsonIgnore
    public String getQuery(boolean withLabel) throws FeatureStoreException, IOException {
        return this.getQuery(Storage.ONLINE, withLabel);
    }

    @JsonIgnore
    public String getQuery(Storage storage) throws FeatureStoreException, IOException {
        return this.getQuery(storage, false);
    }

    @JsonIgnore
    public abstract String getQuery(Storage var1, boolean var2) throws FeatureStoreException, IOException;

    @JsonIgnore
    public List<String> getLabel() {
        return this.features.stream().filter(TrainingDatasetFeature::getLabel).map(TrainingDatasetFeature::getName).collect(Collectors.toList());
    }

    @JsonIgnore
    public void setLabel(List<String> label) {
        this.label = label.stream().map(String::toLowerCase).collect(Collectors.toList());
    }

    public void initPreparedStatement() throws SQLException, IOException, FeatureStoreException, ClassNotFoundException {
        this.initPreparedStatement(false);
    }

    public void initPreparedStatement(boolean external) throws SQLException, IOException, FeatureStoreException, ClassNotFoundException {
        this.vectorServer.initPreparedStatement(this, false, external);
    }

    public void initPreparedStatement(boolean external, boolean batch) throws SQLException, IOException, FeatureStoreException, ClassNotFoundException {
        this.vectorServer.initPreparedStatement(this, batch, external);
    }

    @JsonIgnore
    public List<Object> getServingVector(Map<String, Object> entry) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.vectorServer.getFeatureVector(this, entry);
    }

    @JsonIgnore
    public List<Object> getServingVector(Map<String, Object> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.vectorServer.getFeatureVector(this, entry, external);
    }

    @JsonIgnore
    public List<List<Object>> getServingVectors(Map<String, List<Object>> entry) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.vectorServer.getFeatureVectors(this, entry);
    }

    @JsonIgnore
    public List<List<Object>> getServingVectors(Map<String, List<Object>> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.vectorServer.getFeatureVectors(this, entry, external);
    }

    @JsonIgnore
    public HashSet<String> getServingKeys() throws SQLException, IOException, FeatureStoreException, ClassNotFoundException {
        if (this.vectorServer.getServingKeys().isEmpty()) {
            this.initPreparedStatement();
        }
        return this.vectorServer.getServingKeys();
    }

    public TrainingDatasetType getTrainingDatasetType(StorageConnector storageConnector) {
        if (storageConnector == null) {
            return TrainingDatasetType.HOPSFS_TRAINING_DATASET;
        }
        if (storageConnector.getStorageConnectorType() == StorageConnectorType.HOPSFS) {
            return TrainingDatasetType.HOPSFS_TRAINING_DATASET;
        }
        return TrainingDatasetType.EXTERNAL_TRAINING_DATASET;
    }

    public abstract <T> T read() throws FeatureStoreException, IOException;

    public abstract Object read(String var1, Map<String, String> var2) throws FeatureStoreException, IOException;

    public abstract void show(int var1) throws FeatureStoreException, IOException;

    public abstract Statistics computeStatistics() throws FeatureStoreException, IOException;

    public abstract void updateStatisticsConfig() throws FeatureStoreException, IOException;

    @JsonIgnore
    public abstract Statistics getStatistics() throws FeatureStoreException, IOException;

    @JsonIgnore
    public abstract Statistics getStatistics(String var1) throws FeatureStoreException, IOException;

    public abstract void addTag(String var1, Object var2) throws FeatureStoreException, IOException;

    @JsonIgnore
    public abstract Map<String, Object> getTags() throws FeatureStoreException, IOException;

    @JsonIgnore
    public abstract Object getTag(String var1) throws FeatureStoreException, IOException;

    public abstract void deleteTag(String var1) throws FeatureStoreException, IOException;

    public abstract void delete() throws FeatureStoreException, IOException;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getCoalesce() {
        return this.coalesce;
    }

    public void setCoalesce(Boolean coalesce) {
        this.coalesce = coalesce;
    }

    public TrainingDatasetType getTrainingDatasetType() {
        return this.trainingDatasetType;
    }

    public void setTrainingDatasetType(TrainingDatasetType trainingDatasetType) {
        this.trainingDatasetType = trainingDatasetType;
    }

    public List<TrainingDatasetFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<TrainingDatasetFeature> features) {
        this.features = features;
    }

    public FeatureStoreBase getFeatureStore() {
        return this.featureStore;
    }

    public void setFeatureStore(FeatureStoreBase featureStore) {
        this.featureStore = featureStore;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public String getTrainSplit() {
        return this.trainSplit;
    }

    public void setTrainSplit(String trainSplit) {
        this.trainSplit = trainSplit;
    }

    public Date getEventStartTime() {
        return this.eventStartTime;
    }

    public void setEventStartTime(Date eventStartTime) {
        this.eventStartTime = eventStartTime;
    }

    public Date getEventEndTime() {
        return this.eventEndTime;
    }

    public void setEventEndTime(Date eventEndTime) {
        this.eventEndTime = eventEndTime;
    }

    public FilterLogic getExtraFilter() {
        return this.extraFilter;
    }

    public void setExtraFilter(FilterLogic extraFilter) {
        this.extraFilter = extraFilter;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public StorageConnector getStorageConnector() {
        return this.storageConnector;
    }

    public void setStorageConnector(StorageConnector storageConnector) {
        this.storageConnector = storageConnector;
    }

    public StatisticsConfig getStatisticsConfig() {
        return this.statisticsConfig;
    }

    public void setStatisticsConfig(StatisticsConfig statisticsConfig) {
        this.statisticsConfig = statisticsConfig;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

