/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.FeatureViewBase;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TrainingDatasetBase;
import com.logicalclocks.hsfs.TrainingDatasetFeature;
import com.logicalclocks.hsfs.constructor.ServingPreparedStatement;
import com.logicalclocks.hsfs.metadata.FeatureViewApi;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.HopsworksExternalClient;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import com.logicalclocks.hsfs.metadata.TrainingDatasetApi;
import com.logicalclocks.hsfs.metadata.Variable;
import com.logicalclocks.hsfs.metadata.VariablesApi;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;

public class VectorServer {
    private StorageConnectorApi storageConnectorApi = new StorageConnectorApi();
    private Schema.Parser parser = new Schema.Parser();
    private BinaryDecoder binaryDecoder = DecoderFactory.get().binaryDecoder(new byte[0], null);
    private TrainingDatasetApi trainingDatasetApi = new TrainingDatasetApi();
    private FeatureViewApi featureViewApi = new FeatureViewApi();
    private Connection preparedStatementConnection;
    private Map<Integer, TreeMap<String, Integer>> preparedStatementParameters;
    private TreeMap<Integer, PreparedStatement> preparedStatements;
    private TreeMap<Integer, String> preparedQueryString;
    private HashSet<String> servingKeys;
    private boolean isBatch = false;
    private VariablesApi variablesApi = new VariablesApi();

    public VectorServer(boolean isBatch) {
        this.isBatch = isBatch;
    }

    public List<Object> getFeatureVector(TrainingDatasetBase trainingDatasetBase, Map<String, Object> entry) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.getFeatureVector(trainingDatasetBase, entry, HopsworksClient.getInstance().getHopsworksHttpClient() instanceof HopsworksExternalClient);
    }

    public List<Object> getFeatureVector(TrainingDatasetBase trainingDatasetBase, Map<String, Object> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        if (this.preparedStatements == null || this.isBatch) {
            this.initPreparedStatement(trainingDatasetBase, false, external);
        }
        return this.getFeatureVector(trainingDatasetBase.getFeatureStore(), trainingDatasetBase.getFeatures(), entry, external);
    }

    public List<Object> getFeatureVector(FeatureViewBase featureViewBase, Map<String, Object> entry) throws FeatureStoreException, SQLException, IOException, ClassNotFoundException {
        return this.getFeatureVector(featureViewBase, entry, HopsworksClient.getInstance().getHopsworksHttpClient() instanceof HopsworksExternalClient);
    }

    public List<Object> getFeatureVector(FeatureViewBase featureViewBase, Map<String, Object> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        if (this.preparedStatements == null || this.isBatch) {
            this.initPreparedStatement(featureViewBase, false, external);
        }
        return this.getFeatureVector((FeatureStoreBase)featureViewBase.getFeatureStore(), featureViewBase.getFeatures(), entry, external);
    }

    private List<Object> getFeatureVector(FeatureStoreBase featureStoreBase, List<TrainingDatasetFeature> features, Map<String, Object> entry, boolean external) throws SQLException, FeatureStoreException, IOException {
        this.checkPrimaryKeys(entry.keySet());
        this.refreshJdbcConnection(featureStoreBase, external);
        for (Integer fgId : this.preparedStatements.keySet()) {
            Map parameterIndexInStatement = this.preparedStatementParameters.get(fgId);
            for (String name : entry.keySet()) {
                if (!parameterIndexInStatement.containsKey(name)) continue;
                this.preparedStatements.get(fgId).setObject((Integer)parameterIndexInStatement.get(name), entry.get(name));
            }
        }
        return this.getFeatureVector(features);
    }

    private List<Object> getFeatureVector(List<TrainingDatasetFeature> features) throws SQLException, FeatureStoreException, IOException {
        Map<String, DatumReader<Object>> complexFeatureSchemas = this.getComplexFeatureSchemas(features);
        ArrayList<Object> servingVector = new ArrayList<Object>();
        for (Integer preparedStatementIndex : this.preparedStatements.keySet()) {
            ResultSet results = this.preparedStatements.get(preparedStatementIndex).executeQuery();
            if (!results.isBeforeFirst()) {
                throw new FeatureStoreException("No data was retrieved from online feature store.");
            }
            int columnCount = results.getMetaData().getColumnCount();
            while (results.next()) {
                for (int index = 1; index <= columnCount; ++index) {
                    if (complexFeatureSchemas.containsKey(results.getMetaData().getColumnName(index))) {
                        servingVector.add(this.deserializeComplexFeature(complexFeatureSchemas, results, index));
                        continue;
                    }
                    servingVector.add(results.getObject(index));
                }
            }
            results.close();
        }
        return servingVector;
    }

    public List<List<Object>> getFeatureVectors(TrainingDatasetBase trainingDatasetBase, Map<String, List<Object>> entry) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.getFeatureVectors(trainingDatasetBase, entry, HopsworksClient.getInstance().getHopsworksHttpClient() instanceof HopsworksExternalClient);
    }

    public List<List<Object>> getFeatureVectors(TrainingDatasetBase trainingDatasetBase, Map<String, List<Object>> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        if (this.preparedStatements == null || !this.isBatch) {
            this.initPreparedStatement(trainingDatasetBase, true, external);
        }
        return this.getFeatureVectors(trainingDatasetBase.getFeatureStore(), trainingDatasetBase.getFeatures(), entry, external);
    }

    public List<List<Object>> getFeatureVectors(FeatureViewBase featureViewBase, Map<String, List<Object>> entry) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.getFeatureVectors((FeatureStoreBase)featureViewBase.getFeatureStore(), featureViewBase.getFeatures(), entry, HopsworksClient.getInstance().getHopsworksHttpClient() instanceof HopsworksExternalClient);
    }

    public List<List<Object>> getFeatureVectors(FeatureViewBase featureViewBase, Map<String, List<Object>> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        if (this.preparedStatements == null || !this.isBatch) {
            this.initPreparedStatement(featureViewBase, true, external);
        }
        return this.getFeatureVectors((FeatureStoreBase)featureViewBase.getFeatureStore(), featureViewBase.getFeatures(), entry, external);
    }

    private List<List<Object>> getFeatureVectors(FeatureStoreBase featureStoreBase, List<TrainingDatasetFeature> features, Map<String, List<Object>> entry) throws SQLException, FeatureStoreException, IOException {
        return this.getFeatureVectors(featureStoreBase, features, entry, HopsworksClient.getInstance().getHopsworksHttpClient() instanceof HopsworksExternalClient);
    }

    private List<List<Object>> getFeatureVectors(FeatureStoreBase featureStoreBase, List<TrainingDatasetFeature> features, Map<String, List<Object>> entry, boolean external) throws SQLException, FeatureStoreException, IOException {
        this.checkPrimaryKeys(entry.keySet());
        ArrayList queries = Lists.newArrayList();
        for (Integer fgId : this.preparedQueryString.keySet()) {
            String query = this.preparedQueryString.get(fgId);
            String zippedTupleString = this.zipArraysToTupleString(this.preparedStatementParameters.get(fgId).keySet().stream().map(entry::get).collect(Collectors.toList()));
            queries.add(query.replaceFirst("\\?", zippedTupleString));
        }
        return this.getFeatureVectors(featureStoreBase, features, queries, external);
    }

    private List<List<Object>> getFeatureVectors(FeatureStoreBase featureStoreBase, List<TrainingDatasetFeature> features, List<String> queries, boolean external) throws SQLException, FeatureStoreException, IOException {
        this.refreshJdbcConnection(featureStoreBase, external);
        ArrayList<Object> servingVector = new ArrayList<Object>();
        Map<String, DatumReader<Object>> complexFeatureSchemas = this.getComplexFeatureSchemas(features);
        HashMap<Integer, ArrayList<Object>> servingVectorsMap = new HashMap<Integer, ArrayList<Object>>();
        try (Statement stmt = this.preparedStatementConnection.createStatement();){
            for (String query : queries) {
                int orderInBatch = 0;
                ResultSet results = stmt.executeQuery(query);
                Throwable throwable = null;
                try {
                    if (!results.isBeforeFirst()) {
                        throw new FeatureStoreException("No data was retrieved from online feature store.");
                    }
                    int columnCount = results.getMetaData().getColumnCount();
                    while (results.next()) {
                        for (int index = 1; index <= columnCount; ++index) {
                            if (complexFeatureSchemas.containsKey(results.getMetaData().getColumnName(index))) {
                                servingVector.add(this.deserializeComplexFeature(complexFeatureSchemas, results, index));
                                continue;
                            }
                            servingVector.add(results.getObject(index));
                        }
                        if (servingVectorsMap.containsKey(orderInBatch)) {
                            ((List)servingVectorsMap.get(orderInBatch)).addAll(servingVector);
                        } else {
                            servingVectorsMap.put(orderInBatch, servingVector);
                        }
                        servingVector = new ArrayList();
                        ++orderInBatch;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (results == null) continue;
                    if (throwable != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    results.close();
                }
            }
        }
        return new ArrayList<List<Object>>(servingVectorsMap.values());
    }

    public void initServing(TrainingDatasetBase trainingDatasetBase, boolean batch) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.initPreparedStatement(trainingDatasetBase, batch);
    }

    public void initServing(FeatureViewBase featureViewBase, boolean batch) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.initPreparedStatement(featureViewBase, batch);
    }

    public void initServing(FeatureViewBase featureViewBase, boolean batch, boolean external) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.initPreparedStatement(featureViewBase, batch, external);
    }

    public void initPreparedStatement(TrainingDatasetBase trainingDatasetBase, boolean batch) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.initPreparedStatement(trainingDatasetBase, batch, HopsworksClient.getInstance().getHopsworksHttpClient() instanceof HopsworksExternalClient);
    }

    public void initPreparedStatement(TrainingDatasetBase trainingDatasetBase, boolean batch, boolean external) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        if (this.trainingDatasetApi.getTransformationFunctions(trainingDatasetBase).size() > 0) {
            throw new FeatureStoreException("This training dataset has transformation functions attached and serving must performed from a Python application");
        }
        List<ServingPreparedStatement> servingPreparedStatements = this.trainingDatasetApi.getServingPreparedStatement(trainingDatasetBase, batch);
        this.initPreparedStatement(trainingDatasetBase.getFeatureStore(), servingPreparedStatements, batch, external);
    }

    public void initPreparedStatement(FeatureViewBase featureViewBase, boolean batch) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.initPreparedStatement(featureViewBase, batch, HopsworksClient.getInstance().getHopsworksHttpClient() instanceof HopsworksExternalClient);
    }

    public void initPreparedStatement(FeatureViewBase featureViewBase, boolean batch, boolean external) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        if (this.featureViewApi.getTransformationFunctions(featureViewBase).size() > 0) {
            throw new FeatureStoreException("This training dataset has transformation functions attached and serving must performed from a Python application");
        }
        List<ServingPreparedStatement> servingPreparedStatements = this.featureViewApi.getServingPreparedStatement(featureViewBase, batch);
        this.initPreparedStatement((FeatureStoreBase)featureViewBase.getFeatureStore(), servingPreparedStatements, batch, external);
    }

    private void initPreparedStatement(FeatureStoreBase featureStoreBase, List<ServingPreparedStatement> servingPreparedStatements, boolean batch) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.initPreparedStatement(featureStoreBase, servingPreparedStatements, batch, HopsworksClient.getInstance().getHopsworksHttpClient() instanceof HopsworksExternalClient);
    }

    private void initPreparedStatement(FeatureStoreBase featureStoreBase, List<ServingPreparedStatement> servingPreparedStatements, boolean batch, boolean external) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        Class.forName("com.mysql.jdbc.Driver");
        this.isBatch = batch;
        this.setupJdbcConnection(featureStoreBase, external);
        HashMap<Integer, TreeMap<String, Integer>> preparedStatementParameters = new HashMap<Integer, TreeMap<String, Integer>>();
        TreeMap<Integer, PreparedStatement> preparedStatements = new TreeMap<Integer, PreparedStatement>();
        TreeMap<Integer, String> preparedQueryString = new TreeMap<Integer, String>();
        HashSet servingVectorKeys = new HashSet();
        for (ServingPreparedStatement servingPreparedStatement : servingPreparedStatements) {
            if (batch) {
                preparedQueryString.put(servingPreparedStatement.getPreparedStatementIndex(), servingPreparedStatement.getQueryOnline());
            } else {
                preparedStatements.put(servingPreparedStatement.getPreparedStatementIndex(), this.preparedStatementConnection.prepareStatement(servingPreparedStatement.getQueryOnline()));
            }
            TreeMap parameterIndices = new TreeMap();
            servingPreparedStatement.getPreparedStatementParameters().forEach(preparedStatementParameter -> {
                servingVectorKeys.add(preparedStatementParameter.getName());
                parameterIndices.put(preparedStatementParameter.getName(), preparedStatementParameter.getIndex());
            });
            preparedStatementParameters.put(servingPreparedStatement.getPreparedStatementIndex(), parameterIndices);
        }
        this.servingKeys = servingVectorKeys;
        this.preparedStatementParameters = preparedStatementParameters;
        this.preparedStatements = preparedStatements;
        this.preparedQueryString = preparedQueryString;
    }

    private void setupJdbcConnection(FeatureStoreBase featureStoreBase, Boolean external) throws FeatureStoreException, IOException, SQLException {
        StorageConnector.JdbcConnector storageConnectorBase = this.storageConnectorApi.getOnlineStorageConnector(featureStoreBase, StorageConnector.JdbcConnector.class);
        Map<String, String> jdbcOptions = storageConnectorBase.sparkOptions();
        String url = jdbcOptions.get("url");
        if (external.booleanValue()) {
            Optional<Variable> loadbalancerVariable = this.variablesApi.get("loadbalancer_external_domain_mysqld");
            if (!loadbalancerVariable.isPresent() || Strings.isNullOrEmpty((String)loadbalancerVariable.get().getValue())) {
                throw new FeatureStoreException("No external domain for MySQL was found in the Hopsworks Cluster Configuration variables. Contact your administrator.");
            }
            String host = loadbalancerVariable.get().getValue();
            url = url.replaceAll("/[0-9.]+:", "/" + host + ":");
        }
        this.preparedStatementConnection = DriverManager.getConnection(url, jdbcOptions.get("user"), jdbcOptions.get("password"));
    }

    private String zipArraysToTupleString(List<List<Object>> lists) {
        ArrayList<String> zippedTuples = new ArrayList<String>();
        for (int i = 0; i < lists.get(0).size(); ++i) {
            ArrayList<String> zippedArray = new ArrayList<String>();
            for (List<Object> in : lists) {
                zippedArray.add(in.get(i).toString());
            }
            zippedTuples.add("(" + String.join((CharSequence)",", zippedArray) + ")");
        }
        return "(" + String.join((CharSequence)",", zippedTuples) + ")";
    }

    private void refreshJdbcConnection(FeatureStoreBase featureStoreBase, Boolean external) throws FeatureStoreException, IOException, SQLException {
        if (!this.preparedStatementConnection.isValid(1)) {
            this.setupJdbcConnection(featureStoreBase, external);
        }
    }

    private Object deserializeComplexFeature(Map<String, DatumReader<Object>> complexFeatureSchemas, ResultSet results, int index) throws SQLException, IOException {
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(results.getBytes(index), this.binaryDecoder);
        return complexFeatureSchemas.get(results.getMetaData().getColumnName(index)).read(null, (Decoder)decoder);
    }

    private Map<String, DatumReader<Object>> getComplexFeatureSchemas(List<TrainingDatasetFeature> features) throws FeatureStoreException, IOException {
        HashMap<String, DatumReader<Object>> featureSchemaMap = new HashMap<String, DatumReader<Object>>();
        for (TrainingDatasetFeature f : features) {
            if (!f.isComplex()) continue;
            GenericDatumReader datumReader = new GenericDatumReader(this.parser.parse(f.getFeatureGroup().getFeatureAvroSchema(f.getName())));
            featureSchemaMap.put(f.getName(), (DatumReader<Object>)datumReader);
        }
        return featureSchemaMap;
    }

    private void checkPrimaryKeys(Set<String> primaryKeys) {
        if (!this.servingKeys.equals(primaryKeys)) {
            throw new IllegalArgumentException("Provided primary key map doesn't correspond to serving_keys");
        }
    }

    public VectorServer() {
    }

    public HashSet<String> getServingKeys() {
        return this.servingKeys;
    }
}

