/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.TrainingDatasetFeature;
import com.logicalclocks.hsfs.constructor.QueryBase;
import com.logicalclocks.hsfs.engine.VectorServer;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FeatureViewBase<T extends FeatureViewBase, T3 extends FeatureStoreBase<T4>, T4 extends QueryBase, T5> {
    @JsonIgnore
    protected T3 featureStore;
    @JsonIgnore
    protected Integer id;
    protected String name;
    protected Integer version;
    protected String description;
    protected List<TrainingDatasetFeature> features;
    protected T4 query;
    @JsonIgnore
    protected List<String> labels;
    protected String type = "featureViewDTO";
    protected static final Logger LOGGER = LoggerFactory.getLogger(FeatureViewBase.class);
    protected VectorServer vectorServer = new VectorServer();
    protected Integer extraFilterVersion = null;

    public void initServing() throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.vectorServer.initServing(this, false);
    }

    @Deprecated
    public void initServing(Boolean batch, Boolean external) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.vectorServer.initServing(this, batch, external);
    }

    protected void validateTrainTestSplit(Float testSize, String trainEnd, String testStart) throws FeatureStoreException {
        if ((testSize == null || !(testSize.floatValue() > 0.0f) || !(testSize.floatValue() < 1.0f)) && Strings.isNullOrEmpty((String)trainEnd) && Strings.isNullOrEmpty((String)testStart)) {
            throw new FeatureStoreException("Invalid split input.You should specify either `testSize` or (`trainEnd` or `testStart`). `testSize` should be between 0 and 1 if specified.");
        }
    }

    protected void validateTrainValidationTestSplit(Float validationSize, Float testSize, String trainEnd, String validationStart, String validationEnd, String testStart) throws FeatureStoreException {
        if ((validationSize == null || !(validationSize.floatValue() > 0.0f) || !(validationSize.floatValue() < 1.0f) || testSize == null || !(testSize.floatValue() > 0.0f) || !(testSize.floatValue() < 1.0f) || !(validationSize.floatValue() + testSize.floatValue() < 1.0f)) && (Strings.isNullOrEmpty((String)trainEnd) && Strings.isNullOrEmpty((String)validationStart) || Strings.isNullOrEmpty((String)validationEnd) && Strings.isNullOrEmpty((String)testStart))) {
            throw new FeatureStoreException("Invalid split input. You should specify either (`validationSize` and `testSize`) or ((`trainEnd` or `validationStart`) and (`validationEnd` or `testStart`)).`validationSize`, `testSize` and sum of `validationSize` and `testSize` should be between 0 and 1 if specified.");
        }
    }

    public void initBatchScoring(Integer trainingDatasetVersion) {
        this.extraFilterVersion = trainingDatasetVersion;
    }

    @JsonIgnore
    public List<Object> getFeatureVector(Map<String, Object> entry) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.vectorServer.getFeatureVector(this, entry);
    }

    @JsonIgnore
    public List<Object> getFeatureVector(Map<String, Object> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.vectorServer.getFeatureVector(this, entry, external);
    }

    @JsonIgnore
    public List<List<Object>> getFeatureVectors(Map<String, List<Object>> entry) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.vectorServer.getFeatureVectors(this, entry);
    }

    @JsonIgnore
    public List<List<Object>> getFeatureVectors(Map<String, List<Object>> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.vectorServer.getFeatureVectors(this, entry, external);
    }

    public abstract void addTag(String var1, Object var2) throws FeatureStoreException, IOException;

    @JsonIgnore
    public abstract Map<String, Object> getTags() throws FeatureStoreException, IOException;

    @JsonIgnore
    public abstract Object getTag(String var1) throws FeatureStoreException, IOException;

    public abstract void deleteTag(String var1) throws FeatureStoreException, IOException;

    public abstract void addTrainingDatasetTag(Integer var1, String var2, Object var3) throws FeatureStoreException, IOException;

    @JsonIgnore
    public abstract Map<String, Object> getTrainingDatasetTags(Integer var1) throws FeatureStoreException, IOException;

    @JsonIgnore
    public abstract Object getTrainingDatasetTag(Integer var1, String var2) throws FeatureStoreException, IOException;

    public abstract void deleteTrainingDatasetTag(Integer var1, String var2) throws FeatureStoreException, IOException;

    @JsonIgnore
    public HashSet<String> getPrimaryKeys() throws SQLException, IOException, FeatureStoreException, ClassNotFoundException {
        if (this.vectorServer.getServingKeys().isEmpty()) {
            this.initServing();
        }
        return this.vectorServer.getServingKeys();
    }

    public abstract void delete() throws FeatureStoreException, IOException;

    public abstract void clean(T3 var1, String var2, Integer var3) throws FeatureStoreException, IOException;

    public abstract T update(T var1) throws FeatureStoreException, IOException;

    public abstract String getBatchQuery() throws FeatureStoreException, IOException, ParseException;

    public abstract String getBatchQuery(String var1, String var2) throws FeatureStoreException, IOException, ParseException;

    public abstract T5 getBatchData() throws FeatureStoreException, IOException, ParseException;

    public abstract T5 getBatchData(String var1, String var2) throws FeatureStoreException, IOException, ParseException;

    public abstract T5 getBatchData(String var1, String var2, Map<String, String> var3) throws FeatureStoreException, IOException, ParseException;

    public abstract Object getTrainingData(Integer var1, Map<String, String> var2) throws IOException, FeatureStoreException, ParseException;

    public abstract Object getTrainTestSplit(Integer var1, Map<String, String> var2) throws IOException, FeatureStoreException, ParseException;

    public abstract Object getTrainValidationTestSplit(Integer var1, Map<String, String> var2) throws IOException, FeatureStoreException, ParseException;

    public abstract void purgeTrainingData(Integer var1) throws FeatureStoreException, IOException;

    public abstract void purgeAllTrainingData() throws FeatureStoreException, IOException;

    public abstract void deleteTrainingDataset(Integer var1) throws FeatureStoreException, IOException;

    public abstract void deleteAllTrainingDatasets() throws FeatureStoreException, IOException;

    public T3 getFeatureStore() {
        return this.featureStore;
    }

    public void setFeatureStore(T3 featureStore) {
        this.featureStore = featureStore;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<TrainingDatasetFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<TrainingDatasetFeature> features) {
        this.features = features;
    }

    public T4 getQuery() {
        return this.query;
    }

    public void setQuery(T4 query) {
        this.query = query;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

