/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.OnlineIngestionResult;
import com.logicalclocks.hsfs.metadata.RestDto;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineIngestion
extends RestDto<OnlineIngestion> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(OnlineIngestion.class);
    private Integer id;
    private Long numEntries;
    private List<OnlineIngestionResult> results;
    private FeatureGroupBase featureGroup;

    public OnlineIngestion(long numEntries) {
        this.numEntries = numEntries;
    }

    public void refresh() throws FeatureStoreException, IOException {
        OnlineIngestion onlineIngestion = this.featureGroup.getOnlineIngestion(this.id);
        this.id = onlineIngestion.id;
        this.numEntries = onlineIngestion.numEntries;
        this.results = onlineIngestion.results;
        this.featureGroup = onlineIngestion.featureGroup;
    }

    public void waitForCompletion(int timeout, int period) throws InterruptedException, FeatureStoreException, IOException {
        long startTime = System.currentTimeMillis();
        timeout *= 1000;
        period *= 1000;
        while (true) {
            long rowsProcessed = this.results.stream().collect(Collectors.summarizingLong(o -> o.getRows())).getSum();
            if (this.numEntries != null && rowsProcessed >= this.numEntries) break;
            if (timeout != 0 && System.currentTimeMillis() - startTime > (long)timeout) {
                LOGGER.warn("Timeout of " + timeout + " was exceeded while waiting for online ingestion completion.");
                break;
            }
            Thread.sleep(period);
            this.refresh();
        }
    }

    public OnlineIngestion() {
    }

    public OnlineIngestion(Integer id, Long numEntries, List<OnlineIngestionResult> results, FeatureGroupBase featureGroup) {
        this.id = id;
        this.numEntries = numEntries;
        this.results = results;
        this.featureGroup = featureGroup;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Long getNumEntries() {
        return this.numEntries;
    }

    public void setNumEntries(Long numEntries) {
        this.numEntries = numEntries;
    }

    public List<OnlineIngestionResult> getResults() {
        return this.results;
    }

    public void setResults(List<OnlineIngestionResult> results) {
        this.results = results;
    }

    public FeatureGroupBase getFeatureGroup() {
        return this.featureGroup;
    }

    public void setFeatureGroup(FeatureGroupBase featureGroup) {
        this.featureGroup = featureGroup;
    }
}

