/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.constructor.Filter;
import com.logicalclocks.hsfs.constructor.SqlFilterCondition;
import com.logicalclocks.hsfs.util.Constants;
import java.io.IOException;
import java.util.Collection;
import lombok.Generated;
import lombok.NonNull;
import org.json.JSONArray;

public class Feature {
    private String name;
    private String type;
    private String onlineType;
    private String description;
    private Boolean primary;
    private Boolean partition;
    private Boolean hudiPrecombineKey = false;
    private String defaultValue;
    private Integer featureGroupId;
    private static ObjectMapper mapper = new ObjectMapper();

    public Feature(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.setName(name);
    }

    public Feature(@NonNull String name, @NonNull FeatureGroupBase featureGroup) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (featureGroup == null) {
            throw new NullPointerException("featureGroup is marked non-null but is null");
        }
        this.setName(name);
        this.featureGroupId = featureGroup.getId();
    }

    public Feature(@NonNull String name, @NonNull int featureGroupId) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.setName(name);
        this.featureGroupId = featureGroupId;
    }

    public Feature(@NonNull String name, @NonNull String type) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.name = name.toLowerCase();
        this.type = type;
    }

    public Feature(@NonNull String name, @NonNull String type, @NonNull String defaultValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        this.setName(name);
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public Feature(String name, String type, Boolean primary, Boolean partition) throws FeatureStoreException {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new FeatureStoreException("Name is required when creating a feature");
        }
        this.setName(name);
        if (Strings.isNullOrEmpty((String)type)) {
            throw new FeatureStoreException("Type is required when creating a feature");
        }
        this.type = type;
        this.primary = primary;
        this.partition = partition;
    }

    public Feature(String name, String type, String onlineType, Boolean primary, Boolean partition, String defaultValue, String description) throws FeatureStoreException {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new FeatureStoreException("Name is required when creating a feature");
        }
        this.setName(name);
        if (Strings.isNullOrEmpty((String)type)) {
            throw new FeatureStoreException("Type is required when creating a feature");
        }
        this.type = type;
        this.onlineType = onlineType;
        this.primary = primary;
        this.partition = partition;
        this.defaultValue = defaultValue;
        this.description = description;
    }

    @JsonIgnore
    public boolean isComplex() {
        return Constants.COMPLEX_FEATURE_TYPES.stream().anyMatch(c -> this.type.toUpperCase().startsWith((String)c));
    }

    public void setName(String name) {
        this.name = name.toLowerCase();
    }

    public Filter lt(Object value) {
        return new Filter(this, SqlFilterCondition.LESS_THAN, value.toString());
    }

    public Filter lt(Feature value) {
        return new Filter(this, SqlFilterCondition.LESS_THAN, value.toString());
    }

    public Filter le(Object value) {
        return new Filter(this, SqlFilterCondition.LESS_THAN_OR_EQUAL, value.toString());
    }

    public Filter le(Feature value) {
        return new Filter(this, SqlFilterCondition.LESS_THAN_OR_EQUAL, value.toJson());
    }

    public Filter eq(Object value) {
        return new Filter(this, SqlFilterCondition.EQUALS, value.toString());
    }

    public Filter eq(Feature value) {
        return new Filter(this, SqlFilterCondition.EQUALS, value.toJson());
    }

    public Filter ne(Object value) {
        return new Filter(this, SqlFilterCondition.NOT_EQUALS, value.toString());
    }

    public Filter ne(Feature value) {
        return new Filter(this, SqlFilterCondition.NOT_EQUALS, value.toJson());
    }

    public Filter gt(Object value) {
        return new Filter(this, SqlFilterCondition.GREATER_THAN, value.toString());
    }

    public Filter gt(Feature value) {
        return new Filter(this, SqlFilterCondition.GREATER_THAN, value.toJson());
    }

    public Filter ge(Object value) {
        return new Filter(this, SqlFilterCondition.GREATER_THAN_OR_EQUAL, value.toString());
    }

    public Filter ge(Feature value) {
        return new Filter(this, SqlFilterCondition.GREATER_THAN_OR_EQUAL, value.toJson());
    }

    @Deprecated
    public Filter in(Collection<?> collection) {
        return this.isin(collection);
    }

    public Filter isin(Collection<?> collection) {
        JSONArray jsonArray = new JSONArray(collection);
        return new Filter(this, SqlFilterCondition.IN, jsonArray.toString());
    }

    public Filter like(Object value) {
        return new Filter(this, SqlFilterCondition.LIKE, value.toString());
    }

    public String toJson() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot serialize Feature object.");
        }
    }

    @Generated
    public static FeatureBuilder builder() {
        return new FeatureBuilder();
    }

    @Generated
    public Feature(String name, String type, String onlineType, String description, Boolean primary, Boolean partition, Boolean hudiPrecombineKey, String defaultValue, Integer featureGroupId) {
        this.name = name;
        this.type = type;
        this.onlineType = onlineType;
        this.description = description;
        this.primary = primary;
        this.partition = partition;
        this.hudiPrecombineKey = hudiPrecombineKey;
        this.defaultValue = defaultValue;
        this.featureGroupId = featureGroupId;
    }

    @Generated
    public Feature() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public String getOnlineType() {
        return this.onlineType;
    }

    @Generated
    public void setOnlineType(String onlineType) {
        this.onlineType = onlineType;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public Boolean getPrimary() {
        return this.primary;
    }

    @Generated
    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    @Generated
    public Boolean getPartition() {
        return this.partition;
    }

    @Generated
    public void setPartition(Boolean partition) {
        this.partition = partition;
    }

    @Generated
    public Boolean getHudiPrecombineKey() {
        return this.hudiPrecombineKey;
    }

    @Generated
    public void setHudiPrecombineKey(Boolean hudiPrecombineKey) {
        this.hudiPrecombineKey = hudiPrecombineKey;
    }

    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public Integer getFeatureGroupId() {
        return this.featureGroupId;
    }

    @Generated
    public void setFeatureGroupId(Integer featureGroupId) {
        this.featureGroupId = featureGroupId;
    }

    @Generated
    public static class FeatureBuilder {
        @Generated
        private String name;
        @Generated
        private String type;
        @Generated
        private String onlineType;
        @Generated
        private Boolean primary;
        @Generated
        private Boolean partition;
        @Generated
        private String defaultValue;
        @Generated
        private String description;

        @Generated
        FeatureBuilder() {
        }

        @Generated
        public FeatureBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public FeatureBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public FeatureBuilder onlineType(String onlineType) {
            this.onlineType = onlineType;
            return this;
        }

        @Generated
        public FeatureBuilder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        @Generated
        public FeatureBuilder partition(Boolean partition) {
            this.partition = partition;
            return this;
        }

        @Generated
        public FeatureBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Generated
        public FeatureBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public Feature build() throws FeatureStoreException {
            return new Feature(this.name, this.type, this.onlineType, this.primary, this.partition, this.defaultValue, this.description);
        }

        @Generated
        public String toString() {
            return "Feature.FeatureBuilder(name=" + this.name + ", type=" + this.type + ", onlineType=" + this.onlineType + ", primary=" + this.primary + ", partition=" + this.partition + ", defaultValue=" + this.defaultValue + ", description=" + this.description + ")";
        }
    }
}

