/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.logicalclocks.hsfs.StreamFeatureGroup;
import com.logicalclocks.hsfs.TransformationFunction;
import com.logicalclocks.hsfs.util.Constants;
import lombok.Generated;

public class TrainingDatasetFeature {
    private String name;
    private String type;
    private StreamFeatureGroup featuregroup;
    private Integer index;
    private Boolean label = false;
    private TransformationFunction transformationFunction;

    public TrainingDatasetFeature(String name, String type) {
        this.setName(name);
        this.type = type;
    }

    public TrainingDatasetFeature(String name, String type, Integer index) {
        this.setName(name);
        this.type = type;
        this.index = index;
    }

    public TrainingDatasetFeature(String name, String type, Integer index, Boolean label) {
        this.setName(name);
        this.type = type;
        this.index = index;
        this.label = label;
    }

    public TrainingDatasetFeature(StreamFeatureGroup featuregroup, String name, Boolean label) {
        this.setName(name);
        this.featuregroup = featuregroup;
        this.label = label;
    }

    public void setName(String name) {
        this.name = name.toLowerCase();
    }

    @JsonIgnore
    public boolean isComplex() {
        return this.label == false && Constants.COMPLEX_FEATURE_TYPES.stream().anyMatch(c -> this.type.toUpperCase().startsWith((String)c));
    }

    @Generated
    public static TrainingDatasetFeatureBuilder builder() {
        return new TrainingDatasetFeatureBuilder();
    }

    @Generated
    public TrainingDatasetFeature() {
    }

    @Generated
    public TrainingDatasetFeature(String name, String type, StreamFeatureGroup featuregroup, Integer index, Boolean label, TransformationFunction transformationFunction) {
        this.name = name;
        this.type = type;
        this.featuregroup = featuregroup;
        this.index = index;
        this.label = label;
        this.transformationFunction = transformationFunction;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public StreamFeatureGroup getFeaturegroup() {
        return this.featuregroup;
    }

    @Generated
    public void setFeaturegroup(StreamFeatureGroup featuregroup) {
        this.featuregroup = featuregroup;
    }

    @Generated
    public Integer getIndex() {
        return this.index;
    }

    @Generated
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Generated
    public Boolean getLabel() {
        return this.label;
    }

    @Generated
    public void setLabel(Boolean label) {
        this.label = label;
    }

    @Generated
    public TransformationFunction getTransformationFunction() {
        return this.transformationFunction;
    }

    @Generated
    public void setTransformationFunction(TransformationFunction transformationFunction) {
        this.transformationFunction = transformationFunction;
    }

    @Generated
    public static class TrainingDatasetFeatureBuilder {
        @Generated
        private String name;
        @Generated
        private String type;

        @Generated
        TrainingDatasetFeatureBuilder() {
        }

        @Generated
        public TrainingDatasetFeatureBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public TrainingDatasetFeatureBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public TrainingDatasetFeature build() {
            return new TrainingDatasetFeature(this.name, this.type);
        }

        @Generated
        public String toString() {
            return "TrainingDatasetFeature.TrainingDatasetFeatureBuilder(name=" + this.name + ", type=" + this.type + ")";
        }
    }
}

