/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Strings;
import com.logicalclocks.hsfs.DataSource;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.SecurityProtocol;
import com.logicalclocks.hsfs.SslEndpointIdentificationAlgorithm;
import com.logicalclocks.hsfs.StorageConnectorType;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.HopsworksHttpClient;
import com.logicalclocks.hsfs.metadata.Option;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.utils.CollectionUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="storageConnectorType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=HopsFsConnector.class, name="HOPSFS"), @JsonSubTypes.Type(value=S3Connector.class, name="S3"), @JsonSubTypes.Type(value=RedshiftConnector.class, name="REDSHIFT"), @JsonSubTypes.Type(value=AdlsConnector.class, name="ADLS"), @JsonSubTypes.Type(value=SnowflakeConnector.class, name="SNOWFLAKE"), @JsonSubTypes.Type(value=JdbcConnector.class, name="JDBC"), @JsonSubTypes.Type(value=KafkaConnector.class, name="KAFKA"), @JsonSubTypes.Type(value=GcsConnector.class, name="GCS"), @JsonSubTypes.Type(value=BigqueryConnector.class, name="BIGQUERY"), @JsonSubTypes.Type(value=RdsConnector.class, name="RDS")})
public abstract class StorageConnector {
    protected StorageConnectorType storageConnectorType;
    protected Integer id;
    protected String name;
    protected String description;
    protected Integer featurestoreId;
    protected StorageConnectorApi storageConnectorApi = new StorageConnectorApi();
    protected static final Logger LOGGER = LoggerFactory.getLogger(StorageConnector.class);

    public StorageConnector refetch() throws FeatureStoreException, IOException {
        return this.storageConnectorApi.get(this.getFeaturestoreId(), this.getName(), StorageConnector.class);
    }

    @JsonIgnore
    public abstract String getPath(String var1) throws FeatureStoreException;

    public Map<String, String> sparkOptions() throws IOException, FeatureStoreException {
        return this.sparkOptions(null);
    }

    public abstract Map<String, String> sparkOptions(DataSource var1) throws IOException, FeatureStoreException;

    @Generated
    public StorageConnector(StorageConnectorType storageConnectorType, Integer id, String name, String description, Integer featurestoreId, StorageConnectorApi storageConnectorApi) {
        this.storageConnectorType = storageConnectorType;
        this.id = id;
        this.name = name;
        this.description = description;
        this.featurestoreId = featurestoreId;
        this.storageConnectorApi = storageConnectorApi;
    }

    @Generated
    public StorageConnector() {
    }

    @Generated
    public String toString() {
        return "StorageConnector(storageConnectorType=" + (Object)((Object)this.getStorageConnectorType()) + ", id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", featurestoreId=" + this.getFeaturestoreId() + ", storageConnectorApi=" + this.storageConnectorApi + ")";
    }

    @Generated
    public StorageConnectorType getStorageConnectorType() {
        return this.storageConnectorType;
    }

    @Generated
    public void setStorageConnectorType(StorageConnectorType storageConnectorType) {
        this.storageConnectorType = storageConnectorType;
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public Integer getFeaturestoreId() {
        return this.featurestoreId;
    }

    @Generated
    public void setFeaturestoreId(Integer featurestoreId) {
        this.featurestoreId = featurestoreId;
    }

    public static class RdsConnector
    extends StorageConnector {
        protected String host;
        protected Integer port;
        protected String database;
        protected String user;
        protected String password;
        protected List<Option> arguments;

        @Override
        public Map<String, String> sparkOptions(DataSource dataSource) {
            String databaseName = dataSource == null ? this.database : dataSource.getDatabase();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("url", "jdbc:postgresql://" + this.getHost() + ":" + this.getPort() + "/" + databaseName);
            options.put("user", this.getUser());
            options.put("password", this.getPassword());
            options.put("driver", "org.postgresql.Driver");
            if (this.arguments != null && !this.arguments.isEmpty()) {
                Map<String, String> argOptions = this.arguments.stream().collect(Collectors.toMap(Option::getName, Option::getValue));
                options.putAll(argOptions);
            }
            return options;
        }

        public void update() throws FeatureStoreException, IOException {
            RdsConnector updatedConnector = (RdsConnector)this.refetch();
            this.host = updatedConnector.getHost();
            this.port = updatedConnector.getPort();
            this.database = updatedConnector.getDatabase();
            this.user = updatedConnector.getUser();
            this.password = updatedConnector.getPassword();
            this.arguments = updatedConnector.getArguments();
        }

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return null;
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public void setHost(String host) {
            this.host = host;
        }

        @Generated
        public Integer getPort() {
            return this.port;
        }

        @Generated
        public void setPort(Integer port) {
            this.port = port;
        }

        @Generated
        public String getDatabase() {
            return this.database;
        }

        @Generated
        public void setDatabase(String database) {
            this.database = database;
        }

        @Generated
        public String getUser() {
            return this.user;
        }

        @Generated
        public void setUser(String user) {
            this.user = user;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public List<Option> getArguments() {
            return this.arguments;
        }

        @Generated
        public void setArguments(List<Option> arguments) {
            this.arguments = arguments;
        }
    }

    public static class BigqueryConnector
    extends StorageConnector {
        protected String keyPath;
        protected String parentProject;
        protected String queryProject;
        protected String dataset;
        protected String queryTable;
        protected String materializationDataset;
        protected List<Option> arguments;

        @Override
        public Map<String, String> sparkOptions(DataSource dataSource) {
            String schemaName;
            String databaseName = dataSource == null ? this.parentProject : dataSource.getDatabase();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("parentProject", databaseName);
            if (!Strings.isNullOrEmpty((String)this.materializationDataset)) {
                options.put("materializationDataset", this.materializationDataset);
                options.put("viewsEnabled", "true");
            }
            if (!Strings.isNullOrEmpty((String)this.queryProject)) {
                options.put("project", this.queryProject);
            }
            String string = schemaName = dataSource == null ? this.dataset : dataSource.getGroup();
            if (!Strings.isNullOrEmpty((String)schemaName)) {
                options.put("dataset", schemaName);
            }
            if (this.arguments != null && !this.arguments.isEmpty()) {
                Map<String, String> argOptions = this.arguments.stream().collect(Collectors.toMap(Option::getName, Option::getValue));
                options.putAll(argOptions);
            }
            return options;
        }

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return null;
        }

        @Generated
        public String getKeyPath() {
            return this.keyPath;
        }

        @Generated
        public void setKeyPath(String keyPath) {
            this.keyPath = keyPath;
        }

        @Generated
        public String getParentProject() {
            return this.parentProject;
        }

        @Generated
        public void setParentProject(String parentProject) {
            this.parentProject = parentProject;
        }

        @Generated
        public String getQueryProject() {
            return this.queryProject;
        }

        @Generated
        public void setQueryProject(String queryProject) {
            this.queryProject = queryProject;
        }

        @Generated
        public String getDataset() {
            return this.dataset;
        }

        @Generated
        public void setDataset(String dataset) {
            this.dataset = dataset;
        }

        @Generated
        public String getQueryTable() {
            return this.queryTable;
        }

        @Generated
        public void setQueryTable(String queryTable) {
            this.queryTable = queryTable;
        }

        @Generated
        public String getMaterializationDataset() {
            return this.materializationDataset;
        }

        @Generated
        public void setMaterializationDataset(String materializationDataset) {
            this.materializationDataset = materializationDataset;
        }

        @Generated
        public List<Option> getArguments() {
            return this.arguments;
        }

        @Generated
        public void setArguments(List<Option> arguments) {
            this.arguments = arguments;
        }
    }

    public static class GcsConnector
    extends StorageConnector {
        protected String keyPath;
        protected String algorithm;
        protected String encryptionKey;
        protected String encryptionKeyHash;
        protected String bucket;

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return "gs://" + this.bucket + "/" + (Strings.isNullOrEmpty((String)subPath) ? "" : subPath);
        }

        @Override
        public Map<String, String> sparkOptions(DataSource dataSource) {
            return new HashMap<String, String>();
        }

        @Generated
        public String getKeyPath() {
            return this.keyPath;
        }

        @Generated
        public void setKeyPath(String keyPath) {
            this.keyPath = keyPath;
        }

        @Generated
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Generated
        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        @Generated
        public String getEncryptionKey() {
            return this.encryptionKey;
        }

        @Generated
        public void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Generated
        public String getEncryptionKeyHash() {
            return this.encryptionKeyHash;
        }

        @Generated
        public void setEncryptionKeyHash(String encryptionKeyHash) {
            this.encryptionKeyHash = encryptionKeyHash;
        }

        @Generated
        public String getBucket() {
            return this.bucket;
        }

        @Generated
        public void setBucket(String bucket) {
            this.bucket = bucket;
        }
    }

    public static class KafkaConnector
    extends StorageConnector {
        public static final String sparkFormat = "kafka";
        protected String bootstrapServers;
        protected SecurityProtocol securityProtocol;
        protected String sslTruststoreLocation;
        protected String sslTruststorePassword;
        protected String sslKeystoreLocation;
        protected String sslKeystorePassword;
        protected String sslKeyPassword;
        protected SslEndpointIdentificationAlgorithm sslEndpointIdentificationAlgorithm;
        protected List<Option> options;
        protected Boolean externalKafka;

        public Map<String, String> kafkaOptions() throws FeatureStoreException {
            HopsworksHttpClient client = HopsworksClient.getInstance().getHopsworksHttpClient();
            HashMap<String, String> config = new HashMap<String, String>();
            if (this.options != null && !this.options.isEmpty()) {
                Map<String, String> argOptions = this.options.stream().collect(Collectors.toMap(Option::getName, Option::getValue));
                config.putAll(argOptions);
            }
            config.put("bootstrap.servers", this.bootstrapServers);
            config.put("security.protocol", this.securityProtocol.toString());
            config.put("ssl.endpoint.identification.algorithm", this.sslEndpointIdentificationAlgorithm.getValue());
            if (!this.externalKafka.booleanValue()) {
                this.sslTruststoreLocation = client.getTrustStorePath();
                this.sslTruststorePassword = client.getCertKey();
                this.sslKeystoreLocation = client.getKeyStorePath();
                this.sslKeystorePassword = client.getCertKey();
                this.sslKeyPassword = client.getCertKey();
            }
            if (this.sslTruststoreLocation != null) {
                config.put("ssl.truststore.location", this.sslTruststoreLocation);
            }
            if (this.sslTruststorePassword != null) {
                config.put("ssl.truststore.password", this.sslTruststorePassword);
            }
            if (this.sslKeystoreLocation != null) {
                config.put("ssl.keystore.location", this.sslKeystoreLocation);
            }
            if (this.sslKeystorePassword != null) {
                config.put("ssl.keystore.password", this.sslKeystorePassword);
            }
            if (this.sslKeyPassword != null) {
                config.put("ssl.key.password", this.sslKeyPassword);
            }
            if (this.externalKafka.booleanValue()) {
                LOGGER.info("Getting connection details to externally managed Kafka cluster. Make sure that the topic being used exists.");
            }
            return config;
        }

        @Override
        public Map<String, String> sparkOptions(DataSource dataSource) throws FeatureStoreException {
            HashMap<String, String> config = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this.kafkaOptions().entrySet()) {
                config.put(String.format("%s.%s", sparkFormat, entry.getKey()), entry.getValue());
            }
            return config;
        }

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return null;
        }

        @Generated
        public String getBootstrapServers() {
            return this.bootstrapServers;
        }

        @Generated
        public void setBootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
        }

        @Generated
        public SecurityProtocol getSecurityProtocol() {
            return this.securityProtocol;
        }

        @Generated
        public void setSecurityProtocol(SecurityProtocol securityProtocol) {
            this.securityProtocol = securityProtocol;
        }

        @Generated
        public String getSslTruststoreLocation() {
            return this.sslTruststoreLocation;
        }

        @Generated
        public void setSslTruststoreLocation(String sslTruststoreLocation) {
            this.sslTruststoreLocation = sslTruststoreLocation;
        }

        @Generated
        public String getSslTruststorePassword() {
            return this.sslTruststorePassword;
        }

        @Generated
        public void setSslTruststorePassword(String sslTruststorePassword) {
            this.sslTruststorePassword = sslTruststorePassword;
        }

        @Generated
        public String getSslKeystoreLocation() {
            return this.sslKeystoreLocation;
        }

        @Generated
        public void setSslKeystoreLocation(String sslKeystoreLocation) {
            this.sslKeystoreLocation = sslKeystoreLocation;
        }

        @Generated
        public String getSslKeystorePassword() {
            return this.sslKeystorePassword;
        }

        @Generated
        public void setSslKeystorePassword(String sslKeystorePassword) {
            this.sslKeystorePassword = sslKeystorePassword;
        }

        @Generated
        public String getSslKeyPassword() {
            return this.sslKeyPassword;
        }

        @Generated
        public void setSslKeyPassword(String sslKeyPassword) {
            this.sslKeyPassword = sslKeyPassword;
        }

        @Generated
        public SslEndpointIdentificationAlgorithm getSslEndpointIdentificationAlgorithm() {
            return this.sslEndpointIdentificationAlgorithm;
        }

        @Generated
        public void setSslEndpointIdentificationAlgorithm(SslEndpointIdentificationAlgorithm sslEndpointIdentificationAlgorithm) {
            this.sslEndpointIdentificationAlgorithm = sslEndpointIdentificationAlgorithm;
        }

        @Generated
        public List<Option> getOptions() {
            return this.options;
        }

        @Generated
        public void setOptions(List<Option> options) {
            this.options = options;
        }

        @Generated
        public Boolean getExternalKafka() {
            return this.externalKafka;
        }

        @Generated
        public void setExternalKafka(Boolean externalKafka) {
            this.externalKafka = externalKafka;
        }
    }

    public static class JdbcConnector
    extends StorageConnector {
        protected String connectionString;
        protected List<Option> arguments;

        @Override
        public Map<String, String> sparkOptions(DataSource dataSource) {
            HashMap<String, String> options = new HashMap<String, String>();
            if (this.arguments != null && !this.arguments.isEmpty()) {
                Map<String, String> readOptions = this.arguments.stream().collect(Collectors.toMap(Option::getName, Option::getValue));
                options.putAll(readOptions);
            }
            options.put("url", this.connectionString);
            return options;
        }

        public void update() throws FeatureStoreException, IOException {
            JdbcConnector updatedConnector = (JdbcConnector)this.refetch();
            this.connectionString = updatedConnector.getConnectionString();
            this.arguments = updatedConnector.getArguments();
        }

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return null;
        }

        @Generated
        public String getConnectionString() {
            return this.connectionString;
        }

        @Generated
        public void setConnectionString(String connectionString) {
            this.connectionString = connectionString;
        }

        @Generated
        public List<Option> getArguments() {
            return this.arguments;
        }

        @Generated
        public void setArguments(List<Option> arguments) {
            this.arguments = arguments;
        }
    }

    public static class SnowflakeConnector
    extends StorageConnector {
        protected String url;
        protected String user;
        protected String password;
        protected String token;
        protected String database;
        protected String schema;
        protected String warehouse;
        protected String role;
        protected String table;
        protected String application;
        protected List<Option> sfOptions;

        public String account() {
            return this.url.replace("https://", "").replace(".snowflakecomputing.com", "");
        }

        @Override
        public Map<String, String> sparkOptions(DataSource dataSource) {
            String tableName;
            String databaseName = dataSource == null ? this.database : dataSource.getDatabase();
            String schemaName = dataSource == null ? this.schema : dataSource.getGroup();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("sfURL", this.url);
            options.put("sfSchema", schemaName);
            options.put("sfDatabase", databaseName);
            options.put("sfUser", this.user);
            if (!Strings.isNullOrEmpty((String)this.password)) {
                options.put("sfPassword", this.password);
            } else {
                options.put("sfAuthenticator", "oauth");
                options.put("sfToken", this.token);
            }
            if (!Strings.isNullOrEmpty((String)this.warehouse)) {
                options.put("sfWarehouse", this.warehouse);
            }
            if (!Strings.isNullOrEmpty((String)this.role)) {
                options.put("sfRole", this.role);
            }
            String string = tableName = dataSource == null ? this.table : dataSource.getTable();
            if (!Strings.isNullOrEmpty((String)tableName)) {
                options.put("dbtable", tableName);
            }
            if (!Strings.isNullOrEmpty((String)this.application)) {
                options.put("application", this.application);
            }
            if (this.sfOptions != null && !this.sfOptions.isEmpty()) {
                Map<String, String> argOptions = this.sfOptions.stream().collect(Collectors.toMap(Option::getName, Option::getValue));
                options.putAll(argOptions);
            }
            return options;
        }

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return null;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public String getUser() {
            return this.user;
        }

        @Generated
        public void setUser(String user) {
            this.user = user;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public String getToken() {
            return this.token;
        }

        @Generated
        public void setToken(String token) {
            this.token = token;
        }

        @Generated
        public String getDatabase() {
            return this.database;
        }

        @Generated
        public void setDatabase(String database) {
            this.database = database;
        }

        @Generated
        public String getSchema() {
            return this.schema;
        }

        @Generated
        public void setSchema(String schema) {
            this.schema = schema;
        }

        @Generated
        public String getWarehouse() {
            return this.warehouse;
        }

        @Generated
        public void setWarehouse(String warehouse) {
            this.warehouse = warehouse;
        }

        @Generated
        public String getRole() {
            return this.role;
        }

        @Generated
        public void setRole(String role) {
            this.role = role;
        }

        @Generated
        public String getTable() {
            return this.table;
        }

        @Generated
        public void setTable(String table) {
            this.table = table;
        }

        @Generated
        public String getApplication() {
            return this.application;
        }

        @Generated
        public void setApplication(String application) {
            this.application = application;
        }

        @Generated
        public List<Option> getSfOptions() {
            return this.sfOptions;
        }

        @Generated
        public void setSfOptions(List<Option> sfOptions) {
            this.sfOptions = sfOptions;
        }
    }

    public static class AdlsConnector
    extends StorageConnector {
        protected Integer generation;
        protected String directoryId;
        protected String applicationId;
        protected String serviceCredential;
        protected String accountName;
        protected String containerName;
        protected List<Option> sparkOptions;

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return (this.generation == 2 ? "abfss://" + this.containerName + "@" + this.accountName + ".dfs.core.windows.net/" : "adl://" + this.accountName + ".azuredatalakestore.net/") + (Strings.isNullOrEmpty((String)subPath) ? "" : subPath);
        }

        @Override
        public Map<String, String> sparkOptions(DataSource dataSource) {
            HashMap<String, String> options = new HashMap<String, String>();
            this.sparkOptions.stream().forEach(option -> options.put(option.getName(), option.getValue()));
            return options;
        }

        @Generated
        public Integer getGeneration() {
            return this.generation;
        }

        @Generated
        public void setGeneration(Integer generation) {
            this.generation = generation;
        }

        @Generated
        public String getDirectoryId() {
            return this.directoryId;
        }

        @Generated
        public void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Generated
        public String getApplicationId() {
            return this.applicationId;
        }

        @Generated
        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Generated
        public String getServiceCredential() {
            return this.serviceCredential;
        }

        @Generated
        public void setServiceCredential(String serviceCredential) {
            this.serviceCredential = serviceCredential;
        }

        @Generated
        public String getAccountName() {
            return this.accountName;
        }

        @Generated
        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Generated
        public String getContainerName() {
            return this.containerName;
        }

        @Generated
        public void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Generated
        public List<Option> getSparkOptions() {
            return this.sparkOptions;
        }

        @Generated
        public void setSparkOptions(List<Option> sparkOptions) {
            this.sparkOptions = sparkOptions;
        }
    }

    public static class RedshiftConnector
    extends StorageConnector {
        protected String clusterIdentifier;
        protected String databaseDriver;
        protected String databaseEndpoint;
        protected String databaseName;
        protected Integer databasePort;
        protected String tableName;
        protected String databaseUserName;
        protected Boolean autoCreate;
        protected String databasePassword;
        protected String databaseGroup;
        protected String iamRole;
        protected List<Option> arguments;
        protected Instant expiration;

        @Override
        public Map<String, String> sparkOptions(DataSource dataSource) {
            String table;
            String database = dataSource == null ? this.databaseName : dataSource.getDatabase();
            String constr = "jdbc:redshift://" + this.clusterIdentifier + "." + this.databaseEndpoint + ":" + this.databasePort + "/" + database;
            if (this.arguments != null && !this.arguments.isEmpty()) {
                constr = constr + "?" + this.arguments.stream().map(arg -> arg.getName() + (arg.getValue() != null ? "=" + arg.getValue() : "")).collect(Collectors.joining(","));
            }
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("driver", this.databaseDriver);
            options.put("url", constr);
            options.put("user", this.databaseUserName);
            options.put("password", this.databasePassword);
            String string = table = dataSource == null ? this.tableName : dataSource.getTable();
            if (!Strings.isNullOrEmpty((String)table)) {
                options.put("dbtable", table);
            }
            return options;
        }

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return null;
        }

        public void update() throws FeatureStoreException, IOException {
            RedshiftConnector updatedConnector = (RedshiftConnector)this.refetch();
            this.databaseUserName = updatedConnector.getDatabaseUserName();
            this.expiration = updatedConnector.getExpiration();
            this.databasePassword = updatedConnector.getDatabasePassword();
        }

        @Generated
        public String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Generated
        public void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Generated
        public String getDatabaseDriver() {
            return this.databaseDriver;
        }

        @Generated
        public void setDatabaseDriver(String databaseDriver) {
            this.databaseDriver = databaseDriver;
        }

        @Generated
        public String getDatabaseEndpoint() {
            return this.databaseEndpoint;
        }

        @Generated
        public void setDatabaseEndpoint(String databaseEndpoint) {
            this.databaseEndpoint = databaseEndpoint;
        }

        @Generated
        public String getDatabaseName() {
            return this.databaseName;
        }

        @Generated
        public void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Generated
        public Integer getDatabasePort() {
            return this.databasePort;
        }

        @Generated
        public void setDatabasePort(Integer databasePort) {
            this.databasePort = databasePort;
        }

        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Generated
        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Generated
        public String getDatabaseUserName() {
            return this.databaseUserName;
        }

        @Generated
        public void setDatabaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
        }

        @Generated
        public Boolean getAutoCreate() {
            return this.autoCreate;
        }

        @Generated
        public void setAutoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
        }

        @Generated
        public String getDatabasePassword() {
            return this.databasePassword;
        }

        @Generated
        public void setDatabasePassword(String databasePassword) {
            this.databasePassword = databasePassword;
        }

        @Generated
        public String getDatabaseGroup() {
            return this.databaseGroup;
        }

        @Generated
        public void setDatabaseGroup(String databaseGroup) {
            this.databaseGroup = databaseGroup;
        }

        @Generated
        public String getIamRole() {
            return this.iamRole;
        }

        @Generated
        public void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Generated
        public List<Option> getArguments() {
            return this.arguments;
        }

        @Generated
        public void setArguments(List<Option> arguments) {
            this.arguments = arguments;
        }

        @Generated
        public Instant getExpiration() {
            return this.expiration;
        }

        @Generated
        public void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }
    }

    public static class S3Connector
    extends StorageConnector {
        protected String accessKey;
        protected String secretKey;
        protected String serverEncryptionAlgorithm;
        protected String serverEncryptionKey;
        protected String bucket;
        protected String path;
        protected String region;
        protected String sessionToken;
        protected String iamRole;
        protected List<Option> arguments;

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return "s3://" + this.bucket + (Strings.isNullOrEmpty((String)this.path) ? "" : "/" + this.path) + "/" + (Strings.isNullOrEmpty((String)subPath) ? "" : subPath);
        }

        @Override
        public Map<String, String> sparkOptions(DataSource dataSource) {
            if (!CollectionUtils.isNullOrEmpty(this.arguments)) {
                return this.arguments.stream().collect(Collectors.toMap(Option::getName, Option::getValue));
            }
            return new HashMap<String, String>();
        }

        public void update() throws FeatureStoreException, IOException {
            S3Connector updatedConnector = (S3Connector)this.refetch();
            this.accessKey = updatedConnector.getAccessKey();
            this.secretKey = updatedConnector.getSecretKey();
            this.sessionToken = updatedConnector.getSessionToken();
        }

        @Generated
        public String getAccessKey() {
            return this.accessKey;
        }

        @Generated
        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        @Generated
        public String getSecretKey() {
            return this.secretKey;
        }

        @Generated
        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        @Generated
        public String getServerEncryptionAlgorithm() {
            return this.serverEncryptionAlgorithm;
        }

        @Generated
        public void setServerEncryptionAlgorithm(String serverEncryptionAlgorithm) {
            this.serverEncryptionAlgorithm = serverEncryptionAlgorithm;
        }

        @Generated
        public String getServerEncryptionKey() {
            return this.serverEncryptionKey;
        }

        @Generated
        public void setServerEncryptionKey(String serverEncryptionKey) {
            this.serverEncryptionKey = serverEncryptionKey;
        }

        @Generated
        public String getBucket() {
            return this.bucket;
        }

        @Generated
        public void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public void setPath(String path) {
            this.path = path;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public void setRegion(String region) {
            this.region = region;
        }

        @Generated
        public String getSessionToken() {
            return this.sessionToken;
        }

        @Generated
        public void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        @Generated
        public String getIamRole() {
            return this.iamRole;
        }

        @Generated
        public void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Generated
        public List<Option> getArguments() {
            return this.arguments;
        }

        @Generated
        public void setArguments(List<Option> arguments) {
            this.arguments = arguments;
        }
    }

    public static class HopsFsConnector
    extends StorageConnector {
        protected String hopsfsPath;
        protected String datasetName;

        @Override
        public Map<String, String> sparkOptions(DataSource dataSource) {
            return new HashMap<String, String>();
        }

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return this.hopsfsPath + "/" + (Strings.isNullOrEmpty((String)subPath) ? "" : subPath);
        }

        @Generated
        public String getHopsfsPath() {
            return this.hopsfsPath;
        }

        @Generated
        public void setHopsfsPath(String hopsfsPath) {
            this.hopsfsPath = hopsfsPath;
        }

        @Generated
        public String getDatasetName() {
            return this.datasetName;
        }

        @Generated
        public void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }
    }
}

