/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.FeatureViewBase;
import com.logicalclocks.hsfs.constructor.Query;
import com.logicalclocks.hsfs.engine.FeatureViewEngine;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public class FeatureView
extends FeatureViewBase<FeatureView, FeatureStore, Query, List<Object>> {
    private static final FeatureViewEngine featureViewEngine = new FeatureViewEngine();

    public FeatureView(@NonNull String name, Integer version, @NonNull Query query, String description, @NonNull FeatureStore featureStore, List<String> labels) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (featureStore == null) {
            throw new NullPointerException("featureStore is marked non-null but is null");
        }
        this.name = name;
        this.version = version;
        this.query = query;
        this.description = description;
        this.featureStore = featureStore;
        this.labels = labels != null ? labels.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
    }

    @Generated
    public FeatureView() {
    }

    public static class FeatureViewBuilder {
        private String name;
        private Integer version;
        private String description;
        private FeatureStore featureStore;
        private Query query;
        private List<String> labels;

        public FeatureViewBuilder(FeatureStore featureStore) {
            this.featureStore = featureStore;
        }

        public FeatureViewBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FeatureViewBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public FeatureViewBuilder description(String description) {
            this.description = description;
            return this;
        }

        public FeatureViewBuilder query(Query query) {
            this.query = query;
            if (query.isTimeTravel()) {
                FeatureViewBase.LOGGER.info("`as_of` argument in the `Query` will be ignored because feature view does not support time travel query.");
            }
            return this;
        }

        public FeatureViewBuilder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public FeatureView build() throws FeatureStoreException, IOException {
            FeatureView featureView = new FeatureView(this.name, this.version, this.query, this.description, this.featureStore, this.labels);
            return featureViewEngine.save(featureView, FeatureView.class);
        }
    }
}

