/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.logicalclocks.hsfs.DataSource;
import com.logicalclocks.hsfs.DeltaStreamerJobConf;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.OnlineConfig;
import com.logicalclocks.hsfs.OnlineIngestion;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.engine.FeatureGroupEngineBase;
import com.logicalclocks.hsfs.engine.FeatureGroupUtils;
import com.logicalclocks.hsfs.metadata.OnlineIngestionApi;
import com.logicalclocks.hsfs.metadata.Subject;
import com.logicalclocks.hsfs.metadata.User;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FeatureGroupBase<T> {
    protected Integer id;
    @JsonIgnore
    protected FeatureStoreBase featureStore;
    protected Integer featurestoreId;
    protected String type = "featuregroupDTO";
    protected String name;
    protected Integer version;
    protected String description;
    @JsonIgnore
    protected List<String> primaryKeys;
    protected List<Feature> features;
    protected String eventTime;
    protected Date created;
    protected User creator;
    protected StatisticsConfig statisticsConfig = new StatisticsConfig();
    protected List<String> expectationsNames;
    protected String location;
    protected TimeTravelFormat timeTravelFormat = TimeTravelFormat.HUDI;
    protected Boolean onlineEnabled;
    protected String onlineTopicName;
    protected String topicName;
    protected String notificationTopicName;
    protected List<String> statisticColumns;
    protected DeltaStreamerJobConf deltaStreamerJobConf;
    protected Boolean deprecated;
    protected OnlineConfig onlineConfig;
    protected StorageConnector storageConnector;
    protected DataSource dataSource;
    @JsonIgnore
    protected List<String> partitionKeys;
    @JsonIgnore
    protected String hudiPrecombineKey;
    @JsonIgnore
    protected Subject subject;
    protected FeatureGroupEngineBase featureGroupEngineBase = new FeatureGroupEngineBase();
    protected FeatureGroupUtils utils = new FeatureGroupUtils();
    protected OnlineIngestionApi onlineIngestionApi = new OnlineIngestionApi();
    protected static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroupBase.class);

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        this.checkDeprecated();
    }

    public void checkDeprecated() {
        if (Boolean.TRUE.equals(this.deprecated)) {
            LOGGER.warn(String.format("Feature Group `%s`, version `%s` is deprecated", this.name, this.version));
        }
    }

    public void delete() throws FeatureStoreException, IOException {
        LOGGER.warn("JobWarning: All jobs associated to feature group `" + this.name + "`, version `" + this.version + "` will be removed.");
        this.featureGroupEngineBase.delete(this);
    }

    public void addTag(String name, Object value) throws FeatureStoreException, IOException {
        this.featureGroupEngineBase.addTag(this, name, value);
    }

    @JsonIgnore
    public Map<String, Object> getTags() throws FeatureStoreException, IOException {
        return this.featureGroupEngineBase.getTags(this);
    }

    @JsonIgnore
    public Object getTag(String name) throws FeatureStoreException, IOException {
        return this.featureGroupEngineBase.getTag(this, name);
    }

    public void deleteTag(String name) throws FeatureStoreException, IOException {
        this.featureGroupEngineBase.deleteTag(this, name);
    }

    public void updateDescription(String description) throws FeatureStoreException, IOException {
        this.featureGroupEngineBase.updateDescription(this, description, this.getClass());
    }

    public void updateNotificationTopicName(String notificationTopicName) throws FeatureStoreException, IOException {
        this.featureGroupEngineBase.updateNotificationTopicName(this, notificationTopicName, this.getClass());
    }

    public void updateDeprecated() throws FeatureStoreException, IOException {
        this.updateDeprecated(true);
    }

    public void updateDeprecated(Boolean deprecate) throws FeatureStoreException, IOException {
        this.featureGroupEngineBase.updateDeprecated(this, deprecate, this.getClass());
    }

    public void updateFeatureDescription(String featureName, String description) throws FeatureStoreException, IOException {
        Feature feature = this.getFeature(featureName);
        Feature newFeature = new Feature(feature.getName(), feature.getType(), feature.getOnlineType(), feature.getPrimary(), feature.getPartition(), feature.getDefaultValue(), description);
        this.featureGroupEngineBase.updateFeatures(this, Collections.singletonList(newFeature), this.getClass());
    }

    public abstract Object insertStream(T var1) throws Exception;

    public abstract Object insertStream(T var1, Map<String, String> var2) throws Exception;

    public void updateStatisticsConfig() throws FeatureStoreException, IOException {
        this.featureGroupEngineBase.updateStatisticsConfig(this, this.getClass());
    }

    @JsonIgnore
    public Subject getSubject() throws FeatureStoreException, IOException {
        if (this.subject == null) {
            this.subject = this.utils.getSubject(this);
        }
        return this.subject;
    }

    @JsonIgnore
    public void unloadSubject() {
        this.subject = null;
    }

    @JsonIgnore
    public Feature getFeature(String name) throws FeatureStoreException {
        return this.features.stream().filter(f -> f.getName().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new FeatureStoreException("Feature with name `" + name + "` not found in feature group `" + this.name + "`."));
    }

    @JsonIgnore
    public List<String> getPrimaryKeys() {
        if (this.primaryKeys == null) {
            this.primaryKeys = this.features.stream().filter(Feature::getPrimary).map(Feature::getName).collect(Collectors.toList());
        }
        return this.primaryKeys;
    }

    @JsonIgnore
    public List<String> getComplexFeatures() {
        return this.utils.getComplexFeatures(this.features);
    }

    @JsonIgnore
    public String getAvroSchema() throws FeatureStoreException, IOException {
        return this.getSubject().getSchema();
    }

    @JsonIgnore
    public String getFeatureAvroSchema(String featureName) throws FeatureStoreException, IOException {
        return this.utils.getFeatureAvroSchema(featureName, this.utils.getDeserializedAvroSchema(this.getAvroSchema()));
    }

    @JsonIgnore
    public String getEncodedAvroSchema() throws FeatureStoreException, IOException {
        return this.utils.getEncodedAvroSchema(this.getDeserializedAvroSchema(), this.utils.getComplexFeatures(this.features));
    }

    @JsonIgnore
    public Schema getDeserializedEncodedAvroSchema() throws FeatureStoreException, IOException {
        return this.utils.getDeserializedEncodedAvroSchema(this.getDeserializedAvroSchema(), this.utils.getComplexFeatures(this.features));
    }

    @JsonIgnore
    public Schema getDeserializedAvroSchema() throws FeatureStoreException, IOException {
        return this.utils.getDeserializedAvroSchema(this.getAvroSchema());
    }

    @JsonIgnore
    public OnlineIngestion getLatestOnlineIngestion() throws FeatureStoreException, IOException {
        return this.onlineIngestionApi.getOnlineIngestion(this, "filter_by=LATEST").get(0);
    }

    @JsonIgnore
    public OnlineIngestion getOnlineIngestion(Integer id) throws FeatureStoreException, IOException {
        return this.onlineIngestionApi.getOnlineIngestion(this, "filter_by=ID:" + id).get(0);
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public FeatureStoreBase getFeatureStore() {
        return this.featureStore;
    }

    @JsonIgnore
    @Generated
    public void setFeatureStore(FeatureStoreBase featureStore) {
        this.featureStore = featureStore;
    }

    @Generated
    public Integer getFeaturestoreId() {
        return this.featurestoreId;
    }

    @Generated
    public void setFeaturestoreId(Integer featurestoreId) {
        this.featurestoreId = featurestoreId;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Generated
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public List<Feature> getFeatures() {
        return this.features;
    }

    @Generated
    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    @Generated
    public String getEventTime() {
        return this.eventTime;
    }

    @Generated
    public void setEventTime(String eventTime) {
        this.eventTime = eventTime;
    }

    @Generated
    public Date getCreated() {
        return this.created;
    }

    @Generated
    public User getCreator() {
        return this.creator;
    }

    @Generated
    public StatisticsConfig getStatisticsConfig() {
        return this.statisticsConfig;
    }

    @Generated
    public void setStatisticsConfig(StatisticsConfig statisticsConfig) {
        this.statisticsConfig = statisticsConfig;
    }

    @Generated
    public List<String> getExpectationsNames() {
        return this.expectationsNames;
    }

    @Generated
    public void setExpectationsNames(List<String> expectationsNames) {
        this.expectationsNames = expectationsNames;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public TimeTravelFormat getTimeTravelFormat() {
        return this.timeTravelFormat;
    }

    @Generated
    public void setTimeTravelFormat(TimeTravelFormat timeTravelFormat) {
        this.timeTravelFormat = timeTravelFormat;
    }

    @Generated
    public Boolean getOnlineEnabled() {
        return this.onlineEnabled;
    }

    @Generated
    public void setOnlineEnabled(Boolean onlineEnabled) {
        this.onlineEnabled = onlineEnabled;
    }

    @Generated
    public String getOnlineTopicName() {
        return this.onlineTopicName;
    }

    @Generated
    public void setOnlineTopicName(String onlineTopicName) {
        this.onlineTopicName = onlineTopicName;
    }

    @Generated
    public String getTopicName() {
        return this.topicName;
    }

    @Generated
    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    @Generated
    public String getNotificationTopicName() {
        return this.notificationTopicName;
    }

    @Generated
    public void setNotificationTopicName(String notificationTopicName) {
        this.notificationTopicName = notificationTopicName;
    }

    @Generated
    public List<String> getStatisticColumns() {
        return this.statisticColumns;
    }

    @Generated
    public void setStatisticColumns(List<String> statisticColumns) {
        this.statisticColumns = statisticColumns;
    }

    @Generated
    public void setDeltaStreamerJobConf(DeltaStreamerJobConf deltaStreamerJobConf) {
        this.deltaStreamerJobConf = deltaStreamerJobConf;
    }

    @Generated
    public DeltaStreamerJobConf getDeltaStreamerJobConf() {
        return this.deltaStreamerJobConf;
    }

    @Generated
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    @Generated
    public OnlineConfig getOnlineConfig() {
        return this.onlineConfig;
    }

    @Generated
    public void setOnlineConfig(OnlineConfig onlineConfig) {
        this.onlineConfig = onlineConfig;
    }

    @Generated
    public StorageConnector getStorageConnector() {
        return this.storageConnector;
    }

    @Generated
    public void setStorageConnector(StorageConnector storageConnector) {
        this.storageConnector = storageConnector;
    }

    @Generated
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Generated
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

