/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.DataSource;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.JobConfiguration;
import com.logicalclocks.hsfs.OnlineConfig;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.constructor.Query;
import com.logicalclocks.hsfs.engine.FeatureGroupEngine;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StreamFeatureGroup<T>
extends FeatureGroupBase<List<T>> {
    protected FeatureGroupEngine featureGroupEngine = new FeatureGroupEngine();

    public StreamFeatureGroup(FeatureStoreBase featureStore, @NonNull String name, Integer version, String description, TimeTravelFormat timeTravelFormat, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, boolean onlineEnabled, List<Feature> features, StatisticsConfig statisticsConfig, String onlineTopicName, String eventTime, StorageConnector storageConnector, String path, OnlineConfig onlineConfig) {
        this();
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.featureStore = featureStore;
        this.name = name;
        this.version = version;
        this.description = description;
        this.primaryKeys = primaryKeys != null ? primaryKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.partitionKeys = partitionKeys != null ? partitionKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.hudiPrecombineKey = hudiPrecombineKey != null ? hudiPrecombineKey.toLowerCase() : null;
        this.onlineEnabled = onlineEnabled;
        this.features = features;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
        this.onlineTopicName = onlineTopicName;
        this.eventTime = eventTime;
        this.timeTravelFormat = timeTravelFormat;
        this.storageConnector = storageConnector;
        this.onlineConfig = onlineConfig;
        this.dataSource.setPath(path);
    }

    public StreamFeatureGroup() {
        this.type = "streamFeatureGroupDTO";
        this.dataSource = new DataSource();
    }

    public StreamFeatureGroup(Integer id, String description, List<Feature> features) {
        this();
        this.id = id;
        this.description = description;
        this.features = features;
    }

    public StreamFeatureGroup(FeatureStoreBase featureStore, int id) {
        this();
        this.featureStore = featureStore;
        this.id = id;
    }

    public void save() throws FeatureStoreException, IOException {
        this.save(null, null);
    }

    public void save(Map<String, String> writeOptions, JobConfiguration materializationJobConfiguration) throws FeatureStoreException, IOException {
        this.featureGroupEngine.save(this, this.partitionKeys, this.hudiPrecombineKey, writeOptions, materializationJobConfiguration);
    }

    public List<T> insertStream(List<T> featureData) throws Exception {
        return this.insertStream(featureData, (Map<String, String>)new HashMap<String, String>());
    }

    public List<T> insertStream(List<T> featureData, Map<String, String> writeOptions) throws Exception {
        return this.featureGroupEngine.insertStream(this, featureData, writeOptions);
    }

    public Query selectFeatures(List<Feature> features) {
        return new Query(this, features);
    }

    public Query select(List<String> features) {
        List<Feature> featureObjList = features.stream().map(Feature::new).collect(Collectors.toList());
        return this.selectFeatures(featureObjList);
    }

    public Query selectAll() {
        return new Query(this, this.getFeatures());
    }

    public Query selectExceptFeatures(List<Feature> features) {
        List<String> exceptFeatures = features.stream().map(Feature::getName).collect(Collectors.toList());
        return this.selectExcept(exceptFeatures);
    }

    public Query selectExcept(List<String> features) {
        return new Query(this, this.getFeatures().stream().filter(f -> !features.contains(f.getName())).collect(Collectors.toList()));
    }

    @Generated
    public static <T> StreamFeatureGroupBuilder<T> builder() {
        return new StreamFeatureGroupBuilder();
    }

    @Generated
    public StreamFeatureGroup(FeatureGroupEngine featureGroupEngine) {
        this.featureGroupEngine = featureGroupEngine;
    }

    @Generated
    public static class StreamFeatureGroupBuilder<T> {
        @Generated
        private FeatureStoreBase featureStore;
        @Generated
        private String name;
        @Generated
        private Integer version;
        @Generated
        private String description;
        @Generated
        private TimeTravelFormat timeTravelFormat;
        @Generated
        private List<String> primaryKeys;
        @Generated
        private List<String> partitionKeys;
        @Generated
        private String hudiPrecombineKey;
        @Generated
        private boolean onlineEnabled;
        @Generated
        private List<Feature> features;
        @Generated
        private StatisticsConfig statisticsConfig;
        @Generated
        private String onlineTopicName;
        @Generated
        private String eventTime;
        @Generated
        private StorageConnector storageConnector;
        @Generated
        private String path;
        @Generated
        private OnlineConfig onlineConfig;

        @Generated
        StreamFeatureGroupBuilder() {
        }

        @Generated
        public StreamFeatureGroupBuilder<T> featureStore(FeatureStoreBase featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder<T> name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder<T> version(Integer version) {
            this.version = version;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder<T> description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder<T> timeTravelFormat(TimeTravelFormat timeTravelFormat) {
            this.timeTravelFormat = timeTravelFormat;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder<T> primaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder<T> partitionKeys(List<String> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder<T> hudiPrecombineKey(String hudiPrecombineKey) {
            this.hudiPrecombineKey = hudiPrecombineKey;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder<T> onlineEnabled(boolean onlineEnabled) {
            this.onlineEnabled = onlineEnabled;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder<T> features(List<Feature> features) {
            this.features = features;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder<T> statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder<T> onlineTopicName(String onlineTopicName) {
            this.onlineTopicName = onlineTopicName;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder<T> eventTime(String eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder<T> storageConnector(StorageConnector storageConnector) {
            this.storageConnector = storageConnector;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder<T> path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public StreamFeatureGroupBuilder<T> onlineConfig(OnlineConfig onlineConfig) {
            this.onlineConfig = onlineConfig;
            return this;
        }

        @Generated
        public StreamFeatureGroup<T> build() {
            return new StreamFeatureGroup(this.featureStore, this.name, this.version, this.description, this.timeTravelFormat, this.primaryKeys, this.partitionKeys, this.hudiPrecombineKey, this.onlineEnabled, this.features, this.statisticsConfig, this.onlineTopicName, this.eventTime, this.storageConnector, this.path, this.onlineConfig);
        }

        @Generated
        public String toString() {
            return "StreamFeatureGroup.StreamFeatureGroupBuilder(featureStore=" + this.featureStore + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", timeTravelFormat=" + (Object)((Object)this.timeTravelFormat) + ", primaryKeys=" + this.primaryKeys + ", partitionKeys=" + this.partitionKeys + ", hudiPrecombineKey=" + this.hudiPrecombineKey + ", onlineEnabled=" + this.onlineEnabled + ", features=" + this.features + ", statisticsConfig=" + this.statisticsConfig + ", onlineTopicName=" + this.onlineTopicName + ", eventTime=" + this.eventTime + ", storageConnector=" + this.storageConnector + ", path=" + this.path + ", onlineConfig=" + this.onlineConfig + ")";
        }
    }
}

