/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.OnlineConfig;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.constructor.QueryBase;
import com.logicalclocks.hsfs.metadata.FeatureGroupApi;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import com.logicalclocks.hsfs.metadata.TrainingDatasetApi;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FeatureStoreBase<T2 extends QueryBase> {
    @JsonProperty(value="featurestoreId")
    private Integer id;
    @JsonProperty(value="featurestoreName")
    private String name;
    private Integer projectId;
    protected FeatureGroupApi featureGroupApi;
    protected TrainingDatasetApi trainingDatasetApi;
    protected StorageConnectorApi storageConnectorApi;
    protected static final Logger LOGGER = LoggerFactory.getLogger(FeatureStoreBase.class);
    protected static final Integer DEFAULT_VERSION = 1;

    public abstract FeatureGroupBase createStreamFeatureGroup(@NonNull String var1, Integer var2, String var3, Boolean var4, TimeTravelFormat var5, List<String> var6, List<String> var7, String var8, String var9, List<Feature> var10, StatisticsConfig var11, StorageConnector var12, String var13);

    public abstract FeatureGroupBase getOrCreateStreamFeatureGroup(@NonNull String var1, Integer var2, String var3, Boolean var4, TimeTravelFormat var5, List<String> var6, List<String> var7, String var8, String var9, List<Feature> var10, StatisticsConfig var11, StorageConnector var12, String var13, OnlineConfig var14) throws IOException, FeatureStoreException;

    public abstract Object getStreamFeatureGroup(@NonNull String var1, @NonNull Integer var2) throws FeatureStoreException, IOException;

    public abstract Object getStreamFeatureGroup(String var1) throws FeatureStoreException, IOException;

    public abstract Object getFeatureView(String var1) throws FeatureStoreException, IOException;

    public abstract Object getFeatureView(@NonNull String var1, @NonNull Integer var2) throws FeatureStoreException, IOException;

    public StorageConnector getStorageConnector(String name) throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getByName(this, name, StorageConnector.class);
    }

    public StorageConnector.HopsFsConnector getHopsFsConnector(String name) throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getByName(this, name, StorageConnector.HopsFsConnector.class);
    }

    public StorageConnector.JdbcConnector getJdbcConnector(String name) throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getByName(this, name, StorageConnector.JdbcConnector.class);
    }

    public abstract Object getRdsConnector(String var1) throws FeatureStoreException, IOException;

    public StorageConnector.JdbcConnector getOnlineStorageConnector() throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getOnlineStorageConnector(this, StorageConnector.JdbcConnector.class);
    }

    public StorageConnector.S3Connector getS3Connector(String name) throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getByName(this, name, StorageConnector.S3Connector.class);
    }

    public StorageConnector.RedshiftConnector getRedshiftConnector(String name) throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getByName(this, name, StorageConnector.RedshiftConnector.class);
    }

    public StorageConnector.SnowflakeConnector getSnowflakeConnector(String name) throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getByName(this, name, StorageConnector.SnowflakeConnector.class);
    }

    public StorageConnector.AdlsConnector getAdlsConnector(String name) throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getByName(this, name, StorageConnector.AdlsConnector.class);
    }

    public StorageConnector.KafkaConnector getKafkaConnector(String name) throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getByName(this, name, StorageConnector.KafkaConnector.class);
    }

    public StorageConnector.BigqueryConnector getBigqueryConnector(String name) throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getByName(this, name, StorageConnector.BigqueryConnector.class);
    }

    public StorageConnector.GcsConnector getGcsConnector(String name) throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getByName(this, name, StorageConnector.GcsConnector.class);
    }

    public String toString() {
        return "FeatureStore{id=" + this.id + ", name='" + this.name + '\'' + ", projectId=" + this.projectId + ", featureGroupApi=" + this.featureGroupApi + '}';
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="featurestoreId")
    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="featurestoreName")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public Integer getProjectId() {
        return this.projectId;
    }

    @Generated
    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }
}

