/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Project;
import com.logicalclocks.hsfs.SecretStore;
import com.logicalclocks.hsfs.metadata.Credentials;
import com.logicalclocks.hsfs.metadata.HopsworksExternalClient;
import com.logicalclocks.hsfs.metadata.HopsworksHttpClient;
import com.logicalclocks.hsfs.metadata.HopsworksInternalClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Base64;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;

public class HopsworksClient {
    public static final String API_PATH = "/hopsworks-api/api";
    public static final String PROJECT_PATH = "/hopsworks-api/api/project{/projectId}";
    protected static HopsworksClient hopsworksClientInstance = null;
    protected static final Logger LOGGER = LoggerFactory.getLogger(HopsworksClient.class);
    protected Project project;
    protected String host;
    protected HopsworksHttpClient hopsworksHttpClient;
    protected ObjectMapper objectMapper = new ObjectMapper();

    public static HopsworksClient getInstance() throws FeatureStoreException {
        if (hopsworksClientInstance == null) {
            throw new FeatureStoreException("Client not connected. Please establish a Hopsworks connection first");
        }
        return hopsworksClientInstance;
    }

    public static void setInstance(HopsworksClient instance) {
        hopsworksClientInstance = instance;
    }

    public static synchronized HopsworksClient setupHopsworksClient(String host, int port, Region region, SecretStore secretStore, boolean hostnameVerification, String trustStorePath, String apiKeyFilePath, String apiKeyValue) throws FeatureStoreException {
        if (hopsworksClientInstance != null) {
            return hopsworksClientInstance;
        }
        HopsworksHttpClient hopsworksHttpClient = null;
        try {
            hopsworksHttpClient = System.getProperties().containsKey("hopsworks.restendpoint") ? new HopsworksInternalClient() : new HopsworksExternalClient(host, port, region, secretStore, hostnameVerification, trustStorePath, apiKeyFilePath, apiKeyValue);
        }
        catch (Exception e) {
            throw new FeatureStoreException("Could not setup Hopsworks client", e);
        }
        hopsworksClientInstance = new HopsworksClient(hopsworksHttpClient, host);
        return hopsworksClientInstance;
    }

    public Credentials getCredentials() throws FeatureStoreException, IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/credentials";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).expand();
        LOGGER.info("Sending metadata request: " + uri);
        Credentials credentials = hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), Credentials.class);
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(new ByteArrayInputStream(Base64.getDecoder().decode(credentials.getkStore())), credentials.getPassword().toCharArray());
        File keyStore = this.createTempFile("keyStore.jks");
        ks.store(new FileOutputStream(keyStore), credentials.getPassword().toCharArray());
        KeyStore ts = KeyStore.getInstance("JKS");
        ts.load(new ByteArrayInputStream(Base64.getDecoder().decode(credentials.gettStore())), credentials.getPassword().toCharArray());
        File trustStore = this.createTempFile("trustStore.jks");
        ts.store(new FileOutputStream(trustStore), credentials.getPassword().toCharArray());
        credentials.setkStore(keyStore.getAbsolutePath());
        credentials.settStore(trustStore.getAbsolutePath());
        return credentials;
    }

    private File createTempFile(String fileName) throws FeatureStoreException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        File file = Paths.get(System.getProperty("java.io.tmpdir"), hopsworksClient.getProject().getProjectName(), fileName).toFile();
        File parentDir = file.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        return file;
    }

    @VisibleForTesting
    public HopsworksClient(HopsworksHttpClient hopsworksHttpClient, String host) {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.hopsworksHttpClient = hopsworksHttpClient;
        this.host = host;
    }

    public <T> T handleRequest(HttpRequest request, ResponseHandler<T> responseHandler) throws IOException, FeatureStoreException {
        return this.hopsworksHttpClient.handleRequest(request, responseHandler);
    }

    public <T> T handleRequest(HttpRequest request, Class<T> cls) throws IOException, FeatureStoreException {
        return this.hopsworksHttpClient.handleRequest(request, new BaseHandler<T>(cls, this.objectMapper));
    }

    public <T> T handleRequest(HttpRequest request) throws IOException, FeatureStoreException {
        return this.hopsworksHttpClient.handleRequest(request, null);
    }

    public StringEntity buildStringEntity(Object object) throws IOException {
        String jsonStrRepresentation = this.objectMapper.writeValueAsString(object);
        LOGGER.debug("Request content: " + jsonStrRepresentation);
        return new StringEntity(jsonStrRepresentation, ContentType.APPLICATION_JSON);
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public HopsworksHttpClient getHopsworksHttpClient() {
        return this.hopsworksHttpClient;
    }

    @Generated
    public void setHopsworksHttpClient(HopsworksHttpClient hopsworksHttpClient) {
        this.hopsworksHttpClient = hopsworksHttpClient;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected static class BaseHandler<T>
    implements ResponseHandler<T> {
        private Class<T> cls;
        private ObjectMapper objectMapper;

        public BaseHandler(Class<T> cls, ObjectMapper objectMapper) {
            this.cls = cls;
            this.objectMapper = objectMapper;
        }

        public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            String responseJson = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
            if (response.getStatusLine().getStatusCode() / 100 == 2) {
                return (T)this.objectMapper.readValue(responseJson, this.cls);
            }
            HopsworksErrorClass error = (HopsworksErrorClass)this.objectMapper.readValue(responseJson, HopsworksErrorClass.class);
            LOGGER.info("Request error: " + response.getStatusLine().getStatusCode() + " " + error);
            throw new ClientProtocolException("Request error: " + response.getStatusLine().getStatusCode() + " " + error);
        }
    }

    protected static class HopsworksErrorClass {
        private Integer errorCode;
        private String usrMsg;
        private String devMsg;

        public String toString() {
            return "errorCode=" + this.errorCode + ", usrMsg='" + this.usrMsg + '\'' + ", devMsg='" + this.devMsg + '\'';
        }

        @Generated
        public HopsworksErrorClass(Integer errorCode, String usrMsg, String devMsg) {
            this.errorCode = errorCode;
            this.usrMsg = usrMsg;
            this.devMsg = devMsg;
        }

        @Generated
        public HopsworksErrorClass() {
        }

        @Generated
        public Integer getErrorCode() {
            return this.errorCode;
        }

        @Generated
        public void setErrorCode(Integer errorCode) {
            this.errorCode = errorCode;
        }

        @Generated
        public String getUsrMsg() {
            return this.usrMsg;
        }

        @Generated
        public void setUsrMsg(String usrMsg) {
            this.usrMsg = usrMsg;
        }

        @Generated
        public String getDevMsg() {
            return this.devMsg;
        }

        @Generated
        public void setDevMsg(String devMsg) {
            this.devMsg = devMsg;
        }
    }
}

