/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.logicalclocks.hsfs.DataFormat;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Split;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.StorageConnectorType;
import com.logicalclocks.hsfs.TrainingDatasetFeature;
import com.logicalclocks.hsfs.TrainingDatasetType;
import com.logicalclocks.hsfs.constructor.Filter;
import com.logicalclocks.hsfs.constructor.FilterLogic;
import com.logicalclocks.hsfs.engine.FeatureGroupUtils;
import com.logicalclocks.hsfs.metadata.Statistics;
import com.logicalclocks.hsfs.metadata.StatisticsApi;
import com.logicalclocks.hsfs.metadata.TagsApi;
import com.logicalclocks.hsfs.metadata.TrainingDatasetApi;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainingDatasetBase {
    protected Integer id;
    protected String name;
    protected Integer version;
    protected String description;
    protected Boolean coalesce;
    protected TrainingDatasetType trainingDatasetType = TrainingDatasetType.HOPSFS_TRAINING_DATASET;
    protected List<TrainingDatasetFeature> features;
    @JsonIgnore
    protected FeatureStoreBase featureStore;
    protected String location;
    protected Long seed;
    protected List<Split> splits;
    protected String trainSplit;
    @JsonIgnore
    protected List<String> label;
    protected Date eventStartTime;
    protected Date eventEndTime;
    protected FilterLogic extraFilter;
    protected DataFormat dataFormat;
    protected StorageConnector storageConnector;
    protected StatisticsConfig statisticsConfig = new StatisticsConfig();
    protected String type = "trainingDatasetDTO";
    private TrainingDatasetApi trainingDatasetApi = new TrainingDatasetApi();
    private TagsApi tagsApi = new TagsApi(EntityEndpointType.TRAINING_DATASET);
    private StatisticsApi statisticsApi = new StatisticsApi(EntityEndpointType.TRAINING_DATASET);
    protected static final Logger LOGGER = LoggerFactory.getLogger(TrainingDatasetBase.class);

    public TrainingDatasetBase(Integer version, String description, DataFormat dataFormat, Boolean coalesce, StorageConnector storageConnector, String location, List<Split> splits, String trainSplit, Long seed, FeatureStoreBase featureStore, StatisticsConfig statisticsConfig, List<String> label, String eventStartTime, String eventEndTime, TrainingDatasetType trainingDatasetType, Float validationSize, Float testSize, String trainStart, String trainEnd, String validationStart, String validationEnd, String testStart, String testEnd, Integer timeSplitSize, FilterLogic extraFilterLogic, Filter extraFilter) throws FeatureStoreException, ParseException {
        this.version = version;
        this.description = description;
        this.dataFormat = dataFormat != null ? dataFormat : DataFormat.PARQUET;
        this.coalesce = coalesce != null ? coalesce : false;
        this.location = location;
        this.storageConnector = storageConnector;
        this.trainSplit = trainSplit;
        this.splits = splits == null ? Lists.newArrayList() : splits;
        this.seed = seed;
        this.featureStore = featureStore;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
        this.label = label != null ? label.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.eventStartTime = eventStartTime != null ? FeatureGroupUtils.getDateFromDateString(eventStartTime) : null;
        this.eventEndTime = eventEndTime != null ? FeatureGroupUtils.getDateFromDateString(eventEndTime) : null;
        this.trainingDatasetType = trainingDatasetType != null ? trainingDatasetType : this.getTrainingDatasetType(storageConnector);
        this.setValTestSplit(validationSize, testSize);
        this.setTimeSeriesSplits(timeSplitSize, trainStart, trainEnd, validationStart, validationEnd, testStart, testEnd);
        if (extraFilter != null) {
            this.extraFilter = new FilterLogic(extraFilter);
        }
        if (extraFilterLogic != null) {
            this.extraFilter = extraFilterLogic;
        }
        if (this.splits != null && !this.splits.isEmpty() && Strings.isNullOrEmpty((String)this.trainSplit)) {
            LOGGER.info("Training dataset splits were defined but no `trainSplit` (the name of the split that is going to be used for training) was provided. Setting this property to `train`.");
            this.trainSplit = "train";
        }
    }

    public void setTimeSeriesSplits(Integer timeSplitSize, String trainStart, String trainEnd, String valStart, String valEnd, String testStart, String testEnd) throws FeatureStoreException, ParseException {
        ArrayList splits = Lists.newArrayList();
        this.appendTimeSeriesSplit(splits, "train", trainStart, trainEnd != null ? trainEnd : (valStart != null ? valStart : testStart));
        if (timeSplitSize != null && timeSplitSize == 3) {
            this.appendTimeSeriesSplit(splits, "validataion", valStart != null ? valStart : trainEnd, valEnd != null ? valEnd : testStart);
        }
        this.appendTimeSeriesSplit(splits, "test", testStart != null ? testStart : (valEnd != null ? valEnd : trainEnd), testEnd);
        if (!splits.isEmpty()) {
            this.splits = splits;
        }
    }

    private void appendTimeSeriesSplit(List<Split> splits, String splitName, String startTime, String endTime) throws FeatureStoreException, ParseException {
        if (startTime != null || endTime != null) {
            splits.add(new Split(splitName, FeatureGroupUtils.getDateFromDateString(startTime), FeatureGroupUtils.getDateFromDateString(endTime)));
        }
    }

    public void setValTestSplit(Float valSize, Float testSize) {
        if (valSize != null && testSize != null) {
            this.splits = Lists.newArrayList();
            this.splits.add(new Split("train", Float.valueOf(1.0f - valSize.floatValue() - testSize.floatValue())));
            this.splits.add(new Split("validataion", valSize));
            this.splits.add(new Split("test", testSize));
        } else if (testSize != null) {
            this.splits = Lists.newArrayList();
            this.splits.add(new Split("train", Float.valueOf(1.0f - testSize.floatValue())));
            this.splits.add(new Split("test", testSize));
        }
    }

    @JsonIgnore
    public List<String> getLabel() {
        return this.features.stream().filter(TrainingDatasetFeature::getLabel).map(TrainingDatasetFeature::getName).collect(Collectors.toList());
    }

    @JsonIgnore
    public void setLabel(List<String> label) {
        this.label = label.stream().map(String::toLowerCase).collect(Collectors.toList());
    }

    public TrainingDatasetType getTrainingDatasetType(StorageConnector storageConnector) {
        if (storageConnector == null) {
            return TrainingDatasetType.HOPSFS_TRAINING_DATASET;
        }
        if (storageConnector.getStorageConnectorType() == StorageConnectorType.HOPSFS) {
            return TrainingDatasetType.HOPSFS_TRAINING_DATASET;
        }
        return TrainingDatasetType.EXTERNAL_TRAINING_DATASET;
    }

    @JsonIgnore
    public Statistics getStatistics() throws FeatureStoreException, IOException {
        return this.statisticsApi.getLast(this);
    }

    @JsonIgnore
    public Statistics getStatistics(String commitTime) throws FeatureStoreException, IOException {
        return this.statisticsApi.get(this, commitTime);
    }

    public void addTag(String name, Object value) throws FeatureStoreException, IOException {
        this.tagsApi.add(this, name, value);
    }

    @JsonIgnore
    public Map<String, Object> getTags() throws FeatureStoreException, IOException {
        return this.tagsApi.get(this);
    }

    @JsonIgnore
    public Object getTag(String name) throws FeatureStoreException, IOException {
        return this.tagsApi.get(this, name);
    }

    public void deleteTag(String name) throws FeatureStoreException, IOException {
        this.tagsApi.deleteTag(this, name);
    }

    public void delete() throws FeatureStoreException, IOException {
        this.trainingDatasetApi.delete(this);
    }

    @Generated
    public static TrainingDatasetBaseBuilder builder() {
        return new TrainingDatasetBaseBuilder();
    }

    @Generated
    public TrainingDatasetBase() {
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Generated
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public Boolean getCoalesce() {
        return this.coalesce;
    }

    @Generated
    public void setCoalesce(Boolean coalesce) {
        this.coalesce = coalesce;
    }

    @Generated
    public TrainingDatasetType getTrainingDatasetType() {
        return this.trainingDatasetType;
    }

    @Generated
    public void setTrainingDatasetType(TrainingDatasetType trainingDatasetType) {
        this.trainingDatasetType = trainingDatasetType;
    }

    @Generated
    public List<TrainingDatasetFeature> getFeatures() {
        return this.features;
    }

    @Generated
    public void setFeatures(List<TrainingDatasetFeature> features) {
        this.features = features;
    }

    @Generated
    public FeatureStoreBase getFeatureStore() {
        return this.featureStore;
    }

    @JsonIgnore
    @Generated
    public void setFeatureStore(FeatureStoreBase featureStore) {
        this.featureStore = featureStore;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public Long getSeed() {
        return this.seed;
    }

    @Generated
    public void setSeed(Long seed) {
        this.seed = seed;
    }

    @Generated
    public List<Split> getSplits() {
        return this.splits;
    }

    @Generated
    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    @Generated
    public String getTrainSplit() {
        return this.trainSplit;
    }

    @Generated
    public void setTrainSplit(String trainSplit) {
        this.trainSplit = trainSplit;
    }

    @Generated
    public Date getEventStartTime() {
        return this.eventStartTime;
    }

    @Generated
    public void setEventStartTime(Date eventStartTime) {
        this.eventStartTime = eventStartTime;
    }

    @Generated
    public Date getEventEndTime() {
        return this.eventEndTime;
    }

    @Generated
    public void setEventEndTime(Date eventEndTime) {
        this.eventEndTime = eventEndTime;
    }

    @Generated
    public FilterLogic getExtraFilter() {
        return this.extraFilter;
    }

    @Generated
    public void setExtraFilter(FilterLogic extraFilter) {
        this.extraFilter = extraFilter;
    }

    @Generated
    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    @Generated
    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Generated
    public StorageConnector getStorageConnector() {
        return this.storageConnector;
    }

    @Generated
    public void setStorageConnector(StorageConnector storageConnector) {
        this.storageConnector = storageConnector;
    }

    @Generated
    public StatisticsConfig getStatisticsConfig() {
        return this.statisticsConfig;
    }

    @Generated
    public void setStatisticsConfig(StatisticsConfig statisticsConfig) {
        this.statisticsConfig = statisticsConfig;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public static class TrainingDatasetBaseBuilder {
        @Generated
        private Integer version;
        @Generated
        private String description;
        @Generated
        private DataFormat dataFormat;
        @Generated
        private Boolean coalesce;
        @Generated
        private StorageConnector storageConnector;
        @Generated
        private String location;
        @Generated
        private List<Split> splits;
        @Generated
        private String trainSplit;
        @Generated
        private Long seed;
        @Generated
        private FeatureStoreBase featureStore;
        @Generated
        private StatisticsConfig statisticsConfig;
        @Generated
        private List<String> label;
        @Generated
        private String eventStartTime;
        @Generated
        private String eventEndTime;
        @Generated
        private TrainingDatasetType trainingDatasetType;
        @Generated
        private Float validationSize;
        @Generated
        private Float testSize;
        @Generated
        private String trainStart;
        @Generated
        private String trainEnd;
        @Generated
        private String validationStart;
        @Generated
        private String validationEnd;
        @Generated
        private String testStart;
        @Generated
        private String testEnd;
        @Generated
        private Integer timeSplitSize;
        @Generated
        private FilterLogic extraFilterLogic;
        @Generated
        private Filter extraFilter;

        @Generated
        TrainingDatasetBaseBuilder() {
        }

        @Generated
        public TrainingDatasetBaseBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder dataFormat(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder coalesce(Boolean coalesce) {
            this.coalesce = coalesce;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder storageConnector(StorageConnector storageConnector) {
            this.storageConnector = storageConnector;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder location(String location) {
            this.location = location;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder splits(List<Split> splits) {
            this.splits = splits;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder trainSplit(String trainSplit) {
            this.trainSplit = trainSplit;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder seed(Long seed) {
            this.seed = seed;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder featureStore(FeatureStoreBase featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder label(List<String> label) {
            this.label = label;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder eventStartTime(String eventStartTime) {
            this.eventStartTime = eventStartTime;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder eventEndTime(String eventEndTime) {
            this.eventEndTime = eventEndTime;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder trainingDatasetType(TrainingDatasetType trainingDatasetType) {
            this.trainingDatasetType = trainingDatasetType;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder validationSize(Float validationSize) {
            this.validationSize = validationSize;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder testSize(Float testSize) {
            this.testSize = testSize;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder trainStart(String trainStart) {
            this.trainStart = trainStart;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder trainEnd(String trainEnd) {
            this.trainEnd = trainEnd;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder validationStart(String validationStart) {
            this.validationStart = validationStart;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder validationEnd(String validationEnd) {
            this.validationEnd = validationEnd;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder testStart(String testStart) {
            this.testStart = testStart;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder testEnd(String testEnd) {
            this.testEnd = testEnd;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder timeSplitSize(Integer timeSplitSize) {
            this.timeSplitSize = timeSplitSize;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder extraFilterLogic(FilterLogic extraFilterLogic) {
            this.extraFilterLogic = extraFilterLogic;
            return this;
        }

        @Generated
        public TrainingDatasetBaseBuilder extraFilter(Filter extraFilter) {
            this.extraFilter = extraFilter;
            return this;
        }

        @Generated
        public TrainingDatasetBase build() throws FeatureStoreException, ParseException {
            return new TrainingDatasetBase(this.version, this.description, this.dataFormat, this.coalesce, this.storageConnector, this.location, this.splits, this.trainSplit, this.seed, this.featureStore, this.statisticsConfig, this.label, this.eventStartTime, this.eventEndTime, this.trainingDatasetType, this.validationSize, this.testSize, this.trainStart, this.trainEnd, this.validationStart, this.validationEnd, this.testStart, this.testEnd, this.timeSplitSize, this.extraFilterLogic, this.extraFilter);
        }

        @Generated
        public String toString() {
            return "TrainingDatasetBase.TrainingDatasetBaseBuilder(version=" + this.version + ", description=" + this.description + ", dataFormat=" + (Object)((Object)this.dataFormat) + ", coalesce=" + this.coalesce + ", storageConnector=" + this.storageConnector + ", location=" + this.location + ", splits=" + this.splits + ", trainSplit=" + this.trainSplit + ", seed=" + this.seed + ", featureStore=" + this.featureStore + ", statisticsConfig=" + this.statisticsConfig + ", label=" + this.label + ", eventStartTime=" + this.eventStartTime + ", eventEndTime=" + this.eventEndTime + ", trainingDatasetType=" + (Object)((Object)this.trainingDatasetType) + ", validationSize=" + this.validationSize + ", testSize=" + this.testSize + ", trainStart=" + this.trainStart + ", trainEnd=" + this.trainEnd + ", validationStart=" + this.validationStart + ", validationEnd=" + this.validationEnd + ", testStart=" + this.testStart + ", testEnd=" + this.testEnd + ", timeSplitSize=" + this.timeSplitSize + ", extraFilterLogic=" + this.extraFilterLogic + ", extraFilter=" + this.extraFilter + ")";
        }
    }
}

