/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import com.logicalclocks.hsfs.DataFormat;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TrainingDatasetBase;
import com.logicalclocks.hsfs.TrainingDatasetFeature;
import com.logicalclocks.hsfs.constructor.Filter;
import com.logicalclocks.hsfs.constructor.FilterLogic;
import com.logicalclocks.hsfs.constructor.QueryBase;
import com.logicalclocks.hsfs.engine.VectorServer;
import com.logicalclocks.hsfs.metadata.FeatureViewApi;
import com.logicalclocks.hsfs.metadata.TagsApi;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FeatureViewBase<T extends FeatureViewBase, T3 extends FeatureStoreBase<T4>, T4 extends QueryBase, T5> {
    protected T3 featureStore;
    protected Integer id;
    protected String name;
    protected Integer version;
    protected String description;
    protected List<TrainingDatasetFeature> features;
    protected T4 query;
    @JsonIgnore
    protected List<String> labels;
    protected String type = "featureViewDTO";
    protected static final Logger LOGGER = LoggerFactory.getLogger(FeatureViewBase.class);
    protected FeatureViewApi featureViewApi = new FeatureViewApi();
    protected TagsApi tagsApi = new TagsApi(EntityEndpointType.FEATURE_VIEW);
    protected VectorServer vectorServer = new VectorServer();
    protected Integer extraFilterVersion = null;

    public Integer createTrainingData(String startTime, String endTime, String description, DataFormat dataFormat) throws IOException, FeatureStoreException, ParseException {
        TrainingDatasetBase trainingDataset = TrainingDatasetBase.builder().featureStore((FeatureStoreBase)this.featureStore).eventStartTime(startTime).eventEndTime(endTime).description(description).dataFormat(dataFormat).build();
        trainingDataset = this.featureViewApi.createTrainingData(this.name, this.version, trainingDataset, TrainingDatasetBase.class);
        this.featureViewApi.computeTrainingData((FeatureStoreBase)this.featureStore, this, trainingDataset);
        return trainingDataset.getVersion();
    }

    public Integer createTrainingData(String startTime, String endTime, String description, DataFormat dataFormat, Boolean coalesce, StorageConnector storageConnector, String location, Long seed, StatisticsConfig statisticsConfig, Map<String, String> writeOptions, FilterLogic extraFilterLogic, Filter extraFilter) throws IOException, FeatureStoreException, ParseException {
        TrainingDatasetBase trainingDataset = TrainingDatasetBase.builder().featureStore((FeatureStoreBase)this.featureStore).eventStartTime(startTime).eventEndTime(endTime).description(description).dataFormat(dataFormat).coalesce(coalesce).storageConnector(storageConnector).location(location).seed(seed).statisticsConfig(statisticsConfig).extraFilterLogic(extraFilterLogic).extraFilter(extraFilter).build();
        trainingDataset = this.featureViewApi.createTrainingData(this.name, this.version, trainingDataset, TrainingDatasetBase.class);
        this.featureViewApi.computeTrainingData((FeatureStoreBase)this.featureStore, this, trainingDataset);
        return trainingDataset.getVersion();
    }

    public Integer createTrainTestSplit(Float testSize, String trainStart, String trainEnd, String testStart, String testEnd, String description, DataFormat dataFormat) throws IOException, FeatureStoreException, ParseException {
        this.validateTrainTestSplit(testSize, trainEnd, testStart);
        TrainingDatasetBase trainingDataset = TrainingDatasetBase.builder().featureStore((FeatureStoreBase)this.featureStore).testSize(testSize).trainStart(trainStart).trainEnd(trainEnd).testStart(testStart).testEnd(testEnd).description(description).dataFormat(dataFormat).trainSplit("train").timeSplitSize(2).build();
        trainingDataset = this.featureViewApi.createTrainingData(this.name, this.version, trainingDataset, TrainingDatasetBase.class);
        this.featureViewApi.computeTrainingData((FeatureStoreBase)this.featureStore, this, trainingDataset);
        return trainingDataset.getVersion();
    }

    public Integer createTrainTestSplit(Float testSize, String trainStart, String trainEnd, String testStart, String testEnd, String description, DataFormat dataFormat, Boolean coalesce, StorageConnector storageConnector, String location, Long seed, StatisticsConfig statisticsConfig, Map<String, String> writeOptions, FilterLogic extraFilterLogic, Filter extraFilter) throws IOException, FeatureStoreException, ParseException {
        this.validateTrainTestSplit(testSize, trainEnd, testStart);
        TrainingDatasetBase trainingDataset = TrainingDatasetBase.builder().featureStore((FeatureStoreBase)this.featureStore).testSize(testSize).trainStart(trainStart).trainEnd(trainEnd).testStart(testStart).testEnd(testEnd).description(description).dataFormat(dataFormat).coalesce(coalesce).storageConnector(storageConnector).location(location).trainSplit("train").seed(seed).timeSplitSize(2).statisticsConfig(statisticsConfig).extraFilterLogic(extraFilterLogic).extraFilter(extraFilter).build();
        trainingDataset = this.featureViewApi.createTrainingData(this.name, this.version, trainingDataset, TrainingDatasetBase.class);
        this.featureViewApi.computeTrainingData((FeatureStoreBase)this.featureStore, this, trainingDataset);
        return trainingDataset.getVersion();
    }

    public Integer createTrainValidationTestSplit(Float validationSize, Float testSize, String trainStart, String trainEnd, String validationStart, String validationEnd, String testStart, String testEnd, String description, DataFormat dataFormat) throws IOException, FeatureStoreException, ParseException {
        this.validateTrainValidationTestSplit(validationSize, testSize, trainEnd, validationStart, validationEnd, testStart);
        TrainingDatasetBase trainingDataset = TrainingDatasetBase.builder().featureStore((FeatureStoreBase)this.featureStore).validationSize(validationSize).testSize(testSize).trainStart(trainStart).trainEnd(trainEnd).validationStart(validationStart).validationEnd(validationEnd).testStart(testStart).testEnd(testEnd).description(description).dataFormat(dataFormat).trainSplit("train").timeSplitSize(3).build();
        trainingDataset = this.featureViewApi.createTrainingData(this.name, this.version, trainingDataset, TrainingDatasetBase.class);
        this.featureViewApi.computeTrainingData((FeatureStoreBase)this.featureStore, this, trainingDataset);
        return trainingDataset.getVersion();
    }

    public Integer createTrainValidationTestSplit(Float validationSize, Float testSize, String trainStart, String trainEnd, String validationStart, String validationEnd, String testStart, String testEnd, String description, DataFormat dataFormat, Boolean coalesce, StorageConnector storageConnector, String location, Long seed, StatisticsConfig statisticsConfig, Map<String, String> writeOptions, FilterLogic extraFilterLogic, Filter extraFilter) throws IOException, FeatureStoreException, ParseException {
        this.validateTrainValidationTestSplit(validationSize, testSize, trainEnd, validationStart, validationEnd, testStart);
        TrainingDatasetBase trainingDataset = TrainingDatasetBase.builder().featureStore((FeatureStoreBase)this.featureStore).validationSize(validationSize).testSize(testSize).trainStart(trainStart).trainEnd(trainEnd).validationStart(validationStart).validationEnd(validationEnd).testStart(testStart).testEnd(testEnd).description(description).dataFormat(dataFormat).coalesce(coalesce).storageConnector(storageConnector).location(location).trainSplit("train").timeSplitSize(3).seed(seed).statisticsConfig(statisticsConfig).extraFilterLogic(extraFilterLogic).extraFilter(extraFilter).build();
        trainingDataset = this.featureViewApi.createTrainingData(this.name, this.version, trainingDataset, TrainingDatasetBase.class);
        this.featureViewApi.computeTrainingData((FeatureStoreBase)this.featureStore, this, trainingDataset);
        return trainingDataset.getVersion();
    }

    protected void validateTrainTestSplit(Float testSize, String trainEnd, String testStart) throws FeatureStoreException {
        if ((testSize == null || !(testSize.floatValue() > 0.0f) || !(testSize.floatValue() < 1.0f)) && Strings.isNullOrEmpty((String)trainEnd) && Strings.isNullOrEmpty((String)testStart)) {
            throw new FeatureStoreException("Invalid split input.You should specify either `testSize` or (`trainEnd` or `testStart`). `testSize` should be between 0 and 1 if specified.");
        }
    }

    protected void validateTrainValidationTestSplit(Float validationSize, Float testSize, String trainEnd, String validationStart, String validationEnd, String testStart) throws FeatureStoreException {
        if ((validationSize == null || !(validationSize.floatValue() > 0.0f) || !(validationSize.floatValue() < 1.0f) || testSize == null || !(testSize.floatValue() > 0.0f) || !(testSize.floatValue() < 1.0f) || !(validationSize.floatValue() + testSize.floatValue() < 1.0f)) && (Strings.isNullOrEmpty((String)trainEnd) && Strings.isNullOrEmpty((String)validationStart) || Strings.isNullOrEmpty((String)validationEnd) && Strings.isNullOrEmpty((String)testStart))) {
            throw new FeatureStoreException("Invalid split input. You should specify either (`validationSize` and `testSize`) or ((`trainEnd` or `validationStart`) and (`validationEnd` or `testStart`)).`validationSize`, `testSize` and sum of `validationSize` and `testSize` should be between 0 and 1 if specified.");
        }
    }

    public void initServing() throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.vectorServer.initServing(this, false);
    }

    public void initServing(Boolean batch) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.vectorServer.initServing(this, batch, false);
    }

    public void initServing(Boolean batch, Boolean external) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.vectorServer.initServing(this, batch, external);
    }

    public void initBatchScoring(Integer trainingDatasetVersion) {
        this.extraFilterVersion = trainingDatasetVersion;
    }

    @JsonIgnore
    public List<Object> getFeatureVector(Map<String, Object> entry) throws FeatureStoreException, IOException, ClassNotFoundException {
        return this.vectorServer.getFeatureVector(this, entry);
    }

    @JsonIgnore
    public List<Object> getFeatureVector(Map<String, Object> entry, boolean external) throws FeatureStoreException, IOException, ClassNotFoundException {
        return this.vectorServer.getFeatureVector(this, entry, external);
    }

    @JsonIgnore
    public List<List<Object>> getFeatureVectors(Map<String, List<Object>> entry) throws SQLException, FeatureStoreException, IOException {
        return this.vectorServer.getFeatureVectors(entry);
    }

    @JsonIgnore
    public List<List<Object>> getFeatureVectors(Map<String, List<Object>> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.vectorServer.getFeatureVectors(this, entry, external);
    }

    @JsonIgnore
    public <T> T getFeatureVectorObject(Map<String, Object> entry, boolean external, Class<T> returnType) throws FeatureStoreException, IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        return this.vectorServer.getFeatureVectorObject(this, entry, external, returnType);
    }

    @JsonIgnore
    public <T> T getFeatureVectorObject(Map<String, Object> entry, Class<T> returnType) throws FeatureStoreException, InstantiationException, IllegalAccessException {
        return this.vectorServer.getFeatureVectorObject(entry, returnType);
    }

    public void addTag(String name, Object value) throws FeatureStoreException, IOException {
        this.tagsApi.add(this, name, value);
    }

    @JsonIgnore
    public Map<String, Object> getTags() throws FeatureStoreException, IOException {
        return this.tagsApi.get(this);
    }

    @JsonIgnore
    public Object getTag(String name) throws FeatureStoreException, IOException {
        return this.tagsApi.get(this, name);
    }

    public void deleteTag(String name) throws FeatureStoreException, IOException {
        this.tagsApi.deleteTag(this, name);
    }

    public void addTrainingDatasetTag(Integer version, String name, Object value) throws FeatureStoreException, IOException {
        this.tagsApi.add(this, version, name, value);
    }

    @JsonIgnore
    public Map<String, Object> getTrainingDatasetTags(Integer version) throws FeatureStoreException, IOException {
        return this.tagsApi.get(this, version);
    }

    @JsonIgnore
    public Object getTrainingDatasetTag(Integer version, String name) throws FeatureStoreException, IOException {
        return this.tagsApi.get(this, version, name);
    }

    public void deleteTrainingDatasetTag(Integer version, String name) throws FeatureStoreException, IOException {
        this.tagsApi.deleteTag(this, version, name);
    }

    public void delete() throws FeatureStoreException, IOException {
        LOGGER.warn("JobWarning: All jobs associated to feature view `" + this.name + "`, version `" + this.version + "` will be removed.");
        this.featureViewApi.delete((FeatureStoreBase)this.featureStore, this.name, this.version);
    }

    @JsonIgnore
    public HashSet<String> getPrimaryKeys() throws SQLException, IOException, FeatureStoreException, ClassNotFoundException {
        if (this.vectorServer.getServingKeys().isEmpty()) {
            this.initServing();
        }
        return this.vectorServer.getServingKeys();
    }

    public void closeVectorServer() {
        this.vectorServer.close();
    }

    @Generated
    public T3 getFeatureStore() {
        return this.featureStore;
    }

    @Generated
    public void setFeatureStore(T3 featureStore) {
        this.featureStore = featureStore;
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Generated
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public List<TrainingDatasetFeature> getFeatures() {
        return this.features;
    }

    @Generated
    public void setFeatures(List<TrainingDatasetFeature> features) {
        this.features = features;
    }

    @Generated
    public T4 getQuery() {
        return this.query;
    }

    @Generated
    public void setQuery(T4 query) {
        this.query = query;
    }

    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @JsonIgnore
    @Generated
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }
}

