/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.logicalclocks.hsfs.metadata.InternalException;
import com.logicalclocks.hsfs.metadata.UnauthorizedException;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;

public class AuthorizationHandler<T>
implements ResponseHandler<T> {
    private ResponseHandler<T> originalResponseHandler;

    AuthorizationHandler(ResponseHandler<T> originalResponseHandler) {
        this.originalResponseHandler = originalResponseHandler;
    }

    AuthorizationHandler() {
    }

    public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        if (response.getStatusLine().getStatusCode() == 401) {
            throw new UnauthorizedException();
        }
        if (response.getStatusLine().getStatusCode() / 100 == 4) {
            throw new IOException("Error: " + response.getStatusLine().getStatusCode() + EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset()));
        }
        if (response.getStatusLine().getStatusCode() / 100 == 5) {
            throw new InternalException("Error: " + response.getStatusLine().getStatusCode() + EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset()));
        }
        if (this.originalResponseHandler != null) {
            return (T)this.originalResponseHandler.handleResponse(response);
        }
        return null;
    }
}

