/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.HopsworksConnectionBase;
import com.logicalclocks.hsfs.SecretStore;
import com.logicalclocks.hsfs.metadata.Credentials;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.HopsworksHttpClient;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import lombok.Generated;
import software.amazon.awssdk.regions.Region;

public class HopsworksConnection
extends HopsworksConnectionBase {
    public HopsworksConnection(String host, int port, String project, Region region, SecretStore secretStore, boolean hostnameVerification, String trustStorePath, String certPath, String apiKeyFilePath, String apiKeyValue) throws IOException, FeatureStoreException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.host = host;
        this.port = port;
        this.project = this.getProjectName(project);
        this.region = region;
        this.secretStore = secretStore;
        this.hostnameVerification = hostnameVerification;
        this.trustStorePath = trustStorePath;
        this.certPath = certPath;
        this.apiKeyFilePath = apiKeyFilePath;
        this.apiKeyValue = apiKeyValue;
        HopsworksClient.setupHopsworksClient(host, port, region, secretStore, hostnameVerification, trustStorePath, this.apiKeyFilePath, this.apiKeyValue);
        this.projectObj = this.getProject();
        HopsworksClient.getInstance().setProject(this.projectObj);
        if (!System.getProperties().containsKey("hopsworks.restendpoint")) {
            Credentials credentials = HopsworksClient.getInstance().getCredentials();
            HopsworksHttpClient hopsworksHttpClient = HopsworksClient.getInstance().getHopsworksHttpClient();
            hopsworksHttpClient.setTrustStorePath(credentials.gettStore());
            hopsworksHttpClient.setKeyStorePath(credentials.getkStore());
            hopsworksHttpClient.setCertKey(credentials.getPassword());
            HopsworksClient.getInstance().setHopsworksHttpClient(hopsworksHttpClient);
        }
    }

    @Override
    public FeatureStore getFeatureStore() throws IOException, FeatureStoreException {
        return this.getFeatureStore(this.rewriteFeatureStoreName(this.project));
    }

    @Override
    public FeatureStore getFeatureStore(String name) throws IOException, FeatureStoreException {
        return this.featureStoreApi.get(this.rewriteFeatureStoreName(name), FeatureStore.class);
    }

    @Generated
    public static HopsworksConnectionBuilder builder() {
        return new HopsworksConnectionBuilder();
    }

    @Generated
    public static class HopsworksConnectionBuilder {
        @Generated
        private String host;
        @Generated
        private int port;
        @Generated
        private String project;
        @Generated
        private Region region;
        @Generated
        private SecretStore secretStore;
        @Generated
        private boolean hostnameVerification;
        @Generated
        private String trustStorePath;
        @Generated
        private String certPath;
        @Generated
        private String apiKeyFilePath;
        @Generated
        private String apiKeyValue;

        @Generated
        HopsworksConnectionBuilder() {
        }

        @Generated
        public HopsworksConnectionBuilder host(String host) {
            this.host = host;
            return this;
        }

        @Generated
        public HopsworksConnectionBuilder port(int port) {
            this.port = port;
            return this;
        }

        @Generated
        public HopsworksConnectionBuilder project(String project) {
            this.project = project;
            return this;
        }

        @Generated
        public HopsworksConnectionBuilder region(Region region) {
            this.region = region;
            return this;
        }

        @Generated
        public HopsworksConnectionBuilder secretStore(SecretStore secretStore) {
            this.secretStore = secretStore;
            return this;
        }

        @Generated
        public HopsworksConnectionBuilder hostnameVerification(boolean hostnameVerification) {
            this.hostnameVerification = hostnameVerification;
            return this;
        }

        @Generated
        public HopsworksConnectionBuilder trustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        @Generated
        public HopsworksConnectionBuilder certPath(String certPath) {
            this.certPath = certPath;
            return this;
        }

        @Generated
        public HopsworksConnectionBuilder apiKeyFilePath(String apiKeyFilePath) {
            this.apiKeyFilePath = apiKeyFilePath;
            return this;
        }

        @Generated
        public HopsworksConnectionBuilder apiKeyValue(String apiKeyValue) {
            this.apiKeyValue = apiKeyValue;
            return this;
        }

        @Generated
        public HopsworksConnection build() throws IOException, FeatureStoreException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
            return new HopsworksConnection(this.host, this.port, this.project, this.region, this.secretStore, this.hostnameVerification, this.trustStorePath, this.certPath, this.apiKeyFilePath, this.apiKeyValue);
        }

        @Generated
        public String toString() {
            return "HopsworksConnection.HopsworksConnectionBuilder(host=" + this.host + ", port=" + this.port + ", project=" + this.project + ", region=" + this.region + ", secretStore=" + (Object)((Object)this.secretStore) + ", hostnameVerification=" + this.hostnameVerification + ", trustStorePath=" + this.trustStorePath + ", certPath=" + this.certPath + ", apiKeyFilePath=" + this.apiKeyFilePath + ", apiKeyValue=" + this.apiKeyValue + ")";
        }
    }
}

