/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.google.common.base.Strings;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Project;
import com.logicalclocks.hsfs.SecretStore;
import com.logicalclocks.hsfs.metadata.FeatureStoreApi;
import com.logicalclocks.hsfs.metadata.ProjectApi;
import java.io.Closeable;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;

public abstract class HopsworksConnectionBase
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HopsworksConnectionBase.class);
    protected String host;
    protected int port;
    protected String project;
    protected Region region;
    protected SecretStore secretStore;
    protected boolean hostnameVerification;
    protected String keyStorePath;
    protected String trustStorePath;
    protected String certPath;
    protected String apiKeyFilePath;
    protected String apiKeyValue;
    protected FeatureStoreApi featureStoreApi = new FeatureStoreApi();
    protected ProjectApi projectApi = new ProjectApi();
    protected Project projectObj;

    public abstract Object getFeatureStore() throws IOException, FeatureStoreException;

    public abstract Object getFeatureStore(String var1) throws IOException, FeatureStoreException;

    @Override
    public void close() {
    }

    public String rewriteFeatureStoreName(String name) {
        if ((name = name.toLowerCase()).endsWith("_featurestore")) {
            return name;
        }
        return name + "_featurestore";
    }

    public Project getProject() throws IOException, FeatureStoreException {
        LOGGER.info("Getting information for project name: " + this.project);
        return this.projectApi.get(this.project);
    }

    public String getProjectName(String project) {
        if (Strings.isNullOrEmpty((String)project)) {
            return System.getProperty("hopsworks.projectname");
        }
        return project;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public Region getRegion() {
        return this.region;
    }

    @Generated
    public SecretStore getSecretStore() {
        return this.secretStore;
    }

    @Generated
    public boolean isHostnameVerification() {
        return this.hostnameVerification;
    }

    @Generated
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Generated
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Generated
    public String getCertPath() {
        return this.certPath;
    }

    @Generated
    public String getApiKeyFilePath() {
        return this.apiKeyFilePath;
    }

    @Generated
    public String getApiKeyValue() {
        return this.apiKeyValue;
    }
}

