/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Optional;
import javax.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum SslEndpointIdentificationAlgorithm {
    HTTPS("HTTPS"),
    EMPTY("");

    private String value;

    private SslEndpointIdentificationAlgorithm(String value) {
        this.value = value;
    }

    @JsonCreator
    public static SslEndpointIdentificationAlgorithm fromString(String value) {
        Optional<SslEndpointIdentificationAlgorithm> algorithm = Arrays.stream(SslEndpointIdentificationAlgorithm.values()).filter(a -> a.getValue().equals(value.toUpperCase())).findFirst();
        if (algorithm.isPresent()) {
            return algorithm.get();
        }
        throw new IllegalArgumentException("Invalid ssl endpoint identification algorithm provided");
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }
}

