/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.logicalclocks.hsfs.FeatureStoreException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;

public class PojoToAvroUtils {
    public static GenericRecord convertPojoToGenericRecord(Object input, Schema featureGroupSchema, Schema encodedFeatureGroupSchema, Map<String, Schema> complexFeatureSchemas) throws FeatureStoreException, NoSuchFieldException, IllegalAccessException, IOException {
        GenericRecord plainRecord = input instanceof GenericRecord ? (GenericRecord)input : PojoToAvroUtils.convertPojoToGenericRecord(input, featureGroupSchema);
        GenericData.Record encodedRecord = new GenericData.Record(encodedFeatureGroupSchema);
        for (Schema.Field field : encodedFeatureGroupSchema.getFields()) {
            if (complexFeatureSchemas.containsKey(field.name())) {
                Schema complexFieldSchema = complexFeatureSchemas.get(field.name());
                GenericDatumWriter complexFeatureDatumWriter = new GenericDatumWriter(complexFieldSchema);
                ByteArrayOutputStream complexFeatureByteArrayOutputStream = new ByteArrayOutputStream();
                Throwable throwable = null;
                try {
                    BinaryEncoder complexFeatureBinaryEncoder = new EncoderFactory().binaryEncoder((OutputStream)complexFeatureByteArrayOutputStream, null);
                    complexFeatureDatumWriter.write(plainRecord.get(field.name()), (Encoder)complexFeatureBinaryEncoder);
                    complexFeatureBinaryEncoder.flush();
                    encodedRecord.put(field.name(), (Object)ByteBuffer.wrap(complexFeatureByteArrayOutputStream.toByteArray()));
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (complexFeatureByteArrayOutputStream == null) continue;
                    if (throwable != null) {
                        try {
                            complexFeatureByteArrayOutputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    complexFeatureByteArrayOutputStream.close();
                    continue;
                }
            }
            encodedRecord.put(field.name(), plainRecord.get(field.name()));
        }
        return encodedRecord;
    }

    private static GenericRecord convertPojoToGenericRecord(Object input, Schema featureGroupSchema) throws NoSuchFieldException, IllegalAccessException, FeatureStoreException {
        GenericData.Record record = new GenericData.Record(featureGroupSchema);
        for (Schema.Field schemaField : featureGroupSchema.getFields()) {
            Field pojoField = input.getClass().getDeclaredField(schemaField.name());
            pojoField.setAccessible(true);
            Object pojoValue = pojoField.get(input);
            record.put(schemaField.name(), PojoToAvroUtils.convertValue(pojoValue, schemaField.schema()));
        }
        return record;
    }

    private static Object convertValue(Object value, Schema schema) throws NoSuchFieldException, IllegalAccessException, FeatureStoreException {
        if (value == null) {
            return null;
        }
        switch (schema.getType()) {
            case RECORD: {
                return PojoToAvroUtils.convertPojoToGenericRecord(value, schema);
            }
            case ARRAY: {
                Schema elementType = schema.getElementType();
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    ArrayList<Object> avroList = new ArrayList<Object>();
                    for (Object item : collection) {
                        avroList.add(PojoToAvroUtils.convertValue(item, elementType));
                    }
                    return avroList;
                }
                if (value.getClass().isArray()) {
                    ArrayList<Object> avroList = new ArrayList<Object>();
                    for (Object item : (Object[])value) {
                        avroList.add(PojoToAvroUtils.convertValue(item, elementType));
                    }
                    return avroList;
                }
                throw new FeatureStoreException("Unsupported array type: " + value.getClass());
            }
            case UNION: {
                for (Schema subSchema : schema.getTypes()) {
                    if (subSchema.getType() == Schema.Type.NULL) continue;
                    try {
                        return PojoToAvroUtils.convertValue(value, subSchema);
                    }
                    catch (Exception exception) {
                    }
                }
                throw new FeatureStoreException("Cannot match union type for value: " + value.getClass());
            }
            case ENUM: {
                return new GenericData.EnumSymbol(schema, value.toString());
            }
            case STRING: {
                return value.toString();
            }
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                return value;
            }
            case MAP: {
                if (value instanceof Map) {
                    HashMap<String, Object> avroMap = new HashMap<String, Object>();
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        if (!(entry.getKey() instanceof String)) {
                            throw new FeatureStoreException("Avro only supports string keys in maps.");
                        }
                        avroMap.put(entry.getKey().toString(), PojoToAvroUtils.convertValue(entry.getValue(), schema.getValueType()));
                    }
                    return avroMap;
                }
                throw new FeatureStoreException("Unsupported map type: " + value.getClass());
            }
        }
        throw new FeatureStoreException("Unsupported Avro type: " + schema.getType());
    }
}

