/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.OnlineIngestion;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import java.io.IOException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineIngestionApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineIngestionApi.class);
    public static final String ONLINE_INGESTION_PATH = "/featuregroups/{fgId}/online_ingestion";

    public OnlineIngestion createOnlineIngestion(FeatureGroupBase featureGroup, OnlineIngestion onlineIngestion) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups/{fgId}/online_ingestion";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)featureGroup.getFeatureStore().getId()).set("fgId", (Object)featureGroup.getId()).expand();
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setHeader("Content-Type", "application/json");
        postRequest.setEntity((HttpEntity)hopsworksClient.buildStringEntity(onlineIngestion));
        LOGGER.info("Sending metadata request: " + uri);
        onlineIngestion = hopsworksClient.handleRequest((HttpRequest)postRequest, OnlineIngestion.class);
        onlineIngestion.setFeatureGroup(featureGroup);
        return onlineIngestion;
    }

    public List<OnlineIngestion> getOnlineIngestion(FeatureGroupBase featureGroup, String queryParameters) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups/{fgId}/online_ingestion";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)hopsworksClient.getProject().getProjectId()).set("fsId", (Object)featureGroup.getFeatureStore().getId()).set("fgId", (Object)featureGroup.getId()).expand() + "?" + queryParameters;
        LOGGER.debug("Sending metadata request: " + uri);
        OnlineIngestion onlineIngestion = hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), OnlineIngestion.class);
        for (OnlineIngestion ingestion : onlineIngestion.getItems()) {
            ingestion.setFeatureGroup(featureGroup);
        }
        return onlineIngestion.getItems();
    }
}

