/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.google.common.base.Strings;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.metadata.RestDto;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSource
extends RestDto<DataSource> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DataSource.class);
    private String query = "";
    private String database = "";
    private String group = "";
    private String table = "";
    private String path = "";

    public void updateStorageConnector(StorageConnector storageConnector) {
        if (storageConnector == null) {
            return;
        }
        switch (storageConnector.getStorageConnectorType()) {
            case REDSHIFT: {
                StorageConnector.RedshiftConnector redshiftConnector = (StorageConnector.RedshiftConnector)storageConnector;
                if (!Strings.isNullOrEmpty((String)this.database)) {
                    redshiftConnector.setDatabaseName(this.database);
                }
                if (!Strings.isNullOrEmpty((String)this.group)) {
                    redshiftConnector.setDatabaseGroup(this.group);
                }
                if (Strings.isNullOrEmpty((String)this.table)) break;
                redshiftConnector.setTableName(this.table);
                break;
            }
            case SNOWFLAKE: {
                StorageConnector.SnowflakeConnector snowflakeConnector = (StorageConnector.SnowflakeConnector)storageConnector;
                if (!Strings.isNullOrEmpty((String)this.database)) {
                    snowflakeConnector.setDatabase(this.database);
                }
                if (!Strings.isNullOrEmpty((String)this.group)) {
                    snowflakeConnector.setSchema(this.group);
                }
                if (Strings.isNullOrEmpty((String)this.table)) break;
                snowflakeConnector.setTable(this.table);
                break;
            }
            case BIGQUERY: {
                StorageConnector.BigqueryConnector bigqueryConnector = (StorageConnector.BigqueryConnector)storageConnector;
                if (!Strings.isNullOrEmpty((String)this.database)) {
                    bigqueryConnector.setQueryProject(this.database);
                }
                if (!Strings.isNullOrEmpty((String)this.group)) {
                    bigqueryConnector.setDataset(this.group);
                }
                if (Strings.isNullOrEmpty((String)this.table)) break;
                bigqueryConnector.setQueryTable(this.table);
                break;
            }
            case RDS: {
                StorageConnector.RdsConnector rdsConnector = (StorageConnector.RdsConnector)storageConnector;
                if (Strings.isNullOrEmpty((String)this.database)) break;
                rdsConnector.setDatabase(this.database);
                break;
            }
        }
    }

    @Generated
    public DataSource() {
    }

    @Generated
    public DataSource(String query, String database, String group, String table, String path) {
        this.query = query;
        this.database = database;
        this.group = group;
        this.table = table;
        this.path = path;
    }

    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public void setQuery(String query) {
        this.query = query;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public void setDatabase(String database) {
        this.database = database;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public void setGroup(String group) {
        this.group = group;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Generated
    public void setTable(String table) {
        this.table = table;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }
}

