/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.metadata.RestDto;
import java.util.Map;
import lombok.Generated;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FeatureDescriptiveStatistics
extends RestDto<FeatureDescriptiveStatistics> {
    private Integer id;
    private String featureType;
    private String featureName;
    private Long count;
    private Double completeness;
    private Long numNonNullValues;
    private Long numNullValues;
    private Long approxNumDistinctValues;
    private Double min;
    private Double max;
    private Double sum;
    private Double mean;
    private Double stddev;
    private Map<String, Double> percentiles;
    private Double distinctness;
    private Double entropy;
    private Double uniqueness;
    private Long exactNumDistinctValues;
    private String extendedStatistics;

    public static FeatureDescriptiveStatistics fromDeequStatisticsJson(JSONObject statsJson) {
        FeatureDescriptiveStatistics fds = new FeatureDescriptiveStatistics();
        fds.setFeatureName(statsJson.getString("column"));
        if (statsJson.has("dataType")) {
            fds.setFeatureType(statsJson.getString("dataType"));
        }
        if (statsJson.has("count") && statsJson.getLong("count") == 0L) {
            fds.setCount(0L);
            return fds;
        }
        if (statsJson.has("numRecordsNull")) {
            fds.setNumNullValues(statsJson.getLong("numRecordsNull"));
        }
        if (statsJson.has("numRecordsNonNull")) {
            fds.setNumNonNullValues(statsJson.getLong("numRecordsNonNull"));
        }
        if (statsJson.has("numRecordsNull") && statsJson.has("numRecordsNonNull")) {
            fds.setCount(Long.valueOf(statsJson.getInt("numRecordsNull") + statsJson.getInt("numRecordsNonNull")));
        }
        if (statsJson.has("count")) {
            fds.setCount(statsJson.getLong("count"));
        }
        if (statsJson.has("completeness")) {
            fds.setCompleteness(statsJson.getDouble("completeness"));
        }
        if (statsJson.has("approximateNumDistinctValues")) {
            fds.setApproxNumDistinctValues(statsJson.getLong("approximateNumDistinctValues"));
        }
        if (statsJson.has("uniqueness")) {
            fds.setUniqueness(statsJson.getDouble("uniqueness"));
        }
        if (statsJson.has("entropy")) {
            fds.setEntropy(statsJson.getDouble("entropy"));
        }
        if (statsJson.has("distinctness")) {
            fds.setDistinctness(statsJson.getDouble("distinctness"));
        }
        if (statsJson.has("exactNumDistinctValues")) {
            fds.setExactNumDistinctValues(statsJson.getLong("exactNumDistinctValues"));
        }
        if (statsJson.has("minimum")) {
            fds.setMin(statsJson.getDouble("minimum"));
        }
        if (statsJson.has("maximum")) {
            fds.setMax(statsJson.getDouble("maximum"));
        }
        if (statsJson.has("sum")) {
            fds.setSum(statsJson.getDouble("sum"));
        }
        if (statsJson.has("mean")) {
            fds.setMean(statsJson.getDouble("mean"));
        }
        if (statsJson.has("stdDev")) {
            fds.setStddev(statsJson.getDouble("stdDev"));
        }
        JSONObject extendedStatistics = new JSONObject();
        if (statsJson.has("correlations")) {
            extendedStatistics.put("correlations", (Object)statsJson.getJSONArray("correlations"));
        }
        if (statsJson.has("histogram")) {
            extendedStatistics.put("histogram", (Object)statsJson.getJSONArray("histogram"));
        }
        if (statsJson.has("kll")) {
            extendedStatistics.put("kll", statsJson.get("kll"));
        }
        if (statsJson.has("unique_values")) {
            extendedStatistics.put("unique_values", (Object)statsJson.getJSONArray("unique_values"));
        }
        if (extendedStatistics.length() > 0) {
            fds.setExtendedStatistics(extendedStatistics.toString());
        }
        return fds;
    }

    @Generated
    public FeatureDescriptiveStatistics() {
    }

    @Generated
    public FeatureDescriptiveStatistics(Integer id, String featureType, String featureName, Long count, Double completeness, Long numNonNullValues, Long numNullValues, Long approxNumDistinctValues, Double min, Double max, Double sum, Double mean, Double stddev, Map<String, Double> percentiles, Double distinctness, Double entropy, Double uniqueness, Long exactNumDistinctValues, String extendedStatistics) {
        this.id = id;
        this.featureType = featureType;
        this.featureName = featureName;
        this.count = count;
        this.completeness = completeness;
        this.numNonNullValues = numNonNullValues;
        this.numNullValues = numNullValues;
        this.approxNumDistinctValues = approxNumDistinctValues;
        this.min = min;
        this.max = max;
        this.sum = sum;
        this.mean = mean;
        this.stddev = stddev;
        this.percentiles = percentiles;
        this.distinctness = distinctness;
        this.entropy = entropy;
        this.uniqueness = uniqueness;
        this.exactNumDistinctValues = exactNumDistinctValues;
        this.extendedStatistics = extendedStatistics;
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public String getFeatureType() {
        return this.featureType;
    }

    @Generated
    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    @Generated
    public Long getCount() {
        return this.count;
    }

    @Generated
    public Double getCompleteness() {
        return this.completeness;
    }

    @Generated
    public Long getNumNonNullValues() {
        return this.numNonNullValues;
    }

    @Generated
    public Long getNumNullValues() {
        return this.numNullValues;
    }

    @Generated
    public Long getApproxNumDistinctValues() {
        return this.approxNumDistinctValues;
    }

    @Generated
    public Double getMin() {
        return this.min;
    }

    @Generated
    public Double getMax() {
        return this.max;
    }

    @Generated
    public Double getSum() {
        return this.sum;
    }

    @Generated
    public Double getMean() {
        return this.mean;
    }

    @Generated
    public Double getStddev() {
        return this.stddev;
    }

    @Generated
    public Map<String, Double> getPercentiles() {
        return this.percentiles;
    }

    @Generated
    public Double getDistinctness() {
        return this.distinctness;
    }

    @Generated
    public Double getEntropy() {
        return this.entropy;
    }

    @Generated
    public Double getUniqueness() {
        return this.uniqueness;
    }

    @Generated
    public Long getExactNumDistinctValues() {
        return this.exactNumDistinctValues;
    }

    @Generated
    public String getExtendedStatistics() {
        return this.extendedStatistics;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setFeatureType(String featureType) {
        this.featureType = featureType;
    }

    @Generated
    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    @Override
    @Generated
    public void setCount(Long count) {
        this.count = count;
    }

    @Generated
    public void setCompleteness(Double completeness) {
        this.completeness = completeness;
    }

    @Generated
    public void setNumNonNullValues(Long numNonNullValues) {
        this.numNonNullValues = numNonNullValues;
    }

    @Generated
    public void setNumNullValues(Long numNullValues) {
        this.numNullValues = numNullValues;
    }

    @Generated
    public void setApproxNumDistinctValues(Long approxNumDistinctValues) {
        this.approxNumDistinctValues = approxNumDistinctValues;
    }

    @Generated
    public void setMin(Double min) {
        this.min = min;
    }

    @Generated
    public void setMax(Double max) {
        this.max = max;
    }

    @Generated
    public void setSum(Double sum) {
        this.sum = sum;
    }

    @Generated
    public void setMean(Double mean) {
        this.mean = mean;
    }

    @Generated
    public void setStddev(Double stddev) {
        this.stddev = stddev;
    }

    @Generated
    public void setPercentiles(Map<String, Double> percentiles) {
        this.percentiles = percentiles;
    }

    @Generated
    public void setDistinctness(Double distinctness) {
        this.distinctness = distinctness;
    }

    @Generated
    public void setEntropy(Double entropy) {
        this.entropy = entropy;
    }

    @Generated
    public void setUniqueness(Double uniqueness) {
        this.uniqueness = uniqueness;
    }

    @Generated
    public void setExactNumDistinctValues(Long exactNumDistinctValues) {
        this.exactNumDistinctValues = exactNumDistinctValues;
    }

    @Generated
    public void setExtendedStatistics(String extendedStatistics) {
        this.extendedStatistics = extendedStatistics;
    }
}

