/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.SecretStore;
import com.logicalclocks.hsfs.metadata.AuthorizationHandler;
import com.logicalclocks.hsfs.metadata.HopsworksHostnameVerifier;
import com.logicalclocks.hsfs.metadata.HopsworksHttpClient;
import com.logicalclocks.hsfs.metadata.InternalException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.SsmClientBuilder;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterResponse;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;

public class HopsworksExternalClient
implements HopsworksHttpClient {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)HopsworksExternalClient.class.getName());
    protected static final String PARAM_NAME_SECRET_STORE = "hopsworks/role/";
    protected static final String PARAM_NAME_PARAMETER_STORE = "/hopsworks/role/";
    protected static final String MATERIAL_PASSWD = "material_passwd";
    protected static final String T_CERTIFICATE = "t_certificate";
    protected static final String K_CERTIFICATE = "k_certificate";
    protected PoolingHttpClientConnectionManager connectionPool = null;
    protected HttpHost httpHost = null;
    protected CloseableHttpClient httpClient = null;
    protected String apiKey = "";
    protected String trustStorePath;
    protected String keyStorePath;
    protected String certKey;

    public HopsworksExternalClient(CloseableHttpClient httpClient, HttpHost httpHost) {
        this.httpClient = httpClient;
        this.httpHost = httpHost;
    }

    HopsworksExternalClient(String host, int port, Region region, SecretStore secretStore, boolean hostnameVerification, String trustStorePath, String apiKeyFilepath, String apiKeyValue) throws IOException, FeatureStoreException, KeyStoreException, CertificateException, NoSuchAlgorithmException, KeyManagementException {
        this.httpHost = new HttpHost(host, port, "https");
        this.connectionPool = new PoolingHttpClientConnectionManager(this.createConnectionFactory(this.httpHost, hostnameVerification, trustStorePath));
        this.connectionPool.setMaxTotal(10);
        this.connectionPool.setDefaultMaxPerRoute(10);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionPool).setKeepAliveStrategy((httpResponse, httpContext) -> 30000L).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).build();
        this.apiKey = !Strings.isNullOrEmpty((String)apiKeyValue) ? apiKeyValue : this.readApiKey(secretStore, region, apiKeyFilepath);
    }

    protected Registry<ConnectionSocketFactory> createConnectionFactory(HttpHost httpHost, boolean hostnameVerification, String trustStorePath) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslCtx = null;
        sslCtx = !Strings.isNullOrEmpty((String)trustStorePath) ? SSLContexts.custom().loadTrustMaterial(Paths.get(trustStorePath, new String[0]).toFile(), null, (TrustStrategy)new TrustSelfSignedStrategy()).build() : (!hostnameVerification ? SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build() : SSLContext.getDefault());
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslCtx, (HostnameVerifier)new HopsworksHostnameVerifier(hostnameVerification, httpHost.toHostString()));
        return RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String readCertKey(String materialPwd) {
        try (FileInputStream fis = new FileInputStream(materialPwd);){
            int content;
            StringBuilder sb = new StringBuilder();
            while ((content = fis.read()) != -1) {
                sb.append((char)content);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to get cert password.", (Throwable)ex);
            return null;
        }
    }

    public String readApiKey(SecretStore secretStore, Region region, String apiKeyFilepath) throws IOException, FeatureStoreException {
        if (!Strings.isNullOrEmpty((String)apiKeyFilepath)) {
            return FileUtils.readFileToString((File)Paths.get(apiKeyFilepath, new String[0]).toFile());
        }
        switch (secretStore) {
            case PARAMETER_STORE: {
                return this.readApiKeyParamStore(region, "api-key");
            }
            case SECRET_MANAGER: {
                return this.readApiKeySecretManager(region, "api-key");
            }
        }
        throw new FeatureStoreException("ApiKeyFilepath needs to be set for local mode");
    }

    protected String readApiKeyParamStore(Region region, String secretKey) throws FeatureStoreException {
        SsmClient ssmClient = (SsmClient)((SsmClientBuilder)SsmClient.builder().region(region)).build();
        String paramName = PARAM_NAME_PARAMETER_STORE + this.getAssumedRole() + "/type/" + secretKey;
        GetParameterRequest paramRequest = (GetParameterRequest)GetParameterRequest.builder().name(paramName).withDecryption(Boolean.valueOf(true)).build();
        GetParameterResponse parameterResponse = ssmClient.getParameter(paramRequest);
        String apiKey = parameterResponse.parameter().value();
        if (!Strings.isNullOrEmpty((String)apiKey)) {
            return apiKey;
        }
        throw new FeatureStoreException("Could not find parameter " + paramName + " in parameter store");
    }

    protected String readApiKeySecretManager(Region region, String secretKey) throws FeatureStoreException, IOException {
        SecretsManagerClient secretsManagerClient = (SecretsManagerClient)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(region)).build();
        String paramName = PARAM_NAME_SECRET_STORE + this.getAssumedRole();
        ObjectMapper objectMapper = new ObjectMapper();
        GetSecretValueRequest secretValueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(paramName).build();
        GetSecretValueResponse secretValueResponse = secretsManagerClient.getSecretValue(secretValueRequest);
        HashMap secretMap = (HashMap)objectMapper.readValue(secretValueResponse.secretString(), HashMap.class);
        String apiKey = (String)secretMap.get("api-key");
        if (!Strings.isNullOrEmpty((String)apiKey)) {
            return apiKey;
        }
        throw new FeatureStoreException("Could not find secret " + paramName + " in secret store");
    }

    protected String getAssumedRole() throws FeatureStoreException {
        try (StsClient stsClient = StsClient.create();){
            GetCallerIdentityResponse callerIdentityResponse = stsClient.getCallerIdentity();
            String arn = callerIdentityResponse.arn();
            String[] arnSplits = arn.split("/");
            if (arnSplits.length != 3 || !arnSplits[0].endsWith("assumed-role")) {
                throw new FeatureStoreException("Failed to extract assumed role from arn: " + arn);
            }
            String string = arnSplits[1];
            return string;
        }
    }

    @Override
    public <T> T handleRequest(HttpRequest request, ResponseHandler<T> responseHandler) throws IOException {
        LOGGER.info("Handling metadata request: " + request);
        AuthorizationHandler<T> authHandler = new AuthorizationHandler<T>(responseHandler);
        request.setHeader("Authorization", "ApiKey " + this.apiKey);
        try {
            return (T)this.httpClient.execute(this.httpHost, request, authHandler);
        }
        catch (InternalException e) {
            return (T)this.httpClient.execute(this.httpHost, request, authHandler);
        }
    }

    @Override
    @Generated
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Override
    @Generated
    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    @Override
    @Generated
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Override
    @Generated
    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    @Override
    @Generated
    public String getCertKey() {
        return this.certKey;
    }

    @Override
    @Generated
    public void setCertKey(String certKey) {
        this.certKey = certKey;
    }
}

