/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.FeatureViewBase;
import com.logicalclocks.hsfs.Split;
import com.logicalclocks.hsfs.StreamFeatureGroup;
import com.logicalclocks.hsfs.TrainingDatasetBase;
import com.logicalclocks.hsfs.TrainingDatasetFeature;
import com.logicalclocks.hsfs.constructor.Join;
import com.logicalclocks.hsfs.constructor.QueryBase;
import com.logicalclocks.hsfs.metadata.FeatureViewApi;
import com.logicalclocks.hsfs.metadata.TagsApi;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FeatureViewEngineBase<T1 extends QueryBase<T1, T4, T5>, T2 extends FeatureViewBase<T2, T3, T1, T5>, T3 extends FeatureStoreBase<T1>, T4 extends FeatureGroupBase, T5> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FeatureViewEngineBase.class);
    protected FeatureViewApi featureViewApi = new FeatureViewApi();
    protected TagsApi tagsApi = new TagsApi(EntityEndpointType.FEATURE_VIEW);
    public static String AMBIGUOUS_LABEL_ERROR = "Provided label '%s' is ambiguous and exists in more than one feature groups. You can provide the label with the prefix you specify in the join.";
    public static String LABEL_NOT_EXIST_ERROR = "Provided label '%s' do not exist in any of the feature groups.";

    public T2 save(T2 featureViewBase, Class<T2> fvType) throws FeatureStoreException, IOException {
        ((FeatureViewBase)featureViewBase).setFeatures(FeatureViewEngineBase.makeLabelFeatures(((FeatureViewBase)featureViewBase).getQuery(), ((FeatureViewBase)featureViewBase).getLabels()));
        T2 updatedFeatureViewBase = this.featureViewApi.save((FeatureViewBase)featureViewBase, fvType);
        ((FeatureViewBase)featureViewBase).setId(((FeatureViewBase)updatedFeatureViewBase).getId());
        ((FeatureViewBase)featureViewBase).setVersion(((FeatureViewBase)updatedFeatureViewBase).getVersion());
        ((FeatureViewBase)featureViewBase).setFeatures(((FeatureViewBase)updatedFeatureViewBase).getFeatures());
        return featureViewBase;
    }

    public static List<TrainingDatasetFeature> makeLabelFeatures(QueryBase query, List<String> labels) throws FeatureStoreException {
        if (labels == null || labels.isEmpty()) {
            return Lists.newArrayList();
        }
        HashMap labelWithPrefixToFeature = Maps.newHashMap();
        HashMap labelWithPrefixToFeatureGroup = Maps.newHashMap();
        HashMap labelToFeatureGroups = Maps.newHashMap();
        for (Feature feature : query.getLeftFeatures()) {
            labelWithPrefixToFeature.put(feature.getName(), feature.getName());
            labelWithPrefixToFeatureGroup.put(feature.getName(), new StreamFeatureGroup(null, feature.getFeatureGroupId()));
        }
        for (Join join : query.getJoins()) {
            for (Feature feat : ((QueryBase)join.getQuery()).getLeftFeatures()) {
                String labelWithPrefix = join.getPrefix() + feat.getName();
                labelWithPrefixToFeature.put(labelWithPrefix, feat.getName());
                labelWithPrefixToFeatureGroup.put(labelWithPrefix, new StreamFeatureGroup(null, feat.getFeatureGroupId()));
                List featureGroups = labelToFeatureGroups.getOrDefault(feat.getName(), Lists.newArrayList());
                featureGroups.add(new StreamFeatureGroup(null, feat.getFeatureGroupId()));
                labelToFeatureGroups.put(feat.getName(), featureGroups);
            }
        }
        ArrayList trainingDatasetFeatures = Lists.newArrayList();
        for (String label : labels) {
            if (labelWithPrefixToFeature.containsKey(label)) {
                trainingDatasetFeatures.add(new TrainingDatasetFeature((StreamFeatureGroup)labelWithPrefixToFeatureGroup.get(label.toLowerCase()), (String)labelWithPrefixToFeature.get(label.toLowerCase()), true));
                continue;
            }
            if (labelToFeatureGroups.containsKey(label)) {
                if (((List)labelToFeatureGroups.get(label.toLowerCase())).size() > 1) {
                    throw new FeatureStoreException(String.format(AMBIGUOUS_LABEL_ERROR, label));
                }
                trainingDatasetFeatures.add(new TrainingDatasetFeature((StreamFeatureGroup)((List)labelToFeatureGroups.get(label.toLowerCase())).get(0), label.toLowerCase(), true));
                continue;
            }
            throw new FeatureStoreException(String.format(LABEL_NOT_EXIST_ERROR, label));
        }
        return trainingDatasetFeatures;
    }

    public abstract T2 update(T2 var1) throws FeatureStoreException, IOException;

    public abstract T2 get(T3 var1, String var2, Integer var3) throws FeatureStoreException, IOException;

    public T2 get(T3 featureStoreBase, String name, Integer version, Class<T2> fvType) throws FeatureStoreException, IOException {
        FeatureViewBase featureViewBase = this.featureViewApi.get((FeatureStoreBase)featureStoreBase, name, version, fvType);
        featureViewBase.setFeatureStore(featureStoreBase);
        List<TrainingDatasetFeature> features = featureViewBase.getFeatures();
        features.stream().filter(f -> f.getFeaturegroup() != null).forEach(f -> f.getFeaturegroup().setFeatureStore((FeatureStoreBase)featureStoreBase));
        ((QueryBase)featureViewBase.getQuery()).getLeftFeatureGroup().setFeatureStore((FeatureStoreBase)featureStoreBase);
        featureViewBase.setLabels(features.stream().filter(TrainingDatasetFeature::getLabel).map(TrainingDatasetFeature::getName).collect(Collectors.toList()));
        return (T2)featureViewBase;
    }

    public List<FeatureViewBase> get(T3 featureStoreBase, String name) throws FeatureStoreException, IOException {
        List<FeatureViewBase> featureViewBases = this.featureViewApi.get((FeatureStoreBase)featureStoreBase, name);
        for (FeatureViewBase fv : featureViewBases) {
            fv.setFeatureStore(featureStoreBase);
            List<TrainingDatasetFeature> features = fv.getFeatures();
            features.stream().filter(f -> f.getFeaturegroup() != null).forEach(f -> f.getFeaturegroup().setFeatureStore((FeatureStoreBase)featureStoreBase));
            ((QueryBase)fv.getQuery()).getLeftFeatureGroup().setFeatureStore((FeatureStoreBase)featureStoreBase);
            fv.setLabels(features.stream().filter(TrainingDatasetFeature::getLabel).map(TrainingDatasetFeature::getName).collect(Collectors.toList()));
        }
        return featureViewBases;
    }

    public void delete(T3 featureStoreBase, String name) throws FeatureStoreException, IOException {
        this.featureViewApi.delete((FeatureStoreBase)featureStoreBase, name);
    }

    public void delete(T3 featureStoreBase, String name, Integer version) throws FeatureStoreException, IOException {
        this.featureViewApi.delete((FeatureStoreBase)featureStoreBase, name, version);
    }

    protected Date getStartTime() {
        return new Date(1000L);
    }

    protected Date getEndTime() {
        return new Date();
    }

    public void addTag(FeatureViewBase featureViewBase, String name, Object value) throws FeatureStoreException, IOException {
        this.tagsApi.add(featureViewBase, name, value);
    }

    public void addTag(FeatureViewBase featureViewBase, String name, Object value, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        this.tagsApi.add(featureViewBase, trainingDataVersion, name, value);
    }

    public void deleteTag(FeatureViewBase featureViewBase, String name) throws FeatureStoreException, IOException {
        this.tagsApi.deleteTag(featureViewBase, name);
    }

    public void deleteTag(FeatureViewBase featureViewBase, String name, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        this.tagsApi.deleteTag(featureViewBase, trainingDataVersion, name);
    }

    public Object getTag(FeatureViewBase featureViewBase, String name) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureViewBase, name);
    }

    public Object getTag(FeatureViewBase featureViewBase, String name, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureViewBase, trainingDataVersion, name);
    }

    public Map<String, Object> getTags(FeatureViewBase featureViewBase) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureViewBase);
    }

    public Map<String, Object> getTags(FeatureViewBase featureViewBase, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureViewBase, trainingDataVersion);
    }

    public T1 getBatchQuery(T2 featureView, Date startTime, Date endTime, Boolean withLabels, Integer trainingDataVersion, Class<T1> queryType) throws FeatureStoreException, IOException {
        T1 query;
        try {
            query = this.featureViewApi.getBatchQuery((FeatureStoreBase)((FeatureViewBase)featureView).getFeatureStore(), ((FeatureViewBase)featureView).getName(), ((FeatureViewBase)featureView).getVersion(), startTime == null ? null : Long.valueOf(startTime.getTime()), endTime == null ? null : Long.valueOf(endTime.getTime()), withLabels, trainingDataVersion, queryType);
        }
        catch (IOException e) {
            if (e.getMessage().contains("\"errorCode\":270172")) {
                throw new FeatureStoreException("Cannot generate dataset or query from the given start/end time because event time column is not available in the left feature groups. A start/end time should not be provided as parameters.");
            }
            throw e;
        }
        ((QueryBase)query).getLeftFeatureGroup().setFeatureStore(((QueryBase)((FeatureViewBase)featureView).getQuery()).getLeftFeatureGroup().getFeatureStore());
        return query;
    }

    protected void setEventTime(FeatureViewBase featureView, TrainingDatasetBase trainingDataset) {
        String eventTime = ((QueryBase)featureView.getQuery()).getLeftFeatureGroup().getEventTime();
        if (!Strings.isNullOrEmpty((String)eventTime)) {
            if (trainingDataset.getSplits() != null && !trainingDataset.getSplits().isEmpty()) {
                for (Split split : trainingDataset.getSplits()) {
                    if (split.getSplitType() == Split.SplitType.TIME_SERIES_SPLIT && split.getName().equals("train") && split.getStartTime() == null) {
                        split.setStartTime(this.getStartTime());
                    }
                    if (split.getSplitType() != Split.SplitType.TIME_SERIES_SPLIT || !split.getName().equals("test") || split.getEndTime() != null) continue;
                    split.setEndTime(this.getEndTime());
                }
            } else {
                if (trainingDataset.getEventStartTime() == null) {
                    trainingDataset.setEventStartTime(this.getStartTime());
                }
                if (trainingDataset.getEventEndTime() == null) {
                    trainingDataset.setEventEndTime(this.getEndTime());
                }
            }
        }
    }

    public void deleteTrainingData(T2 featureView, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        this.featureViewApi.deleteTrainingData((FeatureStoreBase)((FeatureViewBase)featureView).getFeatureStore(), ((FeatureViewBase)featureView).getName(), ((FeatureViewBase)featureView).getVersion(), trainingDataVersion);
    }

    public void deleteTrainingData(T2 featureView) throws FeatureStoreException, IOException {
        this.featureViewApi.deleteTrainingData((FeatureStoreBase)((FeatureViewBase)featureView).getFeatureStore(), ((FeatureViewBase)featureView).getName(), ((FeatureViewBase)featureView).getVersion());
    }

    public void deleteTrainingDatasetOnly(T2 featureView, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        this.featureViewApi.deleteTrainingDatasetOnly((FeatureStoreBase)((FeatureViewBase)featureView).getFeatureStore(), ((FeatureViewBase)featureView).getName(), ((FeatureViewBase)featureView).getVersion(), trainingDataVersion);
    }

    public void deleteTrainingDatasetOnly(T2 featureView) throws FeatureStoreException, IOException {
        this.featureViewApi.deleteTrainingDatasetOnly((FeatureStoreBase)((FeatureViewBase)featureView).getFeatureStore(), ((FeatureViewBase)featureView).getName(), ((FeatureViewBase)featureView).getVersion());
    }
}

