/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.servicediscoverclient.resolvers;

import com.logicalclocks.servicediscoverclient.Builder;
import com.logicalclocks.servicediscoverclient.ServiceDiscoveryClient;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryGenericException;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceNotFoundException;
import com.logicalclocks.servicediscoverclient.resolvers.Type;
import com.logicalclocks.servicediscoverclient.service.Service;
import com.logicalclocks.servicediscoverclient.service.ServiceQuery;
import com.logicalclocks.shaded.com.google.common.cache.CacheBuilder;
import com.logicalclocks.shaded.com.google.common.cache.CacheLoader;
import com.logicalclocks.shaded.com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public class CachingResolver
implements ServiceDiscoveryClient {
    private ServiceDiscoveryClient resolver;
    private LoadingCache<ServiceQuery, List<Service>> serviceCache;

    @Override
    public void init(@NonNull Builder builder) throws ServiceDiscoveryException {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.resolver = builder.getServiceDiscoveryClient() == null ? new Builder(Type.DNS).withDnsHost(builder.getDnsHost()).withDnsPort(builder.getDnsPort()).build() : builder.getServiceDiscoveryClient();
        this.serviceCache = CacheBuilder.newBuilder().expireAfterWrite(builder.getCacheExpiration()).weakValues().build(new CacheLoader<ServiceQuery, List<Service>>(){

            @Override
            public List<Service> load(ServiceQuery serviceQuery) throws Exception {
                return CachingResolver.this.getServiceInternal(serviceQuery);
            }
        });
    }

    @Override
    public Stream<Service> getService(@NonNull ServiceQuery service) throws ServiceDiscoveryException {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (this.serviceCache == null || this.resolver == null) {
            throw new ServiceDiscoveryGenericException("Caching resolver has not been initialized");
        }
        try {
            return this.serviceCache.get(service).stream();
        }
        catch (ExecutionException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof ServiceNotFoundException) {
                throw (ServiceNotFoundException)ex.getCause();
            }
            throw new ServiceDiscoveryException(ex);
        }
    }

    @Override
    public void close() {
        if (this.resolver != null) {
            this.resolver.close();
        }
    }

    private List<Service> getServiceInternal(ServiceQuery service) throws ServiceDiscoveryException {
        return this.resolver.getService(service).collect(Collectors.toList());
    }
}

