/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.com.orbitz.consul;

import com.logicalclocks.shaded.com.orbitz.consul.BaseClient;
import com.logicalclocks.shaded.com.orbitz.consul.async.ConsulResponseCallback;
import com.logicalclocks.shaded.com.orbitz.consul.async.EventResponseCallback;
import com.logicalclocks.shaded.com.orbitz.consul.config.ClientConfig;
import com.logicalclocks.shaded.com.orbitz.consul.model.ConsulResponse;
import com.logicalclocks.shaded.com.orbitz.consul.model.EventResponse;
import com.logicalclocks.shaded.com.orbitz.consul.model.ImmutableEventResponse;
import com.logicalclocks.shaded.com.orbitz.consul.model.event.Event;
import com.logicalclocks.shaded.com.orbitz.consul.monitoring.ClientEventCallback;
import com.logicalclocks.shaded.com.orbitz.consul.option.EventOptions;
import com.logicalclocks.shaded.com.orbitz.consul.option.QueryOptions;
import com.logicalclocks.shaded.okhttp3.MediaType;
import com.logicalclocks.shaded.okhttp3.RequestBody;
import com.logicalclocks.shaded.org.apache.commons.lang3.StringUtils;
import com.logicalclocks.shaded.retrofit2.Call;
import com.logicalclocks.shaded.retrofit2.Retrofit;
import com.logicalclocks.shaded.retrofit2.http.Body;
import com.logicalclocks.shaded.retrofit2.http.GET;
import com.logicalclocks.shaded.retrofit2.http.PUT;
import com.logicalclocks.shaded.retrofit2.http.Path;
import com.logicalclocks.shaded.retrofit2.http.QueryMap;
import java.util.List;
import java.util.Map;

public class EventClient
extends BaseClient {
    private static String CLIENT_NAME = "event";
    private final Api api;

    EventClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = retrofit.create(Api.class);
    }

    public Event fireEvent(String name, EventOptions eventOptions, String payload) {
        return this.http.extract(this.api.fireEvent(name, RequestBody.create(MediaType.parse("text/plain"), payload), eventOptions.toQuery()), new Integer[0]);
    }

    public Event fireEvent(String name) {
        return this.fireEvent(name, EventOptions.BLANK);
    }

    public Event fireEvent(String name, EventOptions eventOptions) {
        return this.http.extract(this.api.fireEvent(name, eventOptions.toQuery()), new Integer[0]);
    }

    public Event fireEvent(String name, String payload) {
        return this.fireEvent(name, EventOptions.BLANK, payload);
    }

    public EventResponse listEvents(String name, QueryOptions queryOptions) {
        Map<String, Object> query = queryOptions.toQuery();
        if (StringUtils.isNotEmpty(name)) {
            query.put("name", name);
        }
        ConsulResponse<List<Event>> response = this.http.extractConsulResponse(this.api.listEvents(query), new Integer[0]);
        return ImmutableEventResponse.of(response.getResponse(), response.getIndex());
    }

    public EventResponse listEvents(String name) {
        return this.listEvents(name, QueryOptions.BLANK);
    }

    public EventResponse listEvents(QueryOptions queryOptions) {
        return this.listEvents(null, queryOptions);
    }

    public EventResponse listEvents() {
        return this.listEvents(null, QueryOptions.BLANK);
    }

    public void listEvents(String name, QueryOptions queryOptions, EventResponseCallback callback) {
        Map<String, Object> query = queryOptions.toQuery();
        if (StringUtils.isNotEmpty(name)) {
            query.put("name", name);
        }
        this.http.extractConsulResponse(this.api.listEvents(query), this.createConsulResponseCallbackWrapper(callback), new Integer[0]);
    }

    private ConsulResponseCallback<List<Event>> createConsulResponseCallbackWrapper(final EventResponseCallback callback) {
        return new ConsulResponseCallback<List<Event>>(){

            @Override
            public void onComplete(ConsulResponse<List<Event>> response) {
                callback.onComplete(ImmutableEventResponse.of(response.getResponse(), response.getIndex()));
            }

            @Override
            public void onFailure(Throwable throwable) {
                callback.onFailure(throwable);
            }
        };
    }

    public void listEvents(QueryOptions queryOptions, EventResponseCallback callback) {
        this.listEvents(null, queryOptions, callback);
    }

    public void listEvents(EventResponseCallback callback) {
        this.listEvents(null, QueryOptions.BLANK, callback);
    }

    static interface Api {
        @PUT(value="event/fire/{name}")
        public Call<Event> fireEvent(@Path(value="name") String var1, @Body RequestBody var2, @QueryMap Map<String, Object> var3);

        @PUT(value="event/fire/{name}")
        public Call<Event> fireEvent(@Path(value="name") String var1, @QueryMap Map<String, Object> var2);

        @GET(value="event/list")
        public Call<List<Event>> listEvents(@QueryMap Map<String, Object> var1);
    }
}

