/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.com.orbitz.consul;

import com.logicalclocks.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.logicalclocks.shaded.com.google.common.annotations.VisibleForTesting;
import com.logicalclocks.shaded.com.google.common.base.Preconditions;
import com.logicalclocks.shaded.com.google.common.collect.ImmutableMap;
import com.logicalclocks.shaded.com.google.common.primitives.UnsignedLongs;
import com.logicalclocks.shaded.com.orbitz.consul.BaseClient;
import com.logicalclocks.shaded.com.orbitz.consul.ConsulException;
import com.logicalclocks.shaded.com.orbitz.consul.async.ConsulResponseCallback;
import com.logicalclocks.shaded.com.orbitz.consul.config.ClientConfig;
import com.logicalclocks.shaded.com.orbitz.consul.model.ConsulResponse;
import com.logicalclocks.shaded.com.orbitz.consul.model.kv.Operation;
import com.logicalclocks.shaded.com.orbitz.consul.model.kv.TxResponse;
import com.logicalclocks.shaded.com.orbitz.consul.model.kv.Value;
import com.logicalclocks.shaded.com.orbitz.consul.monitoring.ClientEventCallback;
import com.logicalclocks.shaded.com.orbitz.consul.option.ConsistencyMode;
import com.logicalclocks.shaded.com.orbitz.consul.option.DeleteOptions;
import com.logicalclocks.shaded.com.orbitz.consul.option.ImmutablePutOptions;
import com.logicalclocks.shaded.com.orbitz.consul.option.ImmutableTransactionOptions;
import com.logicalclocks.shaded.com.orbitz.consul.option.PutOptions;
import com.logicalclocks.shaded.com.orbitz.consul.option.QueryOptions;
import com.logicalclocks.shaded.com.orbitz.consul.option.TransactionOptions;
import com.logicalclocks.shaded.com.orbitz.consul.util.Jackson;
import com.logicalclocks.shaded.com.orbitz.consul.util.Strings;
import com.logicalclocks.shaded.okhttp3.MediaType;
import com.logicalclocks.shaded.okhttp3.RequestBody;
import com.logicalclocks.shaded.org.apache.commons.lang3.StringUtils;
import com.logicalclocks.shaded.retrofit2.Call;
import com.logicalclocks.shaded.retrofit2.Retrofit;
import com.logicalclocks.shaded.retrofit2.http.Body;
import com.logicalclocks.shaded.retrofit2.http.DELETE;
import com.logicalclocks.shaded.retrofit2.http.GET;
import com.logicalclocks.shaded.retrofit2.http.Headers;
import com.logicalclocks.shaded.retrofit2.http.PUT;
import com.logicalclocks.shaded.retrofit2.http.Path;
import com.logicalclocks.shaded.retrofit2.http.QueryMap;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class KeyValueClient
extends BaseClient {
    private static String CLIENT_NAME = "keyvalue";
    public static final int NOT_FOUND_404 = 404;
    private final Api api;

    KeyValueClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = retrofit.create(Api.class);
    }

    KeyValueClient(Api api, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = api;
    }

    public Optional<Value> getValue(String key) {
        return this.getValue(key, QueryOptions.BLANK);
    }

    public Optional<ConsulResponse<Value>> getConsulResponseWithValue(String key) {
        return this.getConsulResponseWithValue(key, QueryOptions.BLANK);
    }

    public Optional<Value> getValue(String key, QueryOptions queryOptions) {
        try {
            return this.getSingleValue(this.http.extract(this.api.getValue(Strings.trimLeadingSlash(key), queryOptions.toQuery()), 404));
        }
        catch (ConsulException ignored) {
            if (ignored.getCode() != 404) {
                throw ignored;
            }
            return Optional.empty();
        }
    }

    public Optional<ConsulResponse<Value>> getConsulResponseWithValue(String key, QueryOptions queryOptions) {
        block3: {
            try {
                ConsulResponse<List<Value>> consulResponse = this.http.extractConsulResponse(this.api.getValue(Strings.trimLeadingSlash(key), queryOptions.toQuery()), 404);
                Optional<Value> consulValue = this.getSingleValue(consulResponse.getResponse());
                if (consulValue.isPresent()) {
                    ConsulResponse<Value> result = new ConsulResponse<Value>(consulValue.get(), consulResponse.getLastContact(), consulResponse.isKnownLeader(), consulResponse.getIndex(), consulResponse.getCacheReponseInfo());
                    return Optional.of(result);
                }
            }
            catch (ConsulException ignored) {
                if (ignored.getCode() == 404) break block3;
                throw ignored;
            }
        }
        return Optional.empty();
    }

    public void getValue(String key, QueryOptions queryOptions, final ConsulResponseCallback<Optional<Value>> callback) {
        ConsulResponseCallback<List<Value>> wrapper = new ConsulResponseCallback<List<Value>>(){

            @Override
            public void onComplete(ConsulResponse<List<Value>> consulResponse) {
                callback.onComplete(new ConsulResponse<Optional>(KeyValueClient.this.getSingleValue(consulResponse.getResponse()), consulResponse.getLastContact(), consulResponse.isKnownLeader(), consulResponse.getIndex(), consulResponse.getCacheReponseInfo()));
            }

            @Override
            public void onFailure(Throwable throwable) {
                callback.onFailure(throwable);
            }
        };
        this.http.extractConsulResponse(this.api.getValue(Strings.trimLeadingSlash(key), queryOptions.toQuery()), wrapper, 404);
    }

    private Optional<Value> getSingleValue(List<Value> values) {
        return values != null && values.size() != 0 ? Optional.of(values.get(0)) : Optional.empty();
    }

    public List<Value> getValues(String key) {
        return this.getValues(key, QueryOptions.BLANK);
    }

    public ConsulResponse<List<Value>> getConsulResponseWithValues(String key) {
        return this.getConsulResponseWithValues(key, QueryOptions.BLANK);
    }

    public List<Value> getValues(String key, QueryOptions queryOptions) {
        Map<String, Object> query = queryOptions.toQuery();
        query.put("recurse", "true");
        List<Value> result = this.http.extract(this.api.getValue(Strings.trimLeadingSlash(key), query), 404);
        return result == null ? Collections.emptyList() : result;
    }

    public ConsulResponse<List<Value>> getConsulResponseWithValues(String key, QueryOptions queryOptions) {
        Map<String, Object> query = queryOptions.toQuery();
        query.put("recurse", "true");
        return this.http.extractConsulResponse(this.api.getValue(Strings.trimLeadingSlash(key), query), 404);
    }

    public void getValues(String key, QueryOptions queryOptions, ConsulResponseCallback<List<Value>> callback) {
        Map<String, Object> query = queryOptions.toQuery();
        query.put("recurse", "true");
        this.http.extractConsulResponse(this.api.getValue(Strings.trimLeadingSlash(key), query), callback, 404);
    }

    public Optional<String> getValueAsString(String key) {
        return this.getValueAsString(key, Charset.defaultCharset());
    }

    public Optional<String> getValueAsString(String key, Charset charset) {
        return this.getValue(key).flatMap(v -> v.getValueAsString(charset));
    }

    public List<String> getValuesAsString(String key) {
        return this.getValuesAsString(key, Charset.defaultCharset());
    }

    public List<String> getValuesAsString(String key, Charset charset) {
        ArrayList<String> result = new ArrayList<String>();
        for (Value value : this.getValues(key)) {
            value.getValueAsString(charset).ifPresent(result::add);
        }
        return result;
    }

    public boolean putValue(String key) {
        return this.putValue(key, null, 0L, PutOptions.BLANK, Charset.defaultCharset());
    }

    public boolean putValue(String key, String value) {
        return this.putValue(key, value, 0L, PutOptions.BLANK);
    }

    public boolean putValue(String key, String value, Charset charset) {
        return this.putValue(key, value, 0L, PutOptions.BLANK, charset);
    }

    public boolean putValue(String key, String value, long flags) {
        return this.putValue(key, value, flags, PutOptions.BLANK);
    }

    public boolean putValue(String key, String value, long flags, Charset charset) {
        return this.putValue(key, value, flags, PutOptions.BLANK, charset);
    }

    public boolean putValue(String key, String value, long flags, PutOptions putOptions) {
        return this.putValue(key, value, flags, putOptions, Charset.defaultCharset());
    }

    public boolean putValue(String key, String value, long flags, PutOptions putOptions, Charset charset) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(key), "Key must be defined");
        Map<String, Object> query = putOptions.toQuery();
        if (flags != 0L) {
            query.put("flags", UnsignedLongs.toString(flags));
        }
        if (value == null) {
            return this.http.extract(this.api.putValue(Strings.trimLeadingSlash(key), query), new Integer[0]);
        }
        return this.http.extract(this.api.putValue(Strings.trimLeadingSlash(key), RequestBody.create(MediaType.parse("text/plain; charset=" + charset.name()), value), query), new Integer[0]);
    }

    public boolean putValue(String key, byte[] value, long flags, PutOptions putOptions) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(key), "Key must be defined");
        Map<String, Object> query = putOptions.toQuery();
        if (flags != 0L) {
            query.put("flags", UnsignedLongs.toString(flags));
        }
        if (value == null) {
            return this.http.extract(this.api.putValue(Strings.trimLeadingSlash(key), query), new Integer[0]);
        }
        return this.http.extract(this.api.putValue(Strings.trimLeadingSlash(key), RequestBody.create(MediaType.parse("application/octet-stream"), value), query), new Integer[0]);
    }

    public List<String> getKeys(String key) {
        return this.getKeys(key, QueryOptions.BLANK);
    }

    public List<String> getKeys(String key, QueryOptions queryOptions) {
        Map<String, Object> query = queryOptions.toQuery();
        query.put("keys", "true");
        return this.http.extract(this.api.getKeys(Strings.trimLeadingSlash(key), query), new Integer[0]);
    }

    public void deleteKey(String key) {
        this.deleteKey(key, DeleteOptions.BLANK);
    }

    public void deleteKeys(String key) {
        this.deleteKey(key, DeleteOptions.RECURSE);
    }

    public void deleteKey(String key, DeleteOptions deleteOptions) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(key), "Key must be defined");
        Map<String, Object> query = deleteOptions.toQuery();
        this.http.handle(this.api.deleteValues(Strings.trimLeadingSlash(key), query), new Integer[0]);
    }

    public boolean acquireLock(String key, String session) {
        return this.acquireLock(key, "", session);
    }

    public boolean acquireLock(String key, String value, String session) {
        return this.putValue(key, value, 0L, (PutOptions)ImmutablePutOptions.builder().acquire(session).build());
    }

    public Optional<String> getSession(String key) {
        return this.getValue(key).flatMap(Value::getSession);
    }

    public boolean releaseLock(String key, String sessionId) {
        return this.putValue(key, "", 0L, (PutOptions)ImmutablePutOptions.builder().release(sessionId).build());
    }

    public ConsulResponse<TxResponse> performTransaction(Operation ... operations) {
        ImmutableTransactionOptions immutableTransactionOptions = ImmutableTransactionOptions.builder().consistencyMode(ConsistencyMode.DEFAULT).build();
        return this.performTransaction(immutableTransactionOptions, operations);
    }

    @Deprecated
    public ConsulResponse<TxResponse> performTransaction(ConsistencyMode consistency, Operation ... operations) {
        ImmutableMap<String, Object> query = consistency == ConsistencyMode.DEFAULT ? ImmutableMap.of() : ImmutableMap.of(consistency.toParam().get(), "true");
        try {
            return this.http.extractConsulResponse(this.api.performTransaction(RequestBody.create(MediaType.parse("application/json"), Jackson.MAPPER.writeValueAsString(KeyValueClient.kv(operations))), query), new Integer[0]);
        }
        catch (JsonProcessingException e) {
            throw new ConsulException(e);
        }
    }

    public ConsulResponse<TxResponse> performTransaction(TransactionOptions transactionOptions, Operation ... operations) {
        Map<String, Object> query = transactionOptions.toQuery();
        try {
            return this.http.extractConsulResponse(this.api.performTransaction(RequestBody.create(MediaType.parse("application/json"), Jackson.MAPPER.writeValueAsString(KeyValueClient.kv(operations))), query), new Integer[0]);
        }
        catch (JsonProcessingException e) {
            throw new ConsulException(e);
        }
    }

    static Kv[] kv(Operation ... operations) {
        Kv[] kvs = new Kv[operations.length];
        for (int i = 0; i < operations.length; ++i) {
            kvs[i] = new Kv(operations[i]);
        }
        return kvs;
    }

    static class Kv {
        private Operation kv;

        private Kv(Operation operation) {
            this.kv = operation;
        }

        public Operation getKv() {
            return this.kv;
        }
    }

    @VisibleForTesting
    public static interface Api {
        @GET(value="kv/{key}")
        public Call<List<Value>> getValue(@Path(value="key") String var1, @QueryMap Map<String, Object> var2);

        @GET(value="kv/{key}")
        public Call<List<String>> getKeys(@Path(value="key") String var1, @QueryMap Map<String, Object> var2);

        @PUT(value="kv/{key}")
        public Call<Boolean> putValue(@Path(value="key") String var1, @QueryMap Map<String, Object> var2);

        @PUT(value="kv/{key}")
        public Call<Boolean> putValue(@Path(value="key") String var1, @Body RequestBody var2, @QueryMap Map<String, Object> var3);

        @DELETE(value="kv/{key}")
        public Call<Void> deleteValues(@Path(value="key") String var1, @QueryMap Map<String, Object> var2);

        @PUT(value="txn")
        @Headers(value={"Content-Type: application/json"})
        public Call<TxResponse> performTransaction(@Body RequestBody var1, @QueryMap Map<String, Object> var2);
    }
}

