/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.com.orbitz.consul;

import com.logicalclocks.shaded.com.google.common.collect.ImmutableMap;
import com.logicalclocks.shaded.com.orbitz.consul.BaseClient;
import com.logicalclocks.shaded.com.orbitz.consul.async.Callback;
import com.logicalclocks.shaded.com.orbitz.consul.config.ClientConfig;
import com.logicalclocks.shaded.com.orbitz.consul.model.query.PreparedQuery;
import com.logicalclocks.shaded.com.orbitz.consul.model.query.QueryId;
import com.logicalclocks.shaded.com.orbitz.consul.model.query.QueryResults;
import com.logicalclocks.shaded.com.orbitz.consul.model.query.StoredQuery;
import com.logicalclocks.shaded.com.orbitz.consul.monitoring.ClientEventCallback;
import com.logicalclocks.shaded.com.orbitz.consul.option.QueryOptions;
import com.logicalclocks.shaded.retrofit2.Call;
import com.logicalclocks.shaded.retrofit2.Retrofit;
import com.logicalclocks.shaded.retrofit2.http.Body;
import com.logicalclocks.shaded.retrofit2.http.GET;
import com.logicalclocks.shaded.retrofit2.http.POST;
import com.logicalclocks.shaded.retrofit2.http.Path;
import com.logicalclocks.shaded.retrofit2.http.QueryMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PreparedQueryClient
extends BaseClient {
    private static String CLIENT_NAME = "preparedquery";
    private final Api api;

    PreparedQueryClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = retrofit.create(Api.class);
    }

    public String createPreparedQuery(PreparedQuery preparedQuery) {
        return this.createPreparedQuery(preparedQuery, null);
    }

    public String createPreparedQuery(PreparedQuery preparedQuery, String dc) {
        return this.http.extract(this.api.createPreparedQuery(preparedQuery, this.dcQuery(dc)), new Integer[0]).getId();
    }

    private Map<String, String> dcQuery(String dc) {
        return dc != null ? ImmutableMap.of("dc", dc) : Collections.emptyMap();
    }

    public List<StoredQuery> getPreparedQueries() {
        return this.getPreparedQueries(null);
    }

    public List<StoredQuery> getPreparedQueries(String dc) {
        return this.http.extract(this.api.getPreparedQueries(this.dcQuery(dc)), new Integer[0]);
    }

    public Optional<StoredQuery> getPreparedQuery(String id) {
        return this.getPreparedQuery(id, null);
    }

    public Optional<StoredQuery> getPreparedQuery(String id, String dc) {
        List<StoredQuery> result = this.http.extract(this.api.getPreparedQuery(id, this.dcQuery(dc)), new Integer[0]);
        return result.isEmpty() ? Optional.empty() : Optional.of(result.get(0));
    }

    public QueryResults execute(String nameOrId) {
        return this.http.extract(this.api.execute(nameOrId, Collections.emptyMap()), new Integer[0]);
    }

    public void execute(String nameOrId, QueryOptions options, Callback<QueryResults> callback) {
        this.http.extractBasicResponse(this.api.execute(nameOrId, options.toQuery()), callback, new Integer[0]);
    }

    static interface Api {
        @GET(value="query")
        public Call<List<StoredQuery>> getPreparedQueries(@QueryMap Map<String, String> var1);

        @POST(value="query")
        public Call<QueryId> createPreparedQuery(@Body PreparedQuery var1, @QueryMap Map<String, String> var2);

        @GET(value="query/{id}")
        public Call<List<StoredQuery>> getPreparedQuery(@Path(value="id") String var1, @QueryMap Map<String, String> var2);

        @GET(value="query/{nameOrId}/execute")
        public Call<QueryResults> execute(@Path(value="nameOrId") String var1, @QueryMap Map<String, Object> var2);
    }
}

