/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.com.orbitz.consul.cache;

import com.logicalclocks.shaded.com.google.common.base.Strings;
import com.logicalclocks.shaded.com.orbitz.consul.config.CacheConfig;
import com.logicalclocks.shaded.okhttp3.Interceptor;
import com.logicalclocks.shaded.okhttp3.Request;
import com.logicalclocks.shaded.okhttp3.Response;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeoutInterceptor.class);
    private CacheConfig config;

    public TimeoutInterceptor(CacheConfig config) {
        this.config = config;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        String waitQuery;
        Duration waitDuration;
        Request request = chain.request();
        int readTimeout = chain.readTimeoutMillis();
        if (request.url().encodedPath().contains("snapshot")) {
            readTimeout = (int)Duration.ofHours(1L).toMillis();
        } else if (this.config.isTimeoutAutoAdjustmentEnabled() && (waitDuration = this.parseWaitQuery(waitQuery = request.url().queryParameter("wait"))) != null) {
            int waitDurationMs = (int)waitDuration.toMillis();
            int readTimeoutConfigMargin = (int)this.config.getTimeoutAutoAdjustmentMargin().toMillis();
            int readTimeoutRequiredMargin = (int)Math.ceil((double)waitDurationMs / 16.0);
            readTimeout = waitDurationMs + readTimeoutRequiredMargin + readTimeoutConfigMargin;
        }
        return chain.withReadTimeout(readTimeout, TimeUnit.MILLISECONDS).proceed(request);
    }

    private Duration parseWaitQuery(String query) {
        if (Strings.isNullOrEmpty(query)) {
            return null;
        }
        Duration wait = null;
        try {
            if (query.contains("m")) {
                wait = Duration.ofMinutes(Integer.valueOf(query.replace("m", "")).intValue());
            } else if (query.contains("s")) {
                wait = Duration.ofSeconds(Integer.valueOf(query.replace("s", "")).intValue());
            }
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Error while extracting wait duration from query parameters: %s", query));
        }
        return wait;
    }
}

