/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.com.orbitz.consul.model.acl;

import com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.logicalclocks.shaded.com.google.common.base.MoreObjects;
import com.logicalclocks.shaded.com.google.common.collect.ImmutableList;
import com.logicalclocks.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.logicalclocks.shaded.com.orbitz.consul.model.acl.Policy;
import com.logicalclocks.shaded.org.immutables.value.Generated;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Policy", generator="Immutables")
@Immutable
public final class ImmutablePolicy
extends Policy {
    @Nullable
    private final String id;
    @Nullable
    private final String description;
    private final String name;
    @Nullable
    private final String rules;
    @Nullable
    private final List<String> datacenters;

    private ImmutablePolicy(@Nullable String id, @Nullable String description, String name, @Nullable String rules, @Nullable List<String> datacenters) {
        this.id = id;
        this.description = description;
        this.name = name;
        this.rules = rules;
        this.datacenters = datacenters;
    }

    @Override
    @JsonProperty(value="ID")
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="Description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Rules")
    public Optional<String> rules() {
        return Optional.ofNullable(this.rules);
    }

    @Override
    @JsonProperty(value="Datacenters")
    @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
    public Optional<List<String>> datacenters() {
        return Optional.ofNullable(this.datacenters);
    }

    public final ImmutablePolicy withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutablePolicy(newValue, this.description, this.name, this.rules, this.datacenters);
    }

    public final ImmutablePolicy withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutablePolicy(value, this.description, this.name, this.rules, this.datacenters);
    }

    public final ImmutablePolicy withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutablePolicy(this.id, newValue, this.name, this.rules, this.datacenters);
    }

    public final ImmutablePolicy withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutablePolicy(this.id, value, this.name, this.rules, this.datacenters);
    }

    public final ImmutablePolicy withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutablePolicy(this.id, this.description, newValue, this.rules, this.datacenters);
    }

    public final ImmutablePolicy withRules(String value) {
        String newValue = Objects.requireNonNull(value, "rules");
        if (Objects.equals(this.rules, newValue)) {
            return this;
        }
        return new ImmutablePolicy(this.id, this.description, this.name, newValue, this.datacenters);
    }

    public final ImmutablePolicy withRules(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.rules, value)) {
            return this;
        }
        return new ImmutablePolicy(this.id, this.description, this.name, value, this.datacenters);
    }

    public final ImmutablePolicy withDatacenters(List<String> value) {
        List<String> newValue = Objects.requireNonNull(value, "datacenters");
        if (this.datacenters == newValue) {
            return this;
        }
        return new ImmutablePolicy(this.id, this.description, this.name, this.rules, newValue);
    }

    public final ImmutablePolicy withDatacenters(Optional<? extends List<String>> optional) {
        List value = optional.orElse(null);
        if (this.datacenters == value) {
            return this;
        }
        return new ImmutablePolicy(this.id, this.description, this.name, this.rules, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePolicy && this.equalTo((ImmutablePolicy)another);
    }

    private boolean equalTo(ImmutablePolicy another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.description, another.description) && this.name.equals(another.name) && Objects.equals(this.rules, another.rules) && Objects.equals(this.datacenters, another.datacenters);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.id);
        h2 += (h2 << 5) + Objects.hashCode(this.description);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.rules);
        h2 += (h2 << 5) + Objects.hashCode(this.datacenters);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Policy").omitNullValues().add("id", this.id).add("description", this.description).add("name", this.name).add("rules", this.rules).add("datacenters", this.datacenters).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePolicy fromJson(Json json) {
        Builder builder = ImmutablePolicy.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.rules != null) {
            builder.rules(json.rules);
        }
        if (json.datacenters != null) {
            builder.datacenters(json.datacenters);
        }
        return builder.build();
    }

    public static ImmutablePolicy copyOf(Policy instance) {
        if (instance instanceof ImmutablePolicy) {
            return (ImmutablePolicy)instance;
        }
        return ImmutablePolicy.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Policy", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private String description;
        @Nullable
        private String name;
        @Nullable
        private String rules;
        @Nullable
        private List<String> datacenters;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Policy instance) {
            Optional<List<String>> datacentersOptional;
            Optional<String> descriptionOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            if ((descriptionOptional = instance.description()).isPresent()) {
                this.description(descriptionOptional);
            }
            this.name(instance.name());
            Optional<String> rulesOptional = instance.rules();
            if (rulesOptional.isPresent()) {
                this.rules(rulesOptional);
            }
            if ((datacentersOptional = instance.datacenters()).isPresent()) {
                this.datacenters(datacentersOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="Description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rules(String rules) {
            this.rules = Objects.requireNonNull(rules, "rules");
            return this;
        }

        @JsonProperty(value="Rules")
        @CanIgnoreReturnValue
        public final Builder rules(Optional<String> rules) {
            this.rules = rules.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenters(List<String> datacenters) {
            this.datacenters = Objects.requireNonNull(datacenters, "datacenters");
            return this;
        }

        @JsonProperty(value="Datacenters")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        @CanIgnoreReturnValue
        public final Builder datacenters(Optional<? extends List<String>> datacenters) {
            this.datacenters = datacenters.orElse(null);
            return this;
        }

        public ImmutablePolicy build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePolicy(this.id, this.description, this.name, this.rules, this.datacenters);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Policy, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Policy", generator="Immutables")
    static final class Json
    extends Policy {
        @Nullable
        Optional<String> id = Optional.empty();
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        String name;
        @Nullable
        Optional<String> rules = Optional.empty();
        @Nullable
        Optional<List<String>> datacenters = Optional.empty();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="Description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Rules")
        public void setRules(Optional<String> rules) {
            this.rules = rules;
        }

        @JsonProperty(value="Datacenters")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        public void setDatacenters(Optional<List<String>> datacenters) {
            this.datacenters = datacenters;
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> rules() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> datacenters() {
            throw new UnsupportedOperationException();
        }
    }
}

