/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.com.orbitz.consul.option;

import com.logicalclocks.shaded.com.google.common.base.MoreObjects;
import com.logicalclocks.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.logicalclocks.shaded.com.orbitz.consul.option.ConsistencyMode;
import com.logicalclocks.shaded.com.orbitz.consul.option.TransactionOptions;
import com.logicalclocks.shaded.org.immutables.value.Generated;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransactionOptions", generator="Immutables")
@Immutable
public final class ImmutableTransactionOptions
extends TransactionOptions {
    @Nullable
    private final String datacenter;
    private final ConsistencyMode consistencyMode;

    private ImmutableTransactionOptions(Builder builder) {
        this.datacenter = builder.datacenter;
        this.consistencyMode = builder.consistencyMode != null ? builder.consistencyMode : Objects.requireNonNull(super.getConsistencyMode(), "consistencyMode");
    }

    private ImmutableTransactionOptions(@Nullable String datacenter, ConsistencyMode consistencyMode) {
        this.datacenter = datacenter;
        this.consistencyMode = consistencyMode;
    }

    @Override
    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    @Override
    public ConsistencyMode getConsistencyMode() {
        return this.consistencyMode;
    }

    public final ImmutableTransactionOptions withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return new ImmutableTransactionOptions(newValue, this.consistencyMode);
    }

    public final ImmutableTransactionOptions withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return new ImmutableTransactionOptions(value, this.consistencyMode);
    }

    public final ImmutableTransactionOptions withConsistencyMode(ConsistencyMode value) {
        if (this.consistencyMode == value) {
            return this;
        }
        ConsistencyMode newValue = Objects.requireNonNull(value, "consistencyMode");
        return new ImmutableTransactionOptions(this.datacenter, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactionOptions && this.equalTo((ImmutableTransactionOptions)another);
    }

    private boolean equalTo(ImmutableTransactionOptions another) {
        return Objects.equals(this.datacenter, another.datacenter) && this.consistencyMode.equals(another.consistencyMode);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.datacenter);
        h2 += (h2 << 5) + this.consistencyMode.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TransactionOptions").omitNullValues().add("datacenter", this.datacenter).add("consistencyMode", this.consistencyMode).toString();
    }

    public static ImmutableTransactionOptions copyOf(TransactionOptions instance) {
        if (instance instanceof ImmutableTransactionOptions) {
            return (ImmutableTransactionOptions)instance;
        }
        return ImmutableTransactionOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransactionOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String datacenter;
        @Nullable
        private ConsistencyMode consistencyMode;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TransactionOptions instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> datacenterOptional = instance.getDatacenter();
            if (datacenterOptional.isPresent()) {
                this.datacenter(datacenterOptional);
            }
            this.consistencyMode(instance.getConsistencyMode());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder consistencyMode(ConsistencyMode consistencyMode) {
            this.consistencyMode = Objects.requireNonNull(consistencyMode, "consistencyMode");
            return this;
        }

        public ImmutableTransactionOptions build() {
            return new ImmutableTransactionOptions(this);
        }
    }
}

