/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.com.orbitz.consul.util.failover.strategy;

import com.logicalclocks.shaded.com.google.common.net.HostAndPort;
import com.logicalclocks.shaded.com.orbitz.consul.util.failover.strategy.ConsulFailoverStrategy;
import com.logicalclocks.shaded.okhttp3.HttpUrl;
import com.logicalclocks.shaded.okhttp3.Request;
import com.logicalclocks.shaded.okhttp3.Response;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class BlacklistingConsulFailoverStrategy
implements ConsulFailoverStrategy {
    private Map<HostAndPort, Instant> blacklist = Collections.synchronizedMap(new HashMap());
    private Collection<HostAndPort> targets;
    private long timeout;

    public BlacklistingConsulFailoverStrategy(Collection<HostAndPort> targets, long timeout) {
        this.targets = targets;
        this.timeout = timeout;
    }

    @Override
    public Optional<Request> computeNextStage(Request previousRequest, Response previousResponse) {
        HostAndPort initialTarget = this.fromRequest(previousRequest);
        if (previousResponse != null && !previousResponse.isSuccessful() && previousResponse.code() != 404) {
            this.blacklist.put(initialTarget, Instant.now());
        }
        if (this.blacklist.containsKey(initialTarget)) {
            Optional<HostAndPort> optionalNext = this.targets.stream().filter(target -> {
                if (this.blacklist.containsKey(target)) {
                    Instant blacklistWhen = this.blacklist.get(target);
                    if (!Duration.between(blacklistWhen, Instant.now()).minusMillis(this.timeout).isNegative()) {
                        this.blacklist.remove(target);
                        return true;
                    }
                    return false;
                }
                return true;
            }).findAny();
            if (!optionalNext.isPresent()) {
                return Optional.empty();
            }
            HostAndPort next = optionalNext.get();
            HttpUrl nextURL = previousRequest.url().newBuilder().host(next.getHost()).port(next.getPort()).build();
            return Optional.ofNullable(previousRequest.newBuilder().url(nextURL).build());
        }
        HttpUrl nextURL = previousRequest.url().newBuilder().host(initialTarget.getHost()).port(initialTarget.getPort()).build();
        return Optional.ofNullable(previousRequest.newBuilder().url(nextURL).build());
    }

    @Override
    public boolean isRequestViable(Request current) {
        return this.targets.size() > this.blacklist.size() || !this.blacklist.containsKey(this.fromRequest(current));
    }

    @Override
    public void markRequestFailed(Request current) {
        this.blacklist.put(this.fromRequest(current), Instant.now());
    }

    private HostAndPort fromRequest(Request request) {
        return HostAndPort.fromParts(request.url().host(), request.url().port());
    }
}

