/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.org.xbill.DNS;

import com.logicalclocks.shaded.org.xbill.DNS.Address;
import com.logicalclocks.shaded.org.xbill.DNS.Compression;
import com.logicalclocks.shaded.org.xbill.DNS.DNSInput;
import com.logicalclocks.shaded.org.xbill.DNS.DNSOutput;
import com.logicalclocks.shaded.org.xbill.DNS.Name;
import com.logicalclocks.shaded.org.xbill.DNS.Record;
import com.logicalclocks.shaded.org.xbill.DNS.Tokenizer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ARecord
extends Record {
    private int addr;

    ARecord() {
    }

    private static int fromArray(byte[] array) {
        return (array[0] & 0xFF) << 24 | (array[1] & 0xFF) << 16 | (array[2] & 0xFF) << 8 | array[3] & 0xFF;
    }

    private static byte[] toArray(int addr) {
        byte[] bytes = new byte[]{(byte)(addr >>> 24 & 0xFF), (byte)(addr >>> 16 & 0xFF), (byte)(addr >>> 8 & 0xFF), (byte)(addr & 0xFF)};
        return bytes;
    }

    public ARecord(Name name, int dclass, long ttl, InetAddress address) {
        super(name, 1, dclass, ttl);
        if (Address.familyOf(address) != 1) {
            throw new IllegalArgumentException("invalid IPv4 address");
        }
        this.addr = ARecord.fromArray(address.getAddress());
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.addr = ARecord.fromArray(in.readByteArray(4));
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.addr = ARecord.fromArray(st.getAddressBytes(1));
    }

    @Override
    String rrToString() {
        return Address.toDottedQuad(ARecord.toArray(this.addr));
    }

    public InetAddress getAddress() {
        try {
            if (this.name == null) {
                return InetAddress.getByAddress(ARecord.toArray(this.addr));
            }
            return InetAddress.getByAddress(this.name.toString(), ARecord.toArray(this.addr));
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU32((long)this.addr & 0xFFFFFFFFL);
    }
}

