/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.org.xbill.DNS;

import com.logicalclocks.shaded.org.xbill.DNS.WireParseException;
import java.nio.ByteBuffer;

public class DNSInput {
    private ByteBuffer byteBuffer;
    private int saved_pos;
    private int saved_end;

    public DNSInput(byte[] input) {
        this.byteBuffer = ByteBuffer.wrap(input);
        this.saved_pos = -1;
        this.saved_end = -1;
    }

    public DNSInput(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.saved_pos = -1;
        this.saved_end = -1;
    }

    public int current() {
        return this.byteBuffer.position();
    }

    public int remaining() {
        return this.byteBuffer.remaining();
    }

    private void require(int n) throws WireParseException {
        if (n > this.remaining()) {
            throw new WireParseException("end of input");
        }
    }

    public void setActive(int len) {
        if (len > this.byteBuffer.capacity() - this.byteBuffer.position()) {
            throw new IllegalArgumentException("cannot set active region past end of input");
        }
        this.byteBuffer.limit(this.byteBuffer.position() + len);
    }

    public void clearActive() {
        this.byteBuffer.limit(this.byteBuffer.capacity());
    }

    public int saveActive() {
        return this.byteBuffer.limit();
    }

    public void restoreActive(int pos) {
        if (pos > this.byteBuffer.capacity()) {
            throw new IllegalArgumentException("cannot set active region past end of input");
        }
        this.byteBuffer.limit(this.byteBuffer.position());
    }

    public void jump(int index) {
        if (index >= this.byteBuffer.capacity()) {
            throw new IllegalArgumentException("cannot jump past end of input");
        }
        this.byteBuffer.position(index);
        this.byteBuffer.limit(this.byteBuffer.capacity());
    }

    public void save() {
        this.saved_pos = this.byteBuffer.position();
        this.saved_end = this.byteBuffer.limit();
    }

    public void restore() {
        if (this.saved_pos < 0) {
            throw new IllegalStateException("no previous state");
        }
        this.byteBuffer.position(this.saved_pos);
        this.byteBuffer.limit(this.saved_end);
        this.saved_pos = -1;
        this.saved_end = -1;
    }

    public int readU8() throws WireParseException {
        this.require(1);
        return this.byteBuffer.get() & 0xFF;
    }

    public int readU16() throws WireParseException {
        this.require(2);
        return this.byteBuffer.getShort() & 0xFFFF;
    }

    public long readU32() throws WireParseException {
        this.require(4);
        return (long)this.byteBuffer.getInt() & 0xFFFFFFFFL;
    }

    public void readByteArray(byte[] b, int off, int len) throws WireParseException {
        this.require(len);
        this.byteBuffer.get(b, off, len);
    }

    public byte[] readByteArray(int len) throws WireParseException {
        this.require(len);
        byte[] out = new byte[len];
        this.byteBuffer.get(out, 0, len);
        return out;
    }

    public byte[] readByteArray() {
        int len = this.remaining();
        byte[] out = new byte[len];
        this.byteBuffer.get(out, 0, len);
        return out;
    }

    public byte[] readCountedString() throws WireParseException {
        int len = this.readU8();
        return this.readByteArray(len);
    }
}

