/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.org.xbill.DNS;

import com.logicalclocks.shaded.org.xbill.DNS.Compression;
import com.logicalclocks.shaded.org.xbill.DNS.DNSInput;
import com.logicalclocks.shaded.org.xbill.DNS.DNSOutput;
import com.logicalclocks.shaded.org.xbill.DNS.Name;
import com.logicalclocks.shaded.org.xbill.DNS.Record;
import com.logicalclocks.shaded.org.xbill.DNS.Tokenizer;
import java.io.IOException;

public class NULLRecord
extends Record {
    private byte[] data;

    NULLRecord() {
    }

    public NULLRecord(Name name, int dclass, long ttl, byte[] data) {
        super(name, 10, dclass, ttl);
        if (data.length > 65535) {
            throw new IllegalArgumentException("data must be <65536 bytes");
        }
        this.data = data;
    }

    @Override
    void rrFromWire(DNSInput in) {
        this.data = in.readByteArray();
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        throw st.exception("no defined text format for NULL records");
    }

    @Override
    String rrToString() {
        return NULLRecord.unknownToString(this.data);
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.data);
    }
}

