/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.org.xbill.DNS;

import com.logicalclocks.shaded.org.xbill.DNS.EDNSOption;
import com.logicalclocks.shaded.org.xbill.DNS.Message;
import com.logicalclocks.shaded.org.xbill.DNS.ResolverListener;
import com.logicalclocks.shaded.org.xbill.DNS.TSIG;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public interface Resolver {
    public void setPort(int var1);

    public void setTCP(boolean var1);

    public void setIgnoreTruncation(boolean var1);

    default public void setEDNS(int version) {
        this.setEDNS(version, 0, 0, Collections.emptyList());
    }

    public void setEDNS(int var1, int var2, int var3, List<EDNSOption> var4);

    default public void setEDNS(int version, int payloadSize, int flags, EDNSOption ... options) {
        this.setEDNS(version, payloadSize, flags, options == null ? Collections.emptyList() : Arrays.asList(options));
    }

    public void setTSIGKey(TSIG var1);

    @Deprecated
    default public void setTimeout(int secs, int msecs) {
        this.setTimeout(Duration.ofMillis(secs * 1000 + msecs));
    }

    @Deprecated
    default public void setTimeout(int secs) {
        this.setTimeout(Duration.ofSeconds(secs));
    }

    public void setTimeout(Duration var1);

    default public Duration getTimeout() {
        return Duration.ofSeconds(10L);
    }

    default public Message send(Message query) throws IOException {
        try {
            CompletableFuture<Message> result = this.sendAsync(query).toCompletableFuture();
            return result.get(this.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
        catch (TimeoutException e) {
            throw new SocketTimeoutException(e.getMessage());
        }
    }

    default public CompletionStage<Message> sendAsync(Message query) {
        final CompletableFuture<Message> f = new CompletableFuture<Message>();
        this.sendAsync(query, new ResolverListener(){

            @Override
            public void receiveMessage(Object id, Message m3) {
                f.complete(m3);
            }

            @Override
            public void handleException(Object id, Exception e) {
                f.completeExceptionally(e);
            }
        });
        return f;
    }

    @Deprecated
    default public Object sendAsync(Message query, ResolverListener listener) {
        Object id = new Object();
        CompletionStage<Message> f = this.sendAsync(query);
        f.handleAsync((result, throwable) -> {
            if (throwable != null) {
                Exception exception = throwable instanceof Exception ? (Exception)throwable : new Exception((Throwable)throwable);
                listener.handleException(id, exception);
                return null;
            }
            listener.receiveMessage(id, (Message)result);
            return null;
        });
        return id;
    }
}

