/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.org.xbill.DNS;

import com.logicalclocks.shaded.org.xbill.DNS.DNSInput;
import com.logicalclocks.shaded.org.xbill.DNS.DNSOutput;
import com.logicalclocks.shaded.org.xbill.DNS.EDNSOption;
import com.logicalclocks.shaded.org.xbill.DNS.WireParseException;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import java.util.OptionalInt;

public class TcpKeepaliveOption
extends EDNSOption {
    private OptionalInt timeout;
    private static final Duration UPPER_LIMIT = Duration.ofMillis(0x640000L);

    public TcpKeepaliveOption() {
        super(11);
        this.timeout = OptionalInt.empty();
    }

    public TcpKeepaliveOption(int t) {
        super(11);
        if (t < 0 || t > 65535) {
            throw new IllegalArgumentException("timeout must be betwee 0 and 65535");
        }
        this.timeout = OptionalInt.of(t);
    }

    public TcpKeepaliveOption(Duration t) {
        super(11);
        if (t.isNegative() || t.compareTo(UPPER_LIMIT) >= 0) {
            throw new IllegalArgumentException("timeout must be between 0 and 6553.6 seconds (exclusively)");
        }
        this.timeout = OptionalInt.of((int)t.toMillis() / 100);
    }

    public OptionalInt getTimeout() {
        return this.timeout;
    }

    public Optional<Duration> getTimeoutDuration() {
        return this.timeout.isPresent() ? Optional.of(Duration.ofMillis(this.timeout.getAsInt() * 100)) : Optional.empty();
    }

    @Override
    void optionFromWire(DNSInput in) throws IOException {
        int length = in.remaining();
        switch (length) {
            case 0: {
                this.timeout = OptionalInt.empty();
                break;
            }
            case 2: {
                this.timeout = OptionalInt.of(in.readU16());
                break;
            }
            default: {
                throw new WireParseException("invalid length (" + length + ") of the data in the edns_tcp_keepalive option");
            }
        }
    }

    @Override
    void optionToWire(DNSOutput out) {
        if (this.timeout.isPresent()) {
            out.writeU16(this.timeout.getAsInt());
        }
    }

    @Override
    String optionToString() {
        return this.timeout.isPresent() ? String.valueOf(this.timeout.getAsInt()) : "-";
    }
}

