/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.org.xbill.DNS.config;

import com.logicalclocks.shaded.org.xbill.DNS.config.BaseResolverConfigProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.StringTokenizer;

public class ResolvConfResolverConfigProvider
extends BaseResolverConfigProvider {
    private int ndots = 1;

    @Override
    public void initialize() {
        if (!this.tryParseResolveConf("/etc/resolv.conf")) {
            this.tryParseResolveConf("sys:/etc/resolv.cfg");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryParseResolveConf(String path) {
        Path p = Paths.get(path, new String[0]);
        if (!Files.exists(p, new LinkOption[0])) return false;
        try (InputStream in = Files.newInputStream(p, new OpenOption[0]);){
            this.parseResolvConf(in);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected void parseResolvConf(InputStream in) throws IOException {
        String resOptions;
        try (InputStreamReader isr = new InputStreamReader(in);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens()) continue;
                switch (st.nextToken()) {
                    case "nameserver": {
                        this.addServer(st.nextToken());
                        break;
                    }
                    case "domain": {
                        this.searchlist.clear();
                        if (!st.hasMoreTokens()) break;
                        this.addSearchPath(st.nextToken());
                        break;
                    }
                    case "search": {
                        this.searchlist.clear();
                        while (st.hasMoreTokens()) {
                            this.addSearchPath(st.nextToken());
                        }
                    }
                    case "options": {
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            if (!token.startsWith("ndots:")) continue;
                            this.ndots = this.parseNdots(token.substring(6));
                        }
                        break;
                    }
                }
            }
        }
        String localdomain = System.getenv("LOCALDOMAIN");
        if (localdomain != null && !localdomain.isEmpty()) {
            this.searchlist.clear();
            this.parseSearchPathList(localdomain, " ");
        }
        if ((resOptions = System.getenv("RES_OPTIONS")) != null && !resOptions.isEmpty()) {
            StringTokenizer st = new StringTokenizer(resOptions, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.startsWith("ndots:")) continue;
                this.ndots = this.parseNdots(token.substring(6));
            }
        }
    }

    private void addServer(String server) {
        if (this.nameservers.size() < 3) {
            this.addNameserver(new InetSocketAddress(server, 53));
        }
    }

    @Override
    public int ndots() {
        return this.ndots;
    }

    @Override
    public boolean isEnabled() {
        return !System.getProperty("os.name").contains("Windows") && !System.getProperty("java.specification.vendor").toLowerCase().contains("android");
    }
}

