/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.shaded.retrofit2.converter.jackson;

import com.logicalclocks.shaded.com.fasterxml.jackson.databind.JavaType;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.ObjectReader;
import com.logicalclocks.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import com.logicalclocks.shaded.okhttp3.RequestBody;
import com.logicalclocks.shaded.okhttp3.ResponseBody;
import com.logicalclocks.shaded.retrofit2.Converter;
import com.logicalclocks.shaded.retrofit2.Retrofit;
import com.logicalclocks.shaded.retrofit2.converter.jackson.JacksonRequestBodyConverter;
import com.logicalclocks.shaded.retrofit2.converter.jackson.JacksonResponseBodyConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public final class JacksonConverterFactory
extends Converter.Factory {
    private final ObjectMapper mapper;

    public static JacksonConverterFactory create() {
        return JacksonConverterFactory.create(new ObjectMapper());
    }

    public static JacksonConverterFactory create(ObjectMapper mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper == null");
        }
        return new JacksonConverterFactory(mapper);
    }

    private JacksonConverterFactory(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectReader reader = this.mapper.readerFor(javaType);
        return new JacksonResponseBodyConverter(reader);
    }

    @Override
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectWriter writer = this.mapper.writerFor(javaType);
        return new JacksonRequestBodyConverter(writer);
    }
}

