/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.KeyPart;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbOperation;
import com.mysql.ndbjtie.ndbapi.NdbTransaction;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class PartitionKeyImpl
implements PartitionKey {
    static final I18NHelper local = I18NHelper.getInstance(PartitionKeyImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(PartitionKeyImpl.class);
    private static PartitionKeyImpl theInstance = new PartitionKeyImpl();
    private List<KeyPartBuilder> keyPartBuilders = new ArrayList<KeyPartBuilder>();
    private List<KeyPart> keyParts = new ArrayList<KeyPart>();
    private String tableName = null;
    private int partitionId;

    PartitionKeyImpl() {
    }

    @Override
    public void addIntKey(final Column column, final int n) {
        this.keyPartBuilders.add(new KeyPartBuilderImpl(4){

            @Override
            public void addKeyPart(DbImpl.BufferManager bufferManager) {
                this.bufferManager = bufferManager;
                this.buffer = bufferManager.borrowPartitionKeyPartBuffer(this.length);
                if (this.buffer.capacity() < this.length || this.buffer.position() != 0 || this.buffer.position() + this.length > this.buffer.limit()) {
                    System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!PartitionKeyImpl.addIntKey.addKeyPart() got buffer for length: " + this.length + " buffer: " + this.buffer.capacity() + " " + this.buffer.position() + " " + this.buffer.limit());
                    this.buffer.position(0);
                    this.buffer.limit(this.length);
                }
                Utility.convertValue(this.buffer, column, n);
                KeyPart keyPart = new KeyPart(this.buffer, this.buffer.limit());
                PartitionKeyImpl.this.keyParts.add(keyPart);
            }

            @Override
            public void release() {
            }
        });
    }

    @Override
    public void addShortKey(final Column column, final short s) {
        this.keyPartBuilders.add(new KeyPartBuilderImpl(2){

            @Override
            public void addKeyPart(DbImpl.BufferManager bufferManager) {
                this.bufferManager = bufferManager;
                this.buffer = bufferManager.borrowPartitionKeyPartBuffer(this.length);
                if (this.buffer.capacity() < this.length || this.buffer.position() != 0 || this.buffer.position() + this.length < this.buffer.limit()) {
                    System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!PartitionKeyImpl.addIntKey.addKeyPart() got buffer for length: " + this.length + " buffer: " + this.buffer.capacity() + " " + this.buffer.position() + " " + this.buffer.limit());
                }
                Utility.convertValue(this.buffer, column, s);
                KeyPart keyPart = new KeyPart(this.buffer, this.buffer.limit());
                PartitionKeyImpl.this.keyParts.add(keyPart);
            }

            @Override
            public void release() {
            }
        });
    }

    @Override
    public void addByteKey(final Column column, final byte by) {
        this.keyPartBuilders.add(new KeyPartBuilderImpl(1){

            @Override
            public void addKeyPart(DbImpl.BufferManager bufferManager) {
                this.bufferManager = bufferManager;
                this.buffer = bufferManager.borrowPartitionKeyPartBuffer(this.length);
                if (this.buffer.capacity() < this.length || this.buffer.position() != 0 || this.buffer.position() + this.length < this.buffer.limit()) {
                    System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!PartitionKeyImpl.addByteKey.addKeyPart() got buffer for length: " + this.length + " buffer: " + this.buffer.capacity() + " " + this.buffer.position() + " " + this.buffer.limit());
                }
                Utility.convertValue(this.buffer, column, by);
                KeyPart keyPart = new KeyPart(this.buffer, this.buffer.limit());
                PartitionKeyImpl.this.keyParts.add(keyPart);
            }

            @Override
            public void release() {
            }
        });
    }

    @Override
    public void addLongKey(final Column column, final long l) {
        this.keyPartBuilders.add(new KeyPartBuilderImpl(8){

            @Override
            public void addKeyPart(DbImpl.BufferManager bufferManager) {
                this.bufferManager = bufferManager;
                this.buffer = bufferManager.borrowPartitionKeyPartBuffer(this.length);
                if (this.buffer.capacity() < this.length || this.buffer.position() != 0 || this.buffer.position() + this.length < this.buffer.limit()) {
                    System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!PartitionKeyImpl.addLongKey.addKeyPart() got buffer for length: " + this.length + " buffer: " + this.buffer.capacity() + " " + this.buffer.position() + " " + this.buffer.limit());
                }
                Utility.convertValue(this.buffer, column, l);
                KeyPart keyPart = new KeyPart(this.buffer, this.buffer.limit());
                PartitionKeyImpl.this.keyParts.add(keyPart);
            }

            @Override
            public void release() {
            }
        });
    }

    @Override
    public void addStringKey(final Column column, final String string) {
        this.keyPartBuilders.add(new KeyPartBuilderImpl(0){

            @Override
            public void addKeyPart(DbImpl.BufferManager bufferManager) {
                this.bufferManager = bufferManager;
                ByteBuffer byteBuffer = Utility.encode(string, column, bufferManager);
                this.length = byteBuffer.limit() - byteBuffer.position();
                this.buffer = bufferManager.borrowPartitionKeyPartBuffer(this.length);
                if (this.buffer.capacity() < this.length || this.buffer.position() != 0 || this.buffer.position() + this.length < this.buffer.limit()) {
                    System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!PartitionKeyImpl.addStringKey.addKeyPart() got buffer for length: " + this.length + " buffer: " + this.buffer.capacity() + " " + this.buffer.position() + " " + this.buffer.limit());
                    this.buffer.position(0);
                    this.buffer.limit(this.length);
                }
                this.buffer.put(byteBuffer);
                this.buffer.flip();
                KeyPart keyPart = new KeyPart(this.buffer, this.buffer.limit());
                PartitionKeyImpl.this.keyParts.add(keyPart);
            }

            @Override
            public void release() {
            }
        });
    }

    @Override
    public void addBytesKey(final Column column, final byte[] byArray) {
        this.keyPartBuilders.add(new KeyPartBuilderImpl(byArray.length + 3){

            @Override
            public void addKeyPart(DbImpl.BufferManager bufferManager) {
                this.bufferManager = bufferManager;
                this.buffer = bufferManager.borrowPartitionKeyPartBuffer(this.length);
                if (this.buffer.capacity() < this.length || this.buffer.position() != 0 || this.buffer.position() + this.length < this.buffer.limit()) {
                    System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!PartitionKeyImpl.addBytesKey.addKeyPart() got buffer for length: " + this.length + " buffer: " + this.buffer.capacity() + " " + this.buffer.position() + " " + this.buffer.limit());
                }
                Utility.convertValue(this.buffer, column, byArray);
                KeyPart keyPart = new KeyPart(this.buffer, this.buffer.limit());
                PartitionKeyImpl.this.keyParts.add(keyPart);
            }

            @Override
            public void release() {
            }
        });
    }

    public void setTable(String string) {
        this.tableName = string;
    }

    public void setPartitionId(int n) {
        this.partitionId = n;
    }

    protected void handleError(int n, NdbOperation ndbOperation) {
        if (n == 0) {
            return;
        }
        Utility.throwError(n, ndbOperation.getNdbError());
    }

    protected static void handleError(Object object, NdbOperation ndbOperation) {
        if (object != null) {
            return;
        }
        Utility.throwError(null, ndbOperation.getNdbError());
    }

    public NdbTransaction enlist(DbImpl dbImpl) {
        DbImpl.BufferManager bufferManager = dbImpl.getBufferManager();
        for (KeyPartBuilder object : this.keyPartBuilders) {
            object.addKeyPart(bufferManager);
        }
        Object object = null;
        if (this.keyParts == null || this.keyParts.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("PartitionKeyImpl.enlist via partitionId with keyparts " + (this.keyParts == null ? "null." : "size " + this.keyParts.size()) + " table: " + (this.tableName == null ? "null" : this.tableName) + " partition id: " + this.partitionId);
            }
            object = dbImpl.enlist(this.tableName, this.partitionId);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("PartitionKeyImpl.enlist via keyParts with keyparts " + (this.keyParts == null ? "null." : "size " + this.keyParts.size()) + " table: " + (this.tableName == null ? "null" : this.tableName));
            }
            object = dbImpl.enlist(this.tableName, this.keyParts);
        }
        for (KeyPartBuilder keyPartBuilder : this.keyPartBuilders) {
            keyPartBuilder.release();
        }
        return object;
    }

    public static PartitionKeyImpl getInstance() {
        return theInstance;
    }

    private class KeyPartBuilderImpl
    implements KeyPartBuilder {
        protected ByteBuffer buffer;
        protected DbImpl.BufferManager bufferManager;
        protected int length = 0;

        private KeyPartBuilderImpl(int n) {
            this.length = n;
        }

        @Override
        public void addKeyPart(DbImpl.BufferManager bufferManager) {
        }

        @Override
        public void release() {
            if (this.bufferManager != null && this.buffer != null && this.length != 0) {
                this.bufferManager.returnPartitionKeyPartBuffer(this.length, this.buffer);
            }
        }
    }

    private static interface KeyPartBuilder {
        public void addKeyPart(DbImpl.BufferManager var1);

        public void release();
    }
}

