/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.LockMode;
import com.mysql.clusterj.core.store.ClusterTransaction;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.IndexOperation;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.store.ScanOperation;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.IndexOperationImpl;
import com.mysql.clusterj.tie.IndexScanOperationImpl;
import com.mysql.clusterj.tie.NdbRecordDeleteOperationImpl;
import com.mysql.clusterj.tie.NdbRecordImpl;
import com.mysql.clusterj.tie.NdbRecordIndexScanOperationImpl;
import com.mysql.clusterj.tie.NdbRecordInsertOperationImpl;
import com.mysql.clusterj.tie.NdbRecordKeyOperationImpl;
import com.mysql.clusterj.tie.NdbRecordTableScanOperationImpl;
import com.mysql.clusterj.tie.NdbRecordUniqueKeyOperationImpl;
import com.mysql.clusterj.tie.OperationImpl;
import com.mysql.clusterj.tie.PartitionKeyImpl;
import com.mysql.clusterj.tie.ScanOperationImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import com.mysql.ndbjtie.ndbapi.NdbErrorConst;
import com.mysql.ndbjtie.ndbapi.NdbIndexOperation;
import com.mysql.ndbjtie.ndbapi.NdbIndexScanOperation;
import com.mysql.ndbjtie.ndbapi.NdbOperation;
import com.mysql.ndbjtie.ndbapi.NdbOperationConst;
import com.mysql.ndbjtie.ndbapi.NdbRecordConst;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;
import com.mysql.ndbjtie.ndbapi.NdbTransaction;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class ClusterTransactionImpl
implements ClusterTransaction {
    static final I18NHelper local = I18NHelper.getInstance(ClusterTransactionImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(ClusterTransactionImpl.class);
    protected static final String USE_NDBRECORD_NAME = "com.mysql.clusterj.UseNdbRecord";
    private static boolean USE_NDBRECORD = ClusterJHelper.getBooleanProperty("com.mysql.clusterj.UseNdbRecord", "true");
    protected NdbTransaction ndbTransaction;
    private List<Runnable> postExecuteCallbacks = new ArrayList<Runnable>();
    protected ClusterConnectionImpl clusterConnectionImpl;
    protected DbImpl db;
    protected PartitionKeyImpl partitionKey = PartitionKeyImpl.getInstance();
    private NdbDictionary.Dictionary ndbDictionary;
    private String coordinatedTransactionId = null;
    private static boolean supportsGetCoordinatedTransactionId = true;
    private int findLockMode = 2;
    private int lookupLockMode = 2;
    private int indexScanLockMode = 2;
    private int tableScanLockMode = 2;
    private boolean autocommit = false;
    private boolean autocommitted = false;
    private String joinTransactionId;
    private DbImpl.BufferManager bufferManager;
    private List<Operation> operationsToCheck = new ArrayList<Operation>();
    private boolean isPartitionKeySet = false;
    private final boolean hops_pk_fix = true;

    public ClusterTransactionImpl(ClusterConnectionImpl clusterConnectionImpl, DbImpl dbImpl, NdbDictionary.Dictionary dictionary, String string) {
        this.db = dbImpl;
        this.clusterConnectionImpl = clusterConnectionImpl;
        this.ndbDictionary = dictionary;
        this.joinTransactionId = string;
        this.bufferManager = dbImpl.getBufferManager();
    }

    public ClusterConnectionImpl getClusterConnection() {
        return this.clusterConnectionImpl;
    }

    @Override
    public void close() {
        if (this.ndbTransaction != null) {
            this.ndbTransaction.close();
            this.ndbTransaction = null;
            this.isPartitionKeySet = false;
        }
    }

    @Override
    public void executeCommit() {
        this.executeCommit(true, true);
    }

    @Override
    public boolean isEnlisted() {
        return this.ndbTransaction != null;
    }

    private void enlist() {
        this.db.assertNotClosed("ClusterTransactionImpl.enlist");
        if (logger.isTraceEnabled()) {
            logger.trace("ndbTransaction: " + this.ndbTransaction + " with joinTransactionId: " + this.joinTransactionId);
        }
        if (this.ndbTransaction == null) {
            if (this.coordinatedTransactionId != null) {
                this.ndbTransaction = this.db.joinTransaction(this.coordinatedTransactionId);
            } else {
                this.ndbTransaction = this.partitionKey.enlist(this.db);
                this.getCoordinatedTransactionId(this.db);
            }
        }
    }

    @Override
    public void executeCommit(boolean bl, boolean bl2) {
        this.db.assertNotClosed("ClusterTransactionImpl.executeCommit");
        if (logger.isTraceEnabled()) {
            logger.trace("");
        }
        if (this.isEnlisted() && !this.autocommitted) {
            this.handlePendingPostExecuteCallbacks();
            int n = bl ? 0 : 2;
            int n2 = bl2 ? 1 : 0;
            int n3 = this.ndbTransaction.execute(2, n, n2);
            this.handleError(n3, this.ndbTransaction);
        }
        this.autocommitted = false;
        this.autocommit = false;
    }

    @Override
    public void executeNoCommit() {
        this.executeNoCommit(true, true);
    }

    @Override
    public void executeNoCommit(boolean bl, boolean bl2) {
        this.db.assertNotClosed("ClusterTransactionImpl.executeNoCommit");
        if (logger.isTraceEnabled()) {
            logger.trace("");
        }
        if (!this.isEnlisted()) {
            return;
        }
        if (this.autocommit && this.postExecuteCallbacks.size() == 0) {
            this.executeCommit(bl, bl2);
            this.autocommitted = true;
            return;
        }
        int n = bl ? 0 : 2;
        int n2 = bl2 ? 1 : 0;
        int n3 = this.ndbTransaction.execute(1, n, n2);
        this.handleError(n3, this.ndbTransaction);
        this.performPostExecuteCallbacks();
    }

    @Override
    public void executeRollback() {
        this.db.assertNotClosed("ClusterTransactionImpl.executeRollback");
        if (!this.isEnlisted()) {
            return;
        }
        int n = 2;
        int n2 = 1;
        int n3 = this.ndbTransaction.execute(3, n, n2);
        this.handleError(n3, this.ndbTransaction);
    }

    @Override
    public Operation getDeleteOperation(Table table) {
        this.enlist();
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + table.getName());
        }
        if (USE_NDBRECORD) {
            return new NdbRecordDeleteOperationImpl(this, table);
        }
        NdbDictionary.TableConst tableConst = this.ndbDictionary.getTable(table.getName());
        this.handleError((Object)tableConst, this.ndbDictionary);
        NdbOperation ndbOperation = this.ndbTransaction.getNdbOperation(tableConst);
        this.handleError((Object)ndbOperation, this.ndbTransaction);
        int n = ndbOperation.deleteTuple();
        this.handleError(n, this.ndbTransaction);
        return new OperationImpl(ndbOperation, this);
    }

    @Override
    public Operation getInsertOperation(Table table) {
        this.enlist();
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + table.getName());
        }
        if (USE_NDBRECORD) {
            return new NdbRecordInsertOperationImpl(this, table);
        }
        NdbDictionary.TableConst tableConst = this.ndbDictionary.getTable(table.getName());
        this.handleError((Object)tableConst, this.ndbDictionary);
        NdbOperation ndbOperation = this.ndbTransaction.getNdbOperation(tableConst);
        this.handleError((Object)ndbOperation, this.ndbTransaction);
        int n = ndbOperation.insertTuple();
        this.handleError(n, this.ndbTransaction);
        return new OperationImpl(ndbOperation, this);
    }

    @Override
    public IndexScanOperation getIndexScanOperation(Index index, Table table) {
        this.enlist();
        if (USE_NDBRECORD) {
            return new NdbRecordIndexScanOperationImpl(this, index, table, this.indexScanLockMode);
        }
        NdbDictionary.IndexConst indexConst = this.ndbDictionary.getIndex(index.getInternalName(), table.getName());
        this.handleError((Object)indexConst, this.ndbDictionary);
        NdbIndexScanOperation ndbIndexScanOperation = this.ndbTransaction.getNdbIndexScanOperation(indexConst);
        this.handleError((Object)ndbIndexScanOperation, this.ndbTransaction);
        int n = 0;
        int n2 = this.indexScanLockMode;
        if (n2 != 2) {
            n = 1;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = ndbIndexScanOperation.readTuples(n2, n, n3, n4);
        this.handleError(n5, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + table.getName() + " index: " + index.getName());
        }
        return new IndexScanOperationImpl(table, ndbIndexScanOperation, this);
    }

    @Override
    public IndexScanOperation getIndexScanOperationMultiRange(Index index, Table table) {
        this.enlist();
        if (USE_NDBRECORD) {
            return new NdbRecordIndexScanOperationImpl(this, index, table, true, this.indexScanLockMode);
        }
        NdbDictionary.IndexConst indexConst = this.ndbDictionary.getIndex(index.getInternalName(), table.getName());
        this.handleError((Object)indexConst, this.ndbDictionary);
        NdbIndexScanOperation ndbIndexScanOperation = this.ndbTransaction.getNdbIndexScanOperation(indexConst);
        this.handleError((Object)ndbIndexScanOperation, this.ndbTransaction);
        int n = 0x1000000;
        int n2 = this.indexScanLockMode;
        if (n2 != 2) {
            n |= 1;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = ndbIndexScanOperation.readTuples(n2, n |= 0x8000000, n3, n4);
        this.handleError(n5, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + table.getName() + " index: " + index.getName());
        }
        return new IndexScanOperationImpl(table, ndbIndexScanOperation, this);
    }

    @Override
    public IndexScanOperation getIndexScanOperationLockModeExclusiveScanFlagKeyInfo(Index index, Table table) {
        this.enlist();
        NdbDictionary.IndexConst indexConst = this.ndbDictionary.getIndex(index.getInternalName(), table.getName());
        this.handleError((Object)indexConst, this.ndbDictionary);
        NdbIndexScanOperation ndbIndexScanOperation = this.ndbTransaction.getNdbIndexScanOperation(indexConst);
        this.handleError((Object)ndbIndexScanOperation, this.ndbTransaction);
        int n = 1;
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = ndbIndexScanOperation.readTuples(n, n2, n3, n4);
        this.handleError(n5, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + table.getName() + " index: " + index.getName());
        }
        return new IndexScanOperationImpl(table, ndbIndexScanOperation, this);
    }

    @Override
    public Operation getSelectOperation(Table table) {
        this.enlist();
        if (USE_NDBRECORD) {
            return new NdbRecordKeyOperationImpl(this, table);
        }
        NdbDictionary.TableConst tableConst = this.ndbDictionary.getTable(table.getName());
        this.handleError((Object)tableConst, this.ndbDictionary);
        NdbOperation ndbOperation = this.ndbTransaction.getNdbOperation(tableConst);
        this.handleError((Object)ndbOperation, this.ndbTransaction);
        int n = this.findLockMode;
        int n2 = ndbOperation.readTuple(n);
        this.handleError(n2, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + table.getName());
        }
        return new OperationImpl(table, ndbOperation, this);
    }

    @Override
    public ScanOperation getTableScanOperation(Table table) {
        this.enlist();
        if (USE_NDBRECORD) {
            return new NdbRecordTableScanOperationImpl(this, table, this.tableScanLockMode);
        }
        NdbDictionary.TableConst tableConst = this.ndbDictionary.getTable(table.getName());
        this.handleError((Object)tableConst, this.ndbDictionary);
        NdbScanOperation ndbScanOperation = this.ndbTransaction.getNdbScanOperation(tableConst);
        this.handleError((Object)ndbScanOperation, this.ndbTransaction);
        int n = this.tableScanLockMode;
        int n2 = 0;
        if (n != 2) {
            n2 = 1;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = ndbScanOperation.readTuples(n, n2, n3, n4);
        this.handleError(n5, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + table.getName());
        }
        return new ScanOperationImpl(table, ndbScanOperation, this);
    }

    @Override
    public ScanOperation getTableScanOperationLockModeExclusiveScanFlagKeyInfo(Table table) {
        this.enlist();
        NdbDictionary.TableConst tableConst = this.ndbDictionary.getTable(table.getName());
        this.handleError((Object)tableConst, this.ndbDictionary);
        NdbScanOperation ndbScanOperation = this.ndbTransaction.getNdbScanOperation(tableConst);
        this.handleError((Object)ndbScanOperation, this.ndbTransaction);
        int n = 1;
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = ndbScanOperation.readTuples(n, n2, n3, n4);
        this.handleError(n5, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + table.getName());
        }
        return new ScanOperationImpl(table, ndbScanOperation, this);
    }

    @Override
    public IndexOperation getUniqueIndexOperation(Index index, Table table) {
        this.enlist();
        if (USE_NDBRECORD) {
            return new NdbRecordUniqueKeyOperationImpl(this, index, table);
        }
        NdbDictionary.IndexConst indexConst = this.ndbDictionary.getIndex(index.getInternalName(), table.getName());
        this.handleError((Object)indexConst, this.ndbDictionary);
        NdbIndexOperation ndbIndexOperation = this.ndbTransaction.getNdbIndexOperation(indexConst);
        this.handleError((Object)ndbIndexOperation, this.ndbTransaction);
        int n = this.lookupLockMode;
        int n2 = ndbIndexOperation.readTuple(n);
        this.handleError(n2, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + table.getName() + " index: " + index.getName());
        }
        return new IndexOperationImpl(table, ndbIndexOperation, this);
    }

    @Override
    public IndexOperation getUniqueIndexDeleteOperation(Index index, Table table) {
        this.enlist();
        NdbDictionary.IndexConst indexConst = this.ndbDictionary.getIndex(index.getInternalName(), table.getName());
        this.handleError((Object)indexConst, this.ndbDictionary);
        NdbIndexOperation ndbIndexOperation = this.ndbTransaction.getNdbIndexOperation(indexConst);
        this.handleError((Object)ndbIndexOperation, this.ndbTransaction);
        int n = ndbIndexOperation.deleteTuple();
        this.handleError(n, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + table.getName() + " index: " + index.getName());
        }
        return new IndexOperationImpl(table, ndbIndexOperation, this);
    }

    @Override
    public Operation getUpdateOperation(Table table) {
        this.enlist();
        NdbDictionary.TableConst tableConst = this.ndbDictionary.getTable(table.getName());
        this.handleError((Object)tableConst, this.ndbDictionary);
        NdbOperation ndbOperation = this.ndbTransaction.getNdbOperation(tableConst);
        this.handleError((Object)ndbOperation, this.ndbTransaction);
        int n = ndbOperation.updateTuple();
        this.handleError(n, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + table.getName());
        }
        return new OperationImpl(table, ndbOperation, this);
    }

    @Override
    public IndexOperation getUniqueIndexUpdateOperation(Index index, Table table) {
        this.enlist();
        NdbDictionary.IndexConst indexConst = this.ndbDictionary.getIndex(index.getInternalName(), table.getName());
        this.handleError((Object)indexConst, this.ndbDictionary);
        NdbIndexOperation ndbIndexOperation = this.ndbTransaction.getNdbIndexOperation(indexConst);
        this.handleError((Object)ndbIndexOperation, this.ndbTransaction);
        int n = ndbIndexOperation.updateTuple();
        this.handleError(n, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + table.getName() + " index: " + index.getName());
        }
        return new IndexOperationImpl(table, ndbIndexOperation, this);
    }

    @Override
    public Operation getWriteOperation(Table table) {
        this.enlist();
        NdbDictionary.TableConst tableConst = this.ndbDictionary.getTable(table.getName());
        this.handleError((Object)tableConst, this.ndbDictionary);
        NdbOperation ndbOperation = this.ndbTransaction.getNdbOperation(tableConst);
        this.handleError((Object)ndbOperation, this.ndbTransaction);
        int n = ndbOperation.writeTuple();
        this.handleError(n, this.ndbTransaction);
        if (logger.isTraceEnabled()) {
            logger.trace("Table: " + table.getName());
        }
        return new OperationImpl(table, ndbOperation, this);
    }

    public NdbOperationConst insertTuple(NdbRecordConst ndbRecordConst, ByteBuffer byteBuffer, byte[] byArray, NdbOperation.OperationOptionsConst operationOptionsConst) {
        this.enlist();
        NdbOperationConst ndbOperationConst = this.ndbTransaction.insertTuple(ndbRecordConst, byteBuffer, byArray, operationOptionsConst, 0);
        this.handleError((Object)ndbOperationConst, this.ndbTransaction);
        return ndbOperationConst;
    }

    public NdbScanOperation scanTable(NdbRecordConst ndbRecordConst, byte[] byArray, NdbScanOperation.ScanOptionsConst scanOptionsConst) {
        this.enlist();
        int n = this.tableScanLockMode;
        NdbScanOperation ndbScanOperation = this.ndbTransaction.scanTable(ndbRecordConst, n, byArray, scanOptionsConst, 0);
        this.handleError((Object)ndbScanOperation, this.ndbTransaction);
        return ndbScanOperation;
    }

    public NdbIndexScanOperation scanIndex(NdbRecordConst ndbRecordConst, NdbRecordConst ndbRecordConst2, byte[] byArray, NdbScanOperation.ScanOptions scanOptions) {
        this.enlist();
        NdbIndexScanOperation ndbIndexScanOperation = this.ndbTransaction.scanIndex(ndbRecordConst, ndbRecordConst2, this.indexScanLockMode, byArray, null, scanOptions, 0);
        this.handleError((Object)ndbIndexScanOperation, this.ndbTransaction);
        return ndbIndexScanOperation;
    }

    public NdbOperationConst deleteTuple(NdbRecordConst ndbRecordConst, ByteBuffer byteBuffer, byte[] byArray, NdbOperation.OperationOptionsConst operationOptionsConst) {
        this.enlist();
        NdbOperationConst ndbOperationConst = this.ndbTransaction.deleteTuple(ndbRecordConst, byteBuffer, ndbRecordConst, null, byArray, operationOptionsConst, 0);
        this.handleError((Object)ndbOperationConst, this.ndbTransaction);
        return ndbOperationConst;
    }

    public NdbOperationConst updateTuple(NdbRecordConst ndbRecordConst, ByteBuffer byteBuffer, byte[] byArray, NdbOperation.OperationOptionsConst operationOptionsConst) {
        this.enlist();
        NdbOperationConst ndbOperationConst = this.ndbTransaction.updateTuple(ndbRecordConst, byteBuffer, ndbRecordConst, byteBuffer, byArray, operationOptionsConst, 0);
        this.handleError((Object)ndbOperationConst, this.ndbTransaction);
        return ndbOperationConst;
    }

    public NdbOperationConst writeTuple(NdbRecordConst ndbRecordConst, ByteBuffer byteBuffer, byte[] byArray, NdbOperation.OperationOptionsConst operationOptionsConst) {
        this.enlist();
        NdbOperationConst ndbOperationConst = this.ndbTransaction.writeTuple(ndbRecordConst, byteBuffer, ndbRecordConst, byteBuffer, byArray, operationOptionsConst, 0);
        this.handleError((Object)ndbOperationConst, this.ndbTransaction);
        return ndbOperationConst;
    }

    public NdbOperationConst readTuple(NdbRecordConst ndbRecordConst, ByteBuffer byteBuffer, NdbRecordConst ndbRecordConst2, ByteBuffer byteBuffer2, byte[] byArray, NdbOperation.OperationOptionsConst operationOptionsConst) {
        this.enlist();
        NdbOperationConst ndbOperationConst = this.ndbTransaction.readTuple(ndbRecordConst, byteBuffer, ndbRecordConst2, byteBuffer2, this.findLockMode, byArray, operationOptionsConst, 0);
        this.handleError((Object)ndbOperationConst, this.ndbTransaction);
        return ndbOperationConst;
    }

    @Override
    public void postExecuteCallback(Runnable runnable) {
        this.postExecuteCallbacks.add(runnable);
    }

    private void clearPostExecuteCallbacks() {
        this.postExecuteCallbacks.clear();
    }

    private void handlePendingPostExecuteCallbacks() {
        if (!this.postExecuteCallbacks.isEmpty()) {
            this.executeNoCommit(false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performPostExecuteCallbacks() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Operation object : this.operationsToCheck) {
            int n = object.getErrorCode();
            int n2 = object.getClassification();
            if (n == 0 || object.isReadOperation() && n2 == 2) continue;
            int n3 = object.getMysqlCode();
            int n4 = object.getStatus();
            String string = local.message("ERR_Datastore", -1, n, n3, n4, n2, object.toString());
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        this.operationsToCheck.clear();
        try {
            for (Runnable runnable : this.postExecuteCallbacks) {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    stringBuilder.append(throwable.getMessage());
                    stringBuilder.append('\n');
                }
            }
        }
        finally {
            this.clearPostExecuteCallbacks();
        }
        if (stringBuilder.length() > 0) {
            throw new ClusterJDatastoreException(stringBuilder.toString());
        }
    }

    protected void handleError(int n) {
        if (n == -1) {
            NdbErrorConst ndbErrorConst = this.ndbTransaction.getNdbError();
            String string = this.db.getNdbErrorDetail(ndbErrorConst);
            Utility.throwError(n, ndbErrorConst, string);
        }
    }

    protected void handleError(int n, NdbTransaction ndbTransaction) {
        if (n == 0) {
            return;
        }
        NdbErrorConst ndbErrorConst = ndbTransaction.getNdbError();
        if (ndbErrorConst.code() == 0) {
            return;
        }
        String string = this.db.getNdbErrorDetail(ndbErrorConst);
        Utility.throwError(n, ndbErrorConst, string);
    }

    protected void handleError(Object object, NdbTransaction ndbTransaction) {
        if (object != null) {
            return;
        }
        NdbErrorConst ndbErrorConst = ndbTransaction.getNdbError();
        String string = this.db.getNdbErrorDetail(ndbErrorConst);
        Utility.throwError(null, ndbErrorConst, string);
    }

    protected void handleError(Object object, NdbDictionary.Dictionary dictionary) {
        if (object != null) {
            return;
        }
        NdbErrorConst ndbErrorConst = dictionary.getNdbError();
        String string = this.db.getNdbErrorDetail(ndbErrorConst);
        Utility.throwError(null, ndbErrorConst, string);
    }

    @Override
    public void setPartitionKey(PartitionKey partitionKey) {
        if (partitionKey == null) {
            throw new ClusterJFatalInternalException(local.message("ERR_Partition_Key_Null"));
        }
        if (!this.isPartitionKeySet) {
            this.partitionKey = (PartitionKeyImpl)partitionKey;
            this.isPartitionKeySet = true;
        }
    }

    @Override
    public String getCoordinatedTransactionId() {
        return this.coordinatedTransactionId;
    }

    private void getCoordinatedTransactionId(DbImpl dbImpl) {
        try {
            if (supportsGetCoordinatedTransactionId) {
                if (logger.isDetailEnabled()) {
                    logger.detail("CoordinatedTransactionId: " + this.coordinatedTransactionId);
                }
                throw new ClusterJFatalInternalException("Not Implemented");
            }
        }
        catch (Throwable throwable) {
            supportsGetCoordinatedTransactionId = false;
        }
    }

    @Override
    public void setCoordinatedTransactionId(String string) {
        this.coordinatedTransactionId = string;
    }

    @Override
    public void setLockMode(LockMode lockMode) {
        this.lookupLockMode = this.findLockMode = this.translateLockMode(lockMode);
        this.indexScanLockMode = this.findLockMode;
        this.tableScanLockMode = this.findLockMode;
    }

    private int translateLockMode(LockMode lockMode) {
        switch (lockMode) {
            case READ_COMMITTED: {
                return 2;
            }
            case SHARED: {
                return 0;
            }
            case EXCLUSIVE: {
                return 1;
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Unknown_Lock_Mode", (Object)lockMode));
    }

    @Override
    public void setAutocommit(boolean bl) {
        this.autocommit = bl;
    }

    public DbImpl.BufferManager getBufferManager() {
        return this.bufferManager;
    }

    protected NdbRecordImpl getCachedNdbRecordImpl(DbImpl dbImpl, Table table) {
        return this.clusterConnectionImpl.getCachedNdbRecordImpl(dbImpl, table);
    }

    protected NdbRecordImpl getCachedNdbRecordImpl(DbImpl dbImpl, Index index, Table table) {
        return this.clusterConnectionImpl.getCachedNdbRecordImpl(dbImpl, index, table);
    }

    public void addOperationToCheck(Operation operation) {
        this.operationsToCheck.add(operation);
    }
}

