/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.dtocache;

import com.mysql.clusterj.Session;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DTOCache {
    private final Map<Class, CacheEntry> cacheMap = new HashMap<Class, CacheEntry>();
    CacheEntry unusedCacheObjects;
    CacheObject theFirst;
    CacheObject theLast;
    Session session;
    long theOldestAge;
    long theCurrentAge;
    int theCacheSize;

    public DTOCache(Session session, int n) {
        this.session = session;
        this.theFirst = null;
        this.theLast = null;
        this.theOldestAge = 0L;
        this.theCurrentAge = 0L;
        this.unusedCacheObjects = new CacheEntry();
        for (int i = 0; i < n; ++i) {
            CacheObject cacheObject = new CacheObject();
            this.unusedCacheObjects.add(cacheObject);
        }
    }

    private void removeGlobal(CacheObject cacheObject) {
        if (this.theFirst == cacheObject) {
            if (this.theLast == cacheObject) {
                this.theFirst = null;
                this.theLast = null;
            } else {
                this.theFirst = cacheObject.next_global;
                this.theFirst.prev_global = null;
            }
        } else if (this.theLast == cacheObject) {
            this.theLast = this.theLast.prev_global;
            this.theLast.next_global = null;
            this.theOldestAge = this.theLast.age;
        } else {
            cacheObject.prev_global.next_global = cacheObject.next_global;
            cacheObject.next_global.prev_global = cacheObject.prev_global;
        }
        cacheObject.prev_global = null;
        cacheObject.next_global = null;
    }

    private CacheObject removeLastGlobal() {
        CacheObject cacheObject = this.theLast;
        this.removeGlobal(cacheObject);
        return cacheObject;
    }

    private void insertGlobal(CacheObject cacheObject) {
        cacheObject.next_global = this.theFirst;
        cacheObject.prev_global = null;
        if (this.theFirst == null) {
            this.theLast = cacheObject;
            this.theOldestAge = this.theCurrentAge;
        } else {
            this.theFirst.prev_global = cacheObject;
        }
        this.theFirst = cacheObject;
    }

    public <T> void put(T t, Class<?> clazz) {
        CacheObject cacheObject;
        CacheEntry cacheEntry = this.cacheMap.get(clazz);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry();
            this.cacheMap.put(clazz, cacheEntry);
        }
        if ((cacheObject = this.unusedCacheObjects.get()) == null) {
            if (this.theCurrentAge - this.theOldestAge < (long)(4 * this.theCacheSize)) {
                this.session.release(t);
                return;
            }
            CacheObject cacheObject2 = this.removeLastGlobal();
            CacheEntry cacheEntry2 = this.cacheMap.get(cacheObject2.type);
            cacheEntry2.remove(cacheObject2);
            this.session.release(cacheObject2.elem);
            cacheObject2.elem = null;
            cacheObject2.type = Object.class;
            cacheObject = cacheObject2;
        }
        cacheObject.age = this.theCurrentAge++;
        cacheObject.elem = t;
        cacheObject.type = clazz;
        this.insertGlobal(cacheObject);
        cacheEntry.add(cacheObject);
    }

    public <T> T get(Class<T> clazz) {
        CacheEntry cacheEntry = this.cacheMap.get(clazz);
        if (cacheEntry == null) {
            return null;
        }
        CacheObject cacheObject = cacheEntry.get();
        if (cacheObject == null) {
            return null;
        }
        Object object = cacheObject.elem;
        this.removeGlobal(cacheObject);
        this.unusedCacheObjects.add(cacheObject);
        cacheObject.age = 0L;
        return (T)object;
    }

    private void removeAll(CacheEntry cacheEntry) {
        CacheObject cacheObject;
        while ((cacheObject = cacheEntry.get()) != null) {
            this.session.release(cacheObject.elem);
            this.removeGlobal(cacheObject);
            this.unusedCacheObjects.add(cacheObject);
            cacheObject.age = 0L;
        }
    }

    public <T> void drop(Class<?> clazz) {
        CacheEntry cacheEntry = this.cacheMap.get(clazz);
        if (cacheEntry == null) {
            return;
        }
        this.removeAll(cacheEntry);
        this.cacheMap.remove(clazz);
    }

    public void drop() {
        Set<Map.Entry<Class, CacheEntry>> set = this.cacheMap.entrySet();
        Iterator<Map.Entry<Class, CacheEntry>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Class, CacheEntry> entry = iterator.next();
            CacheEntry cacheEntry = entry.getValue();
            if (cacheEntry == null) {
                return;
            }
            this.removeAll(cacheEntry);
            iterator.remove();
        }
    }

    private class CacheEntry {
        CacheObject theFirst = null;
        CacheObject theLast = null;

        public CacheObject get() {
            CacheObject cacheObject = this.theFirst;
            if (cacheObject != null) {
                this.remove(cacheObject);
            }
            return cacheObject;
        }

        public void add(CacheObject cacheObject) {
            cacheObject.next_class = this.theFirst;
            cacheObject.prev_class = null;
            if (this.theFirst == null) {
                this.theLast = cacheObject;
            } else {
                this.theFirst.prev_class = cacheObject;
            }
            this.theFirst = cacheObject;
        }

        public void remove(CacheObject cacheObject) {
            if (this.theFirst == cacheObject) {
                if (this.theLast == cacheObject) {
                    this.theFirst = null;
                    this.theLast = null;
                } else {
                    this.theFirst = cacheObject.next_class;
                    this.theFirst.prev_class = null;
                }
            } else if (this.theLast == cacheObject) {
                this.theLast = this.theLast.prev_class;
                this.theLast.next_class = null;
            } else {
                cacheObject.prev_class.next_class = cacheObject.next_class;
                cacheObject.next_class.prev_class = cacheObject.prev_class;
            }
            cacheObject.prev_class = null;
            cacheObject.next_class = null;
        }
    }

    private class CacheObject {
        CacheObject next_global = null;
        CacheObject prev_global = null;
        CacheObject next_class = null;
        CacheObject prev_class = null;
        Object elem = null;
        Class<?> type = Object.class;
        long age = 0L;
    }
}

